/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.auth.config;

import net.stepniak.api.auth.repository.KeyRepository;
import net.stepniak.api.auth.repository.SessionRepository;
import net.stepniak.api.auth.repository.UserRepository;
import net.stepniak.api.auth.repository.memory.InMemoryKeyRepository;
import net.stepniak.api.auth.repository.memory.InMemorySessionRepository;
import net.stepniak.api.auth.repository.memory.InMemoryUserRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Profile;

@Configuration
@Profile(value={"memory"})
class InMemoryAuthConfig
implements InitializingBean {
    private static final Logger logger = LoggerFactory.getLogger(InMemoryAuthConfig.class);

    InMemoryAuthConfig() {
    }

    @Bean
    public KeyRepository keyStorage() {
        logger.debug("KeyRepository on memory");
        return new InMemoryKeyRepository();
    }

    @Bean
    public SessionRepository sessionStorage() {
        logger.debug("SessionRepository on memory");
        return new InMemorySessionRepository();
    }

    @Bean
    public UserRepository userStorage() {
        logger.debug("UserRepository on memory");
        return new InMemoryUserRepository();
    }

    public void afterPropertiesSet() throws Exception {
    }
}

