/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.auth;

import net.stepniak.api.auth.entity.UserEntity;
import net.stepniak.api.auth.repository.UserRepository;
import net.stepniak.common.user.AccountType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class UserStore {
    private static final Logger logger = LoggerFactory.getLogger(UserStore.class);
    private UserRepository userStorage;

    public UserStore() {
    }

    @Autowired
    public UserStore(UserRepository userStorage) {
        this.userStorage = userStorage;
    }

    @Transactional
    public UserEntity create(String userName, String email) {
        logger.debug("create(\"{}\", \"{}\")", (Object)userName, (Object)email);
        UserEntity userEntity = new UserEntity(userName, email, AccountType.PICHEESE);
        return (UserEntity)this.userStorage.save(userEntity);
    }

    public UserEntity find(Long id) {
        logger.debug("find id: \"{}\"", (Object)id);
        return (UserEntity)this.userStorage.findOne(id);
    }

    public UserEntity findUser(String email, String userName, AccountType accountType) {
        logger.debug("findUser(\"{}\", \"{}\", {})", new Object[]{email, userName, accountType});
        return this.userStorage.findByEmailAndUserNameAndAccountType(email, userName, accountType.getCode());
    }
}

