/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.auth;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import net.stepniak.api.auth.entity.KeyEntity;
import net.stepniak.api.auth.entity.SessionEntity;
import net.stepniak.api.auth.entity.UserEntity;
import net.stepniak.api.auth.repository.SessionRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class SessionStore {
    private static final Logger logger = LoggerFactory.getLogger(SessionStore.class);
    private SessionRepository sessionStorage;

    public SessionStore() {
    }

    @Autowired
    public SessionStore(SessionRepository sessionStorage) {
        this.sessionStorage = sessionStorage;
    }

    @Transactional
    public SessionEntity create(KeyEntity keyEntity, UserEntity userEntity, String remoteAddr, String forwardedFor) throws NoSuchAlgorithmException {
        String id = this.generateId();
        SessionEntity sessionEntity = new SessionEntity(id, keyEntity);
        sessionEntity.setCreationDate(new Date());
        sessionEntity.setUserEntity(userEntity);
        sessionEntity.setRemoteAddress(remoteAddr);
        sessionEntity.setForwardedFor(forwardedFor);
        logger.debug("create id: \"{}\",", (Object)sessionEntity.getId());
        return (SessionEntity)this.sessionStorage.save(sessionEntity);
    }

    public SessionEntity find(String id) {
        logger.debug("find id: \"{}\"", (Object)id);
        return (SessionEntity)this.sessionStorage.findOne((Serializable)((Object)id));
    }

    private String generateId() throws NoSuchAlgorithmException {
        logger.info("generateSession()");
        String keySalt = "sess" + Math.random() + "logic";
        MessageDigest mDigest = MessageDigest.getInstance("SHA-256");
        byte[] result = mDigest.digest(keySalt.getBytes());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < result.length; ++i) {
            sb.append(Integer.toString((result[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.substring(0, 64);
    }
}

