/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.auth;

import java.io.Serializable;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Date;
import net.stepniak.api.auth.entity.KeyEntity;
import net.stepniak.api.auth.repository.KeyRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
public class KeyStore {
    private static final Logger logger = LoggerFactory.getLogger(KeyStore.class);
    private KeyRepository keyStorage;

    public KeyStore() {
    }

    @Autowired
    public KeyStore(KeyRepository keyStorage) {
        this.keyStorage = keyStorage;
    }

    @Transactional
    public KeyEntity create() throws NoSuchAlgorithmException {
        String id = this.generateId();
        KeyEntity keyEntity = new KeyEntity(id);
        keyEntity.setCreationDate(new Date());
        logger.debug("create id: \"{}\",", (Object)keyEntity.getId());
        return (KeyEntity)this.keyStorage.save(keyEntity);
    }

    public KeyEntity find(String id) {
        logger.debug("find id: \"{}\"", (Object)id);
        return (KeyEntity)this.keyStorage.findOne((Serializable)((Object)id));
    }

    private String generateId() throws NoSuchAlgorithmException {
        logger.info("generateKey()");
        String keySalt = "key" + Math.random() + "logic";
        MessageDigest mDigest = MessageDigest.getInstance("SHA1");
        byte[] result = mDigest.digest(keySalt.getBytes());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < result.length; ++i) {
            sb.append(Integer.toString((result[i] & 0xFF) + 256, 16).substring(1));
        }
        return sb.substring(4, 28);
    }
}

