/*
 * Decompiled with CFR 0.152.
 */
package net.stepniak.api.auth;

import net.stepniak.api.auth.entity.UserEntity;
import net.stepniak.api.auth.exception.auth.AuthException;
import net.stepniak.api.auth.exception.auth.AuthInvalidApiKeyException;
import net.stepniak.api.auth.exception.auth.AuthInvalidSessionIdException;
import net.stepniak.api.auth.exception.auth.AuthMissingApiKeyException;
import net.stepniak.api.auth.exception.auth.AuthMissingSessionIdException;
import net.stepniak.api.auth.exception.auth.AuthUnauthorizedUserException;
import net.stepniak.api.auth.validator.KeyValidator;
import net.stepniak.api.auth.validator.SessionValidator;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class Auth {
    private static final Logger logger = LoggerFactory.getLogger(Auth.class);
    @Autowired
    private SessionValidator sessionValidator;
    @Autowired
    private KeyValidator keyValidator;

    public String validateSessionId(String sessionId) throws AuthException {
        if (StringUtils.isEmpty((String)sessionId)) {
            throw new AuthMissingSessionIdException();
        }
        if (!this.sessionValidator.isValid(sessionId)) {
            logger.info("Invalid sessionId: {}", (Object)sessionId);
            throw new AuthInvalidSessionIdException();
        }
        return sessionId;
    }

    public UserEntity getAuthorizedUser(String sessionId) throws AuthException {
        UserEntity userEntity = this.sessionValidator.getUserLogic(sessionId = this.validateSessionId(sessionId));
        if (userEntity == null) {
            logger.info("Not authorized user for sessionId: {}", (Object)sessionId);
            throw new AuthUnauthorizedUserException();
        }
        return userEntity;
    }

    public String validateApiKey(String key) throws AuthException {
        if (StringUtils.isEmpty((String)key)) {
            throw new AuthMissingApiKeyException();
        }
        if (!this.keyValidator.isValid(key)) {
            logger.info("Invalid api key: {}", (Object)key);
            throw new AuthInvalidApiKeyException();
        }
        return key;
    }
}

