/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner.model;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.pool.IPoolManager;
import net.ssehub.easy.basics.pool.Pool;
import net.ssehub.easy.reasoning.sseReasoner.functions.FailedElements;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueDoesNotMatchTypeException;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.persistency.StringProvider;

public class ReasoningUtils {
    public static final boolean DEBUG = true;
    public static final Pool<Set<Compound>> SET_COMPOUND_POOL = new Pool((IPoolManager)new IPoolManager<Set<Compound>>(){

        public Set<Compound> create() {
            return new HashSet<Compound>();
        }

        public void clear(Set<Compound> instance) {
            instance.clear();
        }
    });
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(ReasoningUtils.class, "net.ssehub.easy.reasoning.sseReasoner");

    public static IDatatype inferTypeSafe(ConstraintSyntaxTree cst, IDatatype dflt) {
        IDatatype result = dflt;
        try {
            result = cst.inferDatatype();
        }
        catch (CSTSemanticException e) {
            LOGGER.error(StringProvider.toIvmlString((ConstraintSyntaxTree)cst));
            LOGGER.exception((Exception)((Object)e));
        }
        return result;
    }

    public static Value createTypeValue(IDatatype type) throws ValueDoesNotMatchTypeException {
        return ValueFactory.createValue((IDatatype)MetaType.TYPE, (Object[])new Object[]{type});
    }

    public static ConstraintSyntaxTree createTypeValueConstant(IDatatype type) throws ValueDoesNotMatchTypeException {
        return new ConstantValue(ReasoningUtils.createTypeValue(type));
    }

    public static void setValue(IDecisionVariable var, Constraint value) {
        try {
            Value cstVal = ValueFactory.createValue((IDatatype)ConstraintType.TYPE, (Object[])new Object[]{value.getConsSyntax()});
            var.setValue(cstVal, var.getState());
        }
        catch (ConfigurationException e) {
            LOGGER.exception((Exception)((Object)e));
        }
        catch (ValueDoesNotMatchTypeException e) {
            LOGGER.exception((Exception)((Object)e));
        }
    }

    public static ConstraintSyntaxTree createTypeValueConstantSafe(IDatatype type) {
        ConstraintSyntaxTree result = null;
        try {
            result = ReasoningUtils.createTypeValueConstant(type);
        }
        catch (ValueDoesNotMatchTypeException e) {
            LOGGER.exception((Exception)((Object)e));
        }
        return result;
    }

    public static ConstraintSyntaxTree createAsTypeCast(ConstraintSyntaxTree exp, IDatatype targetType) {
        return ReasoningUtils.createAsTypeCast(exp, null, targetType);
    }

    public static ConstraintSyntaxTree createAsTypeCast(ConstraintSyntaxTree exp, IDatatype sourceType, IDatatype targetType) {
        ConstraintSyntaxTree res = exp;
        if (null != targetType && sourceType != targetType) {
            try {
                IDatatype expType = exp.inferDatatype();
                if (!(TypeQueries.sameTypes((IDatatype)sourceType, (IDatatype)targetType) || TypeQueries.sameTypes((IDatatype)expType, (IDatatype)targetType) || TypeQueries.isAnyType((IDatatype)targetType))) {
                    res = new OCLFeatureCall(res, "asType", new ConstraintSyntaxTree[]{ReasoningUtils.createTypeValueConstant(targetType)});
                }
            }
            catch (CSTSemanticException e) {
                LOGGER.exception((Exception)((Object)e));
            }
            catch (ValueDoesNotMatchTypeException e) {
                LOGGER.exception((Exception)((Object)e));
            }
        }
        return res;
    }

    public static void printProblemPoints(Set<IDecisionVariable> problemVariables) {
        if (problemVariables.size() > 0) {
            LOGGER.info("Problem points: ");
            for (IDecisionVariable problem : problemVariables) {
                LOGGER.info(problem + "; ");
            }
        }
    }

    public static String toStringAttributes(IDecisionVariable variable) {
        String attributes = "Attributes: ";
        for (int i = 0; i < variable.getAttributesCount(); ++i) {
            attributes = attributes + variable.getAttribute(i).toString() + " : " + variable.getAttribute(i).getState() + " : " + variable.getAttribute(i).getValue() + "; ";
        }
        return attributes;
    }

    public static void printModelElement(IDecisionVariable variable) {
        if (variable.getState() != null) {
            LOGGER.debug(variable.getDeclaration() + " : " + variable.getState().toString() + " : " + variable.getValue() + " | " + ReasoningUtils.toStringAttributes(variable));
            if (variable.getNestedElementsCount() > 0) {
                for (int i = 0; i < variable.getNestedElementsCount(); ++i) {
                    ReasoningUtils.printModelElement(variable.getNestedElement(i));
                }
            }
        }
    }

    public static String toIvmlString(Constraint constraint) {
        return ReasoningUtils.toIvmlString(constraint.getConsSyntax());
    }

    public static String toIvmlString(ConstraintSyntaxTree cst) {
        return null == cst ? "-" : StringProvider.toIvmlString((ConstraintSyntaxTree)cst);
    }

    public static void printModelElements(Configuration config, String comment) {
        LOGGER.debug("-------------------");
        LOGGER.debug(comment);
        for (IDecisionVariable variable : config) {
            ReasoningUtils.printModelElement(variable);
        }
    }

    public static void printConstraints(String text, Iterable<Constraint> constraints) {
        if (null != text) {
            System.out.println("> " + text);
        }
        int count = 0;
        for (Constraint c : constraints) {
            System.out.println(count++ + " " + StringProvider.toIvmlString((ConstraintSyntaxTree)c.getConsSyntax()) + " : " + c.getTopLevelParent() + " : " + System.identityHashCode(c));
        }
        if (null != text) {
            System.out.println("< " + text);
        }
    }

    public static void printFailedElements(FailedElements failedElements) {
        if (failedElements.hasProblems()) {
            if (failedElements.problemConstraintCount() > 0) {
                Iterator<Constraint> failedConstraints = failedElements.getProblemConstraints();
                while (failedConstraints.hasNext()) {
                    Constraint failedRule = failedConstraints.next();
                    LOGGER.debug("Failed constraint: " + ReasoningUtils.toIvmlString(failedRule));
                }
            }
            if (failedElements.problemVariabletCount() > 0) {
                Iterator<AbstractVariable> failedVariables = failedElements.getProblemVariables();
                while (failedVariables.hasNext()) {
                    AbstractVariable failedVariable = failedVariables.next();
                    LOGGER.debug("Failed variable: " + failedVariable);
                }
            }
        }
    }

    public static ContainerOperationCall createContainerCall(ConstraintSyntaxTree container, Operation op, ConstraintSyntaxTree iterEx, DecisionVariableDeclaration ... decl) {
        return new ContainerOperationCall(container, op.getName(), iterEx, decl);
    }

    public static boolean isOverriddenSlot(AbstractVariable decl) {
        IModelElement iter;
        boolean overridden = false;
        for (iter = decl.getParent(); null != iter && !(iter instanceof Compound); iter = iter.getParent()) {
        }
        if (iter instanceof Compound) {
            overridden = ReasoningUtils.countSlots((Compound)iter, decl.getName(), true) > 1;
        }
        return overridden;
    }

    public static int countSlots(Compound cmp, String name, boolean stopGreater1) {
        int result = 0;
        if (null != cmp.getElement(name)) {
            ++result;
        }
        for (int r = 0; !(r >= cmp.getRefinesCount() || stopGreater1 && (result += ReasoningUtils.countSlots(cmp.getRefines(r), name, stopGreater1)) > 1); ++r) {
        }
        return result;
    }

    public static boolean isNestedContainer(IDatatype type) {
        return TypeQueries.isContainer((IDatatype)type) && 1 == type.getGenericTypeCount() && TypeQueries.isContainer((IDatatype)type.getGenericType(0));
    }

    public static Value getRelevantValue(AbstractVariable decl, IDecisionVariable var, boolean incremental) {
        ConstraintSyntaxTree dflt;
        Value val = null;
        if (null != var && null != var.getValue()) {
            val = var.getValue();
        } else if (!incremental && (dflt = decl.getDefaultValue()) instanceof ConstantValue) {
            val = ((ConstantValue)dflt).getConstantValue();
        }
        return val;
    }

    public static <D extends Value> D getRelevantValue(AbstractVariable decl, IDecisionVariable var, boolean incremental, Class<D> filter) {
        Value val = ReasoningUtils.getRelevantValue(decl, var, incremental);
        Value result = filter.isInstance(val) ? (Value)filter.cast(val) : null;
        return (D)result;
    }

    public static void addRefines(Compound cmp, Set<Compound> result) {
        result.add(cmp);
        int n = cmp.getRefinesCount();
        for (int r = 0; r < n; ++r) {
            ReasoningUtils.addRefines(cmp.getRefines(r), result);
        }
    }

    public static boolean getUsedCompoundTypes(Value val, Set<Compound> result) {
        boolean done = false;
        if (val instanceof ContainerValue) {
            ContainerValue cVal = (ContainerValue)val;
            for (int v = 0; v < cVal.getElementSize(); ++v) {
                IDatatype tType;
                Value tmp = cVal.getElement(v);
                if (ReasoningUtils.getUsedCompoundTypes(tmp, result) || !((tType = DerivedDatatype.resolveToBasis((IDatatype)tmp.getType())) instanceof Compound)) continue;
                result.add((Compound)tType);
            }
            done = true;
        }
        return done;
    }

    public static void purgeRefines(Set<Compound> compounds, Set<Compound> result) {
        result.addAll(compounds);
        for (Compound c : compounds) {
            ReasoningUtils.purgeRefines(c, result);
        }
    }

    private static void purgeRefines(Compound comp, Set<Compound> result) {
        for (int r = 0; r < comp.getRefinesCount(); ++r) {
            Compound ref = comp.getRefines(r);
            result.remove(ref);
            ReasoningUtils.purgeRefines(ref, result);
        }
    }

    public static <T, S extends T> void addAll(Collection<T> target, S[] source) {
        if (source != null) {
            int n = source.length;
            for (int s = 0; s < n; ++s) {
                target.add(source[s]);
            }
        }
    }

    public static IDatatype getDeepestContainedType(Container cnt) {
        IDatatype result = cnt.getContainedType();
        if (result instanceof Container) {
            result = ReasoningUtils.getDeepestContainedType((Container)result);
        }
        return result;
    }

    public static void printConstraintEvaluationResult(Constraint constraint, EvaluationVisitor evaluator) {
        ConstraintSyntaxTree cst = constraint.getConsSyntax();
        System.out.println("EVAL " + StringProvider.toIvmlString((ConstraintSyntaxTree)cst) + " " + constraint.getType() + " fulfilled " + evaluator.constraintFulfilled() + " failed " + evaluator.constraintFailed());
        for (int m = 0; m < evaluator.getMessageCount(); ++m) {
            EvaluationVisitor.Message msg = evaluator.getMessage(m);
            System.out.println("  MSG: " + msg.getDescription() + " " + msg.getStatus() + " " + msg.getVariable());
        }
    }

    public static ConstraintSyntaxTree getConstraintValueExpression(Value value) {
        ConstraintSyntaxTree cst = null;
        if (value instanceof ConstraintValue) {
            cst = ((ConstraintValue)value).getValue();
        } else if (null != value && BooleanType.TYPE.isAssignableFrom(value.getType())) {
            cst = new ConstantValue(value);
        }
        return cst;
    }

    public static void removeAll(Collection<Constraint> collection, Collection<Constraint> remove) {
        for (Constraint cst : remove) {
            if (!collection.remove(cst)) continue;
            System.out.println("REMOVED " + ReasoningUtils.toIvmlString(cst));
        }
    }

    public static <K> void removeAll(Map<K, ?> map, Collection<K> remove) {
        for (K cst : remove) {
            map.remove(cst);
        }
    }

    public static Set<Compound> collectRefines(IDatatype start, IDatatype exclude) {
        Set result = (Set)SET_COMPOUND_POOL.getInstance();
        if (start instanceof Compound) {
            ReasoningUtils.collectRefines((Compound)start, exclude, true, result);
        }
        return result;
    }

    private static void collectRefines(Compound cmp, IDatatype exclude, boolean add, Set<Compound> result) {
        boolean bl = add = exclude != cmp;
        if (add) {
            result.add(cmp);
        } else {
            result.remove(cmp);
        }
        for (int r = 0; r < cmp.getRefinesCount(); ++r) {
            ReasoningUtils.collectRefines(cmp.getRefines(r), exclude, add, result);
        }
    }

    public static ConstraintSyntaxTree createParentExpression(IDecisionVariable variable) {
        Object result = null;
        IConfigurationElement parent = variable.getParent();
        if (parent instanceof IDecisionVariable) {
            ConstraintSyntaxTree parentAcc = ReasoningUtils.createParentExpression((IDecisionVariable)parent);
            result = variable.getDeclaration() instanceof Attribute ? new AttributeVariable(parentAcc, (Attribute)variable.getDeclaration()) : new CompoundAccess(parentAcc, variable.getDeclaration().getName());
        } else {
            result = new Variable(variable.getDeclaration());
        }
        return result;
    }

    public static <K, V> Map<K, V> copyMapNull(Map<K, V> source) {
        HashMap<K, V> result;
        if (null != source && source.size() > 0) {
            result = new HashMap<K, V>(source.size());
            result.putAll(source);
        } else {
            result = null;
        }
        return result;
    }
}

