/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner.functions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.reasoning.sseReasoner.functions.FailedElementDetails;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;

public class FailedElements {
    private Map<Constraint, FailedElementDetails> problemConstraints = new HashMap<Constraint, FailedElementDetails>();
    private Map<AbstractVariable, FailedElementDetails> problemVariables = new HashMap<AbstractVariable, FailedElementDetails>();
    private List<EvaluationVisitor.Message> messages = new ArrayList<EvaluationVisitor.Message>();

    public void addProblemConstraint(Constraint constraint, FailedElementDetails details) {
        this.problemConstraints.put(constraint, details);
    }

    public void removeProblemConstraint(Constraint constraint) {
        this.problemConstraints.remove(constraint);
    }

    public void addMessage(EvaluationVisitor.Message message) {
        this.messages.add(message);
    }

    public void removeProblemConstraints(List<Constraint> constraints) {
        int n = constraints.size();
        for (int c = 0; c < n; ++c) {
            this.problemConstraints.remove(constraints.get(c));
        }
    }

    public void addProblemVariable(AbstractVariable variable, FailedElementDetails details) {
        this.problemVariables.put(variable, details);
    }

    public boolean hasProblems() {
        boolean messageProblem = false;
        for (int m = 0; !messageProblem && m < this.messages.size(); ++m) {
            messageProblem = this.messages.get(m).getStatus() == Status.ERROR;
        }
        return messageProblem || !this.problemConstraints.isEmpty() || !this.problemVariables.isEmpty();
    }

    public int problemCount() {
        return this.problemConstraintCount() + this.problemVariabletCount();
    }

    public int problemConstraintCount() {
        return this.problemConstraints.size();
    }

    public int problemVariabletCount() {
        return this.problemVariables.size();
    }

    public Iterator<Constraint> getProblemConstraints() {
        return this.problemConstraints.keySet().iterator();
    }

    public Map<Constraint, FailedElementDetails> getProblemConstraintMap() {
        return this.problemConstraints;
    }

    public Iterator<AbstractVariable> getProblemVariables() {
        return this.problemVariables.keySet().iterator();
    }

    public Iterator<EvaluationVisitor.Message> getMessages() {
        return this.messages.iterator();
    }

    public Map<AbstractVariable, FailedElementDetails> getProblemVariableMap() {
        return this.problemVariables;
    }

    public void clear() {
        this.problemConstraints.clear();
        this.problemVariables.clear();
        this.messages.clear();
    }
}

