/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner.functions;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.persistency.StringProvider;

public class DefaultValueTranslator {
    public static ConstraintSyntaxTree translateDefaultValueSafe(ConstraintSyntaxTree cst) {
        try {
            return DefaultValueTranslator.translateDefaultValue(cst);
        }
        catch (CSTSemanticException e) {
            EASyLoggerFactory.INSTANCE.getLogger(DefaultValueTranslator.class, "Cannot translate default value for " + StringProvider.toIvmlString((ConstraintSyntaxTree)cst) + ": " + e.getMessage());
            return cst;
        }
    }

    public static ConstraintSyntaxTree translateDefaultValue(ConstraintSyntaxTree cst) throws CSTSemanticException {
        ConstraintSyntaxTree result = cst;
        if (cst instanceof CompoundInitializer) {
            CompoundInitializer init = (CompoundInitializer)cst;
            HashMap<String, ConstraintSyntaxTree> values = new HashMap<String, ConstraintSyntaxTree>();
            HashMap<String, AbstractVariable> decls = new HashMap<String, AbstractVariable>();
            for (int s = 0; s < init.getSlotCount(); ++s) {
                String slotName = init.getSlot(s);
                values.put(slotName, DefaultValueTranslator.translateDefaultValue(init.getExpression(s)));
                decls.put(slotName, init.getSlotDeclaration(s));
            }
            DefaultValueTranslator.translateDefaultValues(init.getType(), values, decls);
            result = DefaultValueTranslator.createTranslatedCompoundInitializer(init.getType(), values, decls);
        } else if (cst instanceof ContainerInitializer) {
            ContainerInitializer init = (ContainerInitializer)cst;
            IDatatype containedType = init.getType().getContainedType();
            if (TypeQueries.isCompound((IDatatype)containedType) || TypeQueries.isContainer((IDatatype)containedType)) {
                ConstraintSyntaxTree[] inits = new ConstraintSyntaxTree[init.getExpressionCount()];
                for (int e = 0; e < inits.length; ++e) {
                    inits[e] = DefaultValueTranslator.translateDefaultValue(init.getExpression(e));
                }
                result = new ContainerInitializer(init.getType(), inits);
            }
        } else if (cst instanceof ConstantValue) {
            ContainerValue compValue;
            IDatatype containedType;
            Value cValue = ((ConstantValue)cst).getConstantValue();
            if (cValue instanceof CompoundValue) {
                CompoundValue compValue2 = (CompoundValue)cValue;
                Compound compType = (Compound)compValue2.getType();
                HashMap<String, ConstraintSyntaxTree> values = new HashMap<String, ConstraintSyntaxTree>();
                HashMap<String, AbstractVariable> decls = new HashMap<String, AbstractVariable>();
                for (String slotName : compValue2.getSlotNames()) {
                    Value slotValue = compValue2.getNestedValue(slotName);
                    if (null == slotValue) continue;
                    values.put(slotName, DefaultValueTranslator.translateDefaultValue((ConstraintSyntaxTree)new ConstantValue(slotValue)));
                    decls.put(slotName, (AbstractVariable)compType.getElement(slotName));
                }
                DefaultValueTranslator.translateDefaultValues(compType, values, decls);
                result = DefaultValueTranslator.createTranslatedCompoundInitializer(compType, values, decls);
            } else if (cValue instanceof ContainerValue && (TypeQueries.isCompound((IDatatype)(containedType = (compValue = (ContainerValue)cValue).getContainedType())) || TypeQueries.isContainer((IDatatype)containedType))) {
                ConstraintSyntaxTree[] inits = new ConstraintSyntaxTree[compValue.getElementSize()];
                for (int e = 0; e < inits.length; ++e) {
                    Value val = compValue.getElement(e);
                    inits[e] = DefaultValueTranslator.translateDefaultValue((ConstraintSyntaxTree)new ConstantValue(val));
                }
                result = new ContainerInitializer((Container)compValue.getType(), inits);
            }
        }
        return result;
    }

    private static void translateDefaultValues(Compound type, Map<String, ConstraintSyntaxTree> values, Map<String, AbstractVariable> decls) throws CSTSemanticException {
        for (int d = 0; d < type.getDeclarationCount(); ++d) {
            DecisionVariableDeclaration slotDecl = type.getDeclaration(d);
            String slotName = slotDecl.getName();
            ConstraintSyntaxTree dflt = slotDecl.getDefaultValue();
            if (values.containsKey(slotName) || dflt == null) continue;
            values.put(slotName, DefaultValueTranslator.translateDefaultValue(dflt));
            decls.put(slotName, (AbstractVariable)slotDecl);
        }
        for (int r = 0; r < type.getRefinesCount(); ++r) {
            DefaultValueTranslator.translateDefaultValues(type.getRefines(r), values, decls);
        }
    }

    private static CompoundInitializer createTranslatedCompoundInitializer(Compound type, Map<String, ConstraintSyntaxTree> values, Map<String, AbstractVariable> decls) throws CSTSemanticException {
        String[] slotNames = new String[values.size()];
        AbstractVariable[] slotDeclarations = new AbstractVariable[values.size()];
        ConstraintSyntaxTree[] slotExpressions = new ConstraintSyntaxTree[values.size()];
        int s = 0;
        for (Map.Entry<String, ConstraintSyntaxTree> v : values.entrySet()) {
            slotNames[s] = v.getKey();
            slotDeclarations[s] = decls.get(slotNames[s]);
            slotExpressions[s] = v.getValue();
            if (slotExpressions[s] instanceof OCLFeatureCall && !ConstraintType.isConstraint((IDatatype)slotDeclarations[s].getType())) {
                slotExpressions[s] = new DeferInitExpression(slotExpressions[s]);
            }
            ++s;
        }
        return new CompoundInitializer(type, slotNames, slotDeclarations, slotExpressions);
    }
}

