/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner.model;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.reasoning.core.reasoner.ConstraintList;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;

public class VariablesMap {
    private Map<AbstractVariable, Set<Constraint>> declConstraintMapping;
    private Map<Constraint, IDecisionVariable> constraintVariableMap = new HashMap<Constraint, IDecisionVariable>();
    private Map<IDecisionVariable, List<Constraint>> variableConstraintsMap = new HashMap<IDecisionVariable, List<Constraint>>();

    public VariablesMap() {
        this.declConstraintMapping = new HashMap<AbstractVariable, Set<Constraint>>();
    }

    public void add(AbstractVariable declaration, Constraint constraint) {
        this.obtainConstraintSet(declaration).add(constraint);
    }

    public void remove(AbstractVariable declaration, Constraint constraint) {
        Set<Constraint> relevantConstraints = this.declConstraintMapping.get(declaration);
        if (relevantConstraints != null) {
            relevantConstraints.remove(constraint);
        }
    }

    private Set<Constraint> obtainConstraintSet(AbstractVariable declaration) {
        Set<Constraint> relevantConstraints = this.declConstraintMapping.get(declaration);
        if (null == relevantConstraints) {
            relevantConstraints = new HashSet<Constraint>();
            this.declConstraintMapping.put(declaration, relevantConstraints);
        }
        return relevantConstraints;
    }

    public Set<Constraint> getRelevantConstraints(AbstractVariable declaration) {
        return this.declConstraintMapping.get(declaration);
    }

    public int getDeclarationSize() {
        return this.declConstraintMapping.size();
    }

    public void clear() {
        this.declConstraintMapping.clear();
        this.variableConstraintsMap.clear();
        this.constraintVariableMap.clear();
    }

    public void addAll(IDecisionVariable variable, ConstraintList constraints) {
        for (IDecisionVariable iter = variable; iter != null; iter = iter.getParent()) {
            if (!(iter instanceof IDecisionVariable)) continue;
            this.addAll(iter.getDeclaration(), constraints);
        }
    }

    public void addAll(AbstractVariable declaration, ConstraintList constraints) {
        constraints.toCollection(this.obtainConstraintSet(declaration));
    }

    public void removeAll(IDecisionVariable variable, Collection<Constraint> constraints) {
        for (IDecisionVariable iter = variable; iter != null; iter = iter.getParent()) {
            if (!(iter instanceof IDecisionVariable)) continue;
            this.removeAll(iter.getDeclaration(), constraints);
        }
        for (Constraint cst : constraints) {
            IDecisionVariable var = this.constraintVariableMap.remove(cst);
            if (null == var) continue;
            this.variableConstraintsMap.remove(var);
        }
    }

    public void removeAll(AbstractVariable declaration, Collection<Constraint> constraints) {
        Set<Constraint> relevantConstraints = this.declConstraintMapping.get(declaration);
        if (null != relevantConstraints) {
            relevantConstraints.removeAll(constraints);
        }
    }

    public void registerConstraint(IDecisionVariable variable, Constraint constraint) {
        this.constraintVariableMap.put(constraint, variable);
        List<Constraint> constraints = this.variableConstraintsMap.get(variable);
        if (null == constraints) {
            constraints = new ArrayList<Constraint>();
            this.variableConstraintsMap.put(variable, constraints);
        }
        constraints.add(constraint);
    }

    public void unregisterConstraint(IDecisionVariable variable, Constraint constraint) {
        List<Constraint> constraints = this.getConstraintsForVariable((IConfigurationElement)variable);
        if (null != constraints) {
            constraints.remove(constraint);
        }
    }

    public List<Constraint> getConstraintsForVariable(IConfigurationElement variable) {
        return this.variableConstraintsMap.get(variable);
    }

    public IDecisionVariable getDecisionVariableForConstraint(Constraint constraint) {
        return this.constraintVariableMap.get(constraint);
    }

    public void copyFrom(VariablesMap map) {
        AbstractCollection tmp;
        this.constraintVariableMap.putAll(map.constraintVariableMap);
        for (Map.Entry<IDecisionVariable, List<Constraint>> entry : map.variableConstraintsMap.entrySet()) {
            tmp = new ArrayList(entry.getValue());
            this.variableConstraintsMap.put(entry.getKey(), (List<Constraint>)((Object)tmp));
        }
        for (Map.Entry<Object, Collection<Constraint>> entry : map.declConstraintMapping.entrySet()) {
            tmp = new HashSet<Constraint>(entry.getValue());
            map.declConstraintMapping.put((AbstractVariable)entry.getKey(), (Set<Constraint>)((Object)tmp));
        }
    }
}

