/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner.model;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.reasoning.sseReasoner.model.ContextStack;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BasicCopyVisitor;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.DeferInitExpression;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IAttributableElement;

public class SubstitutionVisitor
extends BasicCopyVisitor {
    private Map<AbstractVariable, ConstraintSyntaxTree> mapping;
    private ContextStack globalMapping;
    private ConstraintSyntaxTree selfEx;
    private AbstractVariable self;
    private boolean containsSelf;
    private ConstraintSyntaxTree excludeFromMapping;

    public SubstitutionVisitor() {
        this(null);
    }

    public SubstitutionVisitor(ContextStack globalMapping) {
        this.setDoInferDatatype(false);
        this.setCopyConstants(false);
        this.setCopyExpressions(false);
        this.setMappings(globalMapping);
    }

    public void setMappings(ContextStack globalMapping) {
        this.globalMapping = globalMapping;
    }

    public boolean containsSelf() {
        return this.containsSelf;
    }

    public void clear() {
        super.clear();
        this.containsSelf = false;
        this.globalMapping = null;
        this.selfEx = null;
        this.self = null;
        this.excludeFromMapping = null;
        this.clearVariableMapping();
    }

    public SubstitutionVisitor addVariableMapping(AbstractVariable orig, AbstractVariable dest, int derefCount) {
        ConstraintSyntaxTree ca;
        ConstraintSyntaxTree destEx = null;
        if (null != this.globalMapping && null != (ca = this.globalMapping.getMapping(dest))) {
            destEx = ca;
        }
        if (null == destEx) {
            if (dest instanceof Attribute) {
                Attribute att = (Attribute)dest;
                IAttributableElement elt = att.getElement();
                Variable qualifier = null;
                if (elt instanceof DecisionVariableDeclaration) {
                    qualifier = new Variable((AbstractVariable)((DecisionVariableDeclaration)elt));
                }
                destEx = new AttributeVariable((ConstraintSyntaxTree)qualifier, (Attribute)dest);
            } else {
                destEx = new Variable(dest);
            }
        }
        if (null != orig) {
            for (int d = 1; d <= derefCount; ++d) {
                destEx = new OCLFeatureCall(destEx, "refBy", new ConstraintSyntaxTree[0]);
            }
            this.addVariableMapping(orig, destEx);
        }
        return this;
    }

    public SubstitutionVisitor addVariableMapping(AbstractVariable orig, ConstraintSyntaxTree ex) {
        if (null == this.mapping) {
            this.mapping = new HashMap<AbstractVariable, ConstraintSyntaxTree>();
        }
        this.mapping.put(orig, ex);
        return this;
    }

    public SubstitutionVisitor clearVariableMapping(AbstractVariable var) {
        if (null != this.mapping && null != var) {
            this.mapping.remove(var);
        }
        return this;
    }

    public SubstitutionVisitor clearVariableMapping() {
        if (null != this.mapping) {
            this.mapping.clear();
        }
        return this;
    }

    public SubstitutionVisitor setSelf(ConstraintSyntaxTree selfEx) {
        this.selfEx = selfEx;
        return this;
    }

    public SubstitutionVisitor setSelf(AbstractVariable self) {
        this.self = self;
        return this;
    }

    public ConstraintSyntaxTree accept(ConstraintSyntaxTree cst) {
        cst.accept((IConstraintTreeVisitor)this);
        return this.getResult();
    }

    public ConstraintSyntaxTree acceptAndClear(ConstraintSyntaxTree cst) {
        cst.accept((IConstraintTreeVisitor)this);
        ConstraintSyntaxTree result = this.getResult();
        this.clear();
        return result;
    }

    public void visitAnnotationVariable(AttributeVariable variable) {
        Object result = variable.getQualifier() != null ? variable : this.map((Variable)variable);
        if (null == result || result == variable) {
            super.visitAnnotationVariable(variable);
        } else {
            this.setResult((ConstraintSyntaxTree)result);
        }
    }

    public void visitVariable(Variable variable) {
        this.setResult(this.map(variable));
    }

    private ConstraintSyntaxTree map(Variable variable) {
        Variable res = null;
        if (variable != this.excludeFromMapping) {
            if (null != this.mapping) {
                res = this.mapping.get(variable.getVariable());
            }
            if (null == res) {
                ConstraintSyntaxTree tmp;
                ConstraintSyntaxTree constraintSyntaxTree = tmp = null == this.globalMapping ? null : this.globalMapping.getMapping(variable.getVariable());
                if (null != tmp) {
                    res = this.inferDatatype(tmp);
                }
            }
        }
        if (null == res) {
            res = variable;
        }
        return res;
    }

    public void excludeFromMapping(ConstraintSyntaxTree cst) {
        this.excludeFromMapping = cst;
    }

    public void visitCompoundAccess(CompoundAccess access) {
        super.visitCompoundAccess(access);
    }

    public void visitComment(Comment comment) {
    }

    public void visitSelf(Self self) {
        if (null == this.selfEx && null != this.self) {
            this.selfEx = new Variable(this.self);
        }
        if (this.selfEx != null) {
            this.setResult(this.selfEx);
        } else {
            this.setResult((ConstraintSyntaxTree)self);
        }
        this.containsSelf = true;
    }

    public void visitDeferInitExpression(DeferInitExpression expression) {
        expression.getExpression().accept((IConstraintTreeVisitor)this);
    }
}

