/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner.model;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.pool.IPoolManager;
import net.ssehub.easy.basics.pool.Pool;
import net.ssehub.easy.reasoning.sseReasoner.model.ReasoningUtils;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public class ContextStack {
    private static final Pool<Context> POOL = new Pool((IPoolManager)new IPoolManager<Context>(){

        public Context create() {
            return new Context();
        }

        public void clear(Context instance) {
            instance.clear();
        }
    });
    private Context currentContext = new Context();
    private boolean registerContexts = false;
    private Set<? extends IDatatype> globalExcludes;

    public boolean setRegisterContexts(boolean registerContexts) {
        boolean res = this.registerContexts;
        this.registerContexts = registerContexts;
        return res;
    }

    public boolean isContextsRegistering() {
        return this.registerContexts;
    }

    public void clear() {
        do {
            this.popContext();
        } while (null != this.currentContext.predecessor);
        this.currentContext.clear();
    }

    public void pushContext(AbstractVariable decl, boolean recordProcessedTypes) {
        this.pushContext(decl, null, null, false);
    }

    public void pushContext(AbstractVariable decl, ConstraintSyntaxTree container, DecisionVariableDeclaration iterator, boolean recordProcessedTypes) {
        Context context = (Context)POOL.getInstance();
        context.container = container;
        context.iterator = iterator;
        context.recordProcessedTypes = recordProcessedTypes;
        if (this.registerContexts && null != decl) {
            this.currentContext.registeredContexts.put(decl, context);
            context.isRegistered = true;
        }
        this.pushContextImpl(context);
    }

    private void pushContextImpl(Context context) {
        context.predecessor = this.currentContext;
        this.currentContext = context;
    }

    public void popContext() {
        Context context = this.popContextImpl();
        if (null != context && !context.isRegistered) {
            POOL.releaseInstance((Object)context);
        }
    }

    private Context popContextImpl() {
        Context context = null;
        if (null != this.currentContext.predecessor) {
            context = this.currentContext;
            this.currentContext = context.predecessor;
        }
        return context;
    }

    public void registerMapping(AbstractVariable var, ConstraintSyntaxTree acc) {
        this.currentContext.varMap.put(var, acc);
    }

    public void unregisterMapping(AbstractVariable var) {
        this.currentContext.varMap.remove(var);
    }

    public boolean containsMapping(AbstractVariable var) {
        return this.currentContext.varMap.containsKey(var);
    }

    public ConstraintSyntaxTree getMapping(AbstractVariable var) {
        ConstraintSyntaxTree result;
        Context iter = this.currentContext;
        do {
            result = (ConstraintSyntaxTree)iter.varMap.get(var);
            iter = iter.predecessor;
        } while (null == result && null != iter);
        return result;
    }

    public ConstraintSyntaxTree getCurrentContainer() {
        return this.currentContext.container;
    }

    public DecisionVariableDeclaration getCurrentIterator() {
        return this.currentContext.iterator;
    }

    public ConstraintSyntaxTree composeExpression(ConstraintSyntaxTree cst) throws CSTSemanticException {
        Context iter = this.currentContext;
        do {
            if (null == iter.container) continue;
            cst = ReasoningUtils.createContainerCall(iter.container, Container.FORALL, cst, iter.iterator);
            cst.inferDatatype();
        } while (null != (iter = iter.predecessor));
        return cst;
    }

    private Context findRegisteredContext(AbstractVariable decl) {
        Context result = null;
        Context iter = this.currentContext;
        do {
            result = (Context)iter.registeredContexts.get(decl);
            iter = iter.predecessor;
        } while (null == result && null != iter);
        return result;
    }

    public void activate(AbstractVariable decl) {
        Context registered = this.findRegisteredContext(decl);
        if (null != registered) {
            this.pushContextImpl(registered);
        }
    }

    public void deactivate(AbstractVariable decl) {
        if (null != this.findRegisteredContext(decl)) {
            this.popContextImpl();
        }
    }

    public void recordProcessed(IDatatype type) {
        boolean found = false;
        Context iter = this.currentContext;
        do {
            if (iter.recordProcessedTypes) {
                if (type instanceof Compound) {
                    this.recordProcessed(iter.processedTypes, (Compound)type);
                } else {
                    iter.processedTypes.add(type);
                }
                found = true;
            }
            iter = iter.predecessor;
        } while (!found && null != iter);
    }

    private void recordProcessed(Set<IDatatype> processed, Compound type) {
        if (!processed.contains(type)) {
            processed.add((IDatatype)type);
            for (int r = 0; r < type.getRefinesCount(); ++r) {
                this.recordProcessed(processed, type.getRefines(r));
            }
        }
    }

    public boolean alreadyProcessed(IDatatype type) {
        boolean found = false;
        Context iter = this.currentContext;
        do {
            if (iter.recordProcessedTypes) {
                found = iter.processedTypes.contains(type);
            }
            iter = iter.predecessor;
        } while (!found && null != iter);
        return found;
    }

    public int size() {
        int result = 0;
        Context iter = this.currentContext;
        do {
            ++result;
        } while (null != (iter = iter.predecessor));
        return result;
    }

    public void setTypeExcludes(Set<? extends IDatatype> excludes) {
        this.globalExcludes = excludes;
    }

    public void transferTypeExcludes(IDatatype type) {
        if (null != this.globalExcludes && null == this.currentContext.typeExcludes) {
            this.currentContext.typeExcludes = this.globalExcludes;
            this.globalExcludes = null;
        }
        this.currentContext.type = type;
    }

    public boolean isElementTypeExcluded(IModelElement element) {
        return element instanceof IDatatype ? this.isTypeExcluded((IDatatype)element) : false;
    }

    public boolean isTypeExcluded(IDatatype type) {
        return null == this.currentContext.typeExcludes ? false : this.currentContext.typeExcludes.contains(type);
    }

    public IDatatype getCurrentType() {
        return this.currentContext.type;
    }

    private static class Context {
        private Map<AbstractVariable, ConstraintSyntaxTree> varMap = new HashMap<AbstractVariable, ConstraintSyntaxTree>(30);
        private DecisionVariableDeclaration iterator;
        private ConstraintSyntaxTree container;
        private Context predecessor;
        private Map<AbstractVariable, Context> registeredContexts = new HashMap<AbstractVariable, Context>();
        private boolean isRegistered;
        private boolean recordProcessedTypes;
        private Set<IDatatype> processedTypes = new HashSet<IDatatype>();
        private Set<? extends IDatatype> typeExcludes;
        private IDatatype type;

        private Context() {
        }

        private void clear() {
            this.varMap.clear();
            for (Map.Entry<AbstractVariable, Context> ent : this.registeredContexts.entrySet()) {
                POOL.releaseInstance((Object)ent.getValue());
            }
            this.registeredContexts.clear();
            this.iterator = null;
            this.container = null;
            this.predecessor = null;
            this.isRegistered = false;
            this.recordProcessedTypes = false;
            this.processedTypes.clear();
            this.typeExcludes = null;
            this.type = null;
        }
    }
}

