/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner.functions;

import net.ssehub.easy.reasoning.sseReasoner.functions.AbstractConstraintProcessor;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;

public class ConstraintFunctions {
    public static void allCompoundConstraints(Compound cmpType, AbstractConstraintProcessor processor, boolean includeConstraintVariables, boolean includeDefaults, IModelElement parent) {
        if (!processor.getContextStack().isTypeExcluded((IDatatype)cmpType)) {
            for (int c = 0; c < cmpType.getConstraintsCount(); ++c) {
                processor.process(cmpType.getConstraint(c), AbstractConstraintProcessor.ExpressionType.CONSTRAINT);
            }
            if (includeConstraintVariables || includeDefaults) {
                for (int i = 0; i < cmpType.getElementCount(); ++i) {
                    DecisionVariableDeclaration decl = cmpType.getElement(i);
                    ConstraintSyntaxTree defaultValue = decl.getDefaultValue();
                    if (null != defaultValue) {
                        if (includeConstraintVariables && TypeQueries.isConstraint((IDatatype)decl.getType())) {
                            processor.process(defaultValue, AbstractConstraintProcessor.ExpressionType.CONSTRAINT_VALUE, decl.getName(), parent);
                        } else if (includeDefaults) {
                            processor.process(defaultValue, AbstractConstraintProcessor.ExpressionType.DEFAULT, decl.getName(), parent);
                        }
                    }
                    int n = decl.getAttributesCount();
                    for (int a = 0; includeDefaults && a < n; ++a) {
                        Attribute attr = decl.getAttribute(a);
                        defaultValue = attr.getDefaultValue();
                        if (null == defaultValue) continue;
                        processor.process(defaultValue, AbstractConstraintProcessor.ExpressionType.ANNOTATION_DEFAULT, attr.getName(), parent);
                    }
                }
            }
            for (int r = 0; r < cmpType.getRefinesCount(); ++r) {
                ConstraintFunctions.allCompoundConstraints(cmpType.getRefines(r), processor, includeConstraintVariables, includeDefaults, parent);
            }
            for (int a = 0; a < cmpType.getAssignmentCount(); ++a) {
                ConstraintFunctions.allAssignmentConstraints(cmpType.getAssignment(a), processor);
            }
        }
    }

    public static void allAssignmentConstraints(AttributeAssignment assng, AbstractConstraintProcessor processor) {
        for (int c = 0; c < assng.getConstraintsCount(); ++c) {
            processor.process(assng.getConstraint(c), AbstractConstraintProcessor.ExpressionType.ASSIGNMENT_CONSTRAINT);
        }
        for (int a = 0; a < assng.getAssignmentCount(); ++a) {
            ConstraintFunctions.allAssignmentConstraints(assng.getAssignment(a), processor);
        }
    }
}

