/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.Utils;
import net.ssehub.easy.reasoning.core.reasoner.AnnotationAssignmentConstraint;
import net.ssehub.easy.reasoning.core.reasoner.AttachedConstraint;
import net.ssehub.easy.reasoning.core.reasoner.ConstraintBase;
import net.ssehub.easy.reasoning.core.reasoner.ConstraintList;
import net.ssehub.easy.reasoning.core.reasoner.ConstraintVariableConstraint;
import net.ssehub.easy.reasoning.core.reasoner.DefaultConstraint;
import net.ssehub.easy.reasoning.core.reasoner.IReasonerInterceptor;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.sseReasoner.CheckInitializerVisitor;
import net.ssehub.easy.reasoning.sseReasoner.EvalVisitor;
import net.ssehub.easy.reasoning.sseReasoner.RescheduleValueChangeVisitor;
import net.ssehub.easy.reasoning.sseReasoner.functions.AbstractConstraintProcessor;
import net.ssehub.easy.reasoning.sseReasoner.functions.ConstraintFunctions;
import net.ssehub.easy.reasoning.sseReasoner.functions.FailedElementDetails;
import net.ssehub.easy.reasoning.sseReasoner.functions.FailedElements;
import net.ssehub.easy.reasoning.sseReasoner.functions.ScopeAssignments;
import net.ssehub.easy.reasoning.sseReasoner.model.ContextStack;
import net.ssehub.easy.reasoning.sseReasoner.model.ReasoningUtils;
import net.ssehub.easy.reasoning.sseReasoner.model.SubstitutionVisitor;
import net.ssehub.easy.reasoning.sseReasoner.model.VariablesInConstraintFinder;
import net.ssehub.easy.reasoning.sseReasoner.model.VariablesInNotSimpleAssignmentConstraintsFinder;
import net.ssehub.easy.reasoning.sseReasoner.model.VariablesMap;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.CSTUtils;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.cstEvaluation.IConstraintEvaluator;
import net.ssehub.easy.varModel.cstEvaluation.IResolutionListener;
import net.ssehub.easy.varModel.cstEvaluation.LocalDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.AnnotationVisitor;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IAttributeAccess;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.IvmlException;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelVisitorAdapter;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.filter.FilterType;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.Value;

class Resolver
implements IResolutionListener {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(Resolver.class, "net.ssehub.easy.reasoning.sseReasoner");
    private static final int MODE_COMPOUND_ANYWAY = 0;
    private static final int MODE_COMPOUND_REGISTER = 1;
    private static final int MODE_COMPOUND_TRANSLATE = 2;
    private static final int MODE_COMPOUND_NONE = -1;
    private ReasonerConfiguration.IAdditionalInformationLogger infoLogger;
    private ReasonerConfiguration reasonerConfig;
    private Configuration config;
    private boolean incremental = false;
    private boolean reuseInstance = false;
    private IAssignmentState assignmentState = AssignmentState.DERIVED;
    private IReasonerInterceptor interceptor;
    private EvalVisitor evaluator = new EvalVisitor();
    private FailedElements failedElements = new FailedElements();
    private ScopeAssignments scopeAssignments = new ScopeAssignments();
    private VariablesMap variablesMap = new VariablesMap();
    private ReasonerState copiedState;
    private ConstraintBase constraintBase = new ConstraintBase();
    private ConstraintList defaultConstraints = new ConstraintList();
    private ConstraintList deferredDefaultConstraints = new ConstraintList();
    private ConstraintList topLevelConstraints = new ConstraintList();
    private ConstraintList otherConstraints = new ConstraintList();
    private List<Project> projects;
    private int constraintCounter = 0;
    private int variablesInConstraintsCounter = 0;
    private int reevaluationCounter = 0;
    private int variablesCounter = 0;
    private boolean hasTimeout = false;
    private boolean isRunning = false;
    private boolean wasStopped = false;
    private long translationTime = 0L;
    private long evaluationTime = 0L;
    private Project project;
    private transient Set<IDecisionVariable> usedVariables = new HashSet<IDecisionVariable>(100);
    private transient SubstitutionVisitor substVisitor = new SubstitutionVisitor();
    private transient ContextStack contexts = new ContextStack();
    private transient VariablesInNotSimpleAssignmentConstraintsFinder simpleAssignmentFinder = new VariablesInNotSimpleAssignmentConstraintsFinder(this.variablesMap);
    private transient ConstraintTranslationVisitor projectVisitor = new ConstraintTranslationVisitor();
    private transient VariablesInConstraintFinder variablesFinder = new VariablesInConstraintFinder();
    private transient OtherConstraintsProcessor otherConstraintsProc = new OtherConstraintsProcessor();
    private transient CompoundAnnotationMapper annotationMapper = new CompoundAnnotationMapper();
    private transient RescheduleValueChangeVisitor rescheduler = new RescheduleValueChangeVisitor(this);
    private transient CheckInitializerVisitor initChecker = new CheckInitializerVisitor(this);
    private transient long endTimestamp;
    private transient boolean inTopLevelEvals = false;

    public Resolver(Project project, Configuration config, ReasonerConfiguration reasonerConfig) {
        this.reasonerConfig = reasonerConfig;
        this.infoLogger = reasonerConfig.getLogger();
        this.config = config;
    }

    public Resolver(Project project, ReasonerConfiguration reasonerConfig) {
        new Resolver(project, this.createCleanConfiguration(project), reasonerConfig);
    }

    public Resolver(Configuration config, ReasonerConfiguration reasonerConfig) {
        new Resolver(config.getProject(), config, reasonerConfig);
    }

    public void localVariableCreated(LocalDecisionVariable var) {
        this.contexts.registerMapping(var.getDeclaration(), null);
    }

    public void localVariableDisposed(LocalDecisionVariable var) {
        this.contexts.unregisterMapping(var.getDeclaration());
    }

    void translateValueTypeChange(IDecisionVariable variable, Value newValue, Value oldValue) {
        IDatatype newType = newValue.getType();
        IDatatype oldType = oldValue.getType();
        if (NullValue.INSTANCE == newValue) {
            this.obtainConstraints(variable, true, null);
        } else if (NullValue.INSTANCE == oldValue) {
            boolean inc = this.setIncremental(true);
            this.translateDeclaration(variable.getDeclaration(), variable, null);
            this.setIncremental(inc);
        } else if (oldType.isAssignableFrom(newType)) {
            Set<Compound> types = ReasoningUtils.collectRefines(oldType, newType);
            this.contexts.setTypeExcludes(types);
            boolean inc = this.setIncremental(true);
            this.translateDeclaration(variable.getDeclaration(), variable, null);
            this.setIncremental(inc);
            this.contexts.setTypeExcludes(null);
            ReasoningUtils.SET_COMPOUND_POOL.releaseInstance(types);
        } else {
            Set<Compound> types = ReasoningUtils.collectRefines(oldType, newType);
            this.obtainConstraints(variable, true, types);
            ReasoningUtils.SET_COMPOUND_POOL.releaseInstance(types);
        }
    }

    List<Constraint> obtainConstraints(IDecisionVariable variable, boolean clear, Set<Compound> deleteFilter) {
        List<Constraint> constraints;
        IDecisionVariable iter = variable;
        do {
            constraints = iter instanceof IDecisionVariable ? this.variablesMap.getConstraintsForVariable((IConfigurationElement)iter) : null;
            iter = iter.getParent();
        } while (null == constraints && null != iter);
        if (clear && null != constraints) {
            List<Constraint> toRemove = constraints;
            if (null != deleteFilter) {
                toRemove = new ArrayList<Constraint>();
                for (int i = constraints.size() - 1; i >= 0; --i) {
                    Constraint cst = constraints.get(i);
                    Object attachedTo = cst.getAttachedTo();
                    if (null == attachedTo || !deleteFilter.contains(attachedTo)) continue;
                    constraints.remove(i);
                    toRemove.add(cst);
                }
                constraints = toRemove;
            }
            this.constraintBase.removeAll(constraints);
            this.failedElements.removeProblemConstraints(constraints);
            this.simpleAssignmentFinder.acceptAndClear(constraints, this.config, false);
            this.variablesMap.removeAll(variable, constraints);
            constraints.clear();
        }
        return constraints;
    }

    void moveOtherConstraintsToConstraintBase(IDecisionVariable variable) {
        this.variablesMap.addAll(variable, this.otherConstraints);
        this.constraintBase.addAll(this.otherConstraints, true);
    }

    void reschedule(AbstractVariable declaration) {
        Set<Constraint> constraints = this.variablesMap.getRelevantConstraints(declaration);
        if (null != constraints) {
            for (Constraint varConstraint : constraints) {
                if (this.constraintBase.contains(varConstraint)) continue;
                this.constraintBase.addLast(varConstraint);
            }
        }
    }

    public void notifyResolved(IDecisionVariable compound, String slotName, IDecisionVariable resolved) {
        if (!resolved.isLocal()) {
            this.usedVariables.add(resolved);
        }
    }

    public void notifyResolved(AbstractVariable declaration, IDecisionVariable resolved) {
        if (!resolved.isLocal()) {
            this.usedVariables.add(resolved);
        }
    }

    public void resolve() {
        this.isRunning = true;
        this.evaluator.init((IConfiguration)this.config, null, false, this.rescheduler);
        this.evaluator.setResolutionListener(this);
        this.evaluator.setScopeAssignments(this.scopeAssignments);
        long l = this.endTimestamp = this.reasonerConfig.getTimeout() <= 0 ? -1L : System.currentTimeMillis() + (long)this.reasonerConfig.getTimeout();
        if (null == this.copiedState) {
            if (this.reuseInstance) {
                this.copiedState = new ReasonerState();
            }
            this.projects = Utils.discoverImports((IModel)this.config.getProject());
            for (int p = 0; !this.hasTimeout && !this.wasStopped && p < this.projects.size(); ++p) {
                this.project = this.projects.get(p);
                long start = System.currentTimeMillis();
                this.translateConstraints(this.project);
                this.evaluateConstraintBase(start, this.project);
            }
        } else {
            this.variablesMap.clear();
            this.variablesMap.copyFrom(this.copiedState.variablesMap);
            for (int p = 0; !this.hasTimeout && !this.wasStopped && p < this.copiedState.constraintBase.size(); ++p) {
                this.project = this.projects.get(p);
                long start = System.currentTimeMillis();
                this.constraintBase.addAll((ConstraintList)this.copiedState.constraintBase.get(p));
                this.evaluateConstraintBase(start, this.project);
            }
        }
        this.evaluator.clear();
        this.isRunning = false;
    }

    private void evaluateConstraintBase(long start, Project project) {
        long mid = System.currentTimeMillis();
        this.translationTime += mid - start;
        this.evaluateConstraints(project);
        long end = System.currentTimeMillis();
        this.evaluationTime += end - mid;
        this.config.freezeValues(project, FilterType.NO_IMPORTS);
    }

    private void evaluateConstraints(Project project) {
        this.scopeAssignments.clearScopeAssignments();
        this.evaluator.setDispatchScope(project);
        while (!this.constraintBase.isEmpty() && !this.wasStopped) {
            this.usedVariables.clear();
            Constraint constraint = this.constraintBase.pop();
            this.scopeAssignments.setCurrentScope(constraint);
            ConstraintSyntaxTree cst = constraint.getConsSyntax();
            this.evaluator.setAssignmentState((IAssignmentState)(Constraint.Type.DEFAULT == constraint.getType() ? AssignmentState.DEFAULT : this.assignmentState));
            ++this.reevaluationCounter;
            if (cst != null) {
                this.evaluator.visit(cst);
                this.analyzeEvaluationResult(constraint);
                if (null != this.interceptor) {
                    this.interceptor.notifyEvaluation(constraint, (IConstraintEvaluator)this.evaluator);
                }
                this.evaluator.clearIntermediary();
            }
            if (this.endTimestamp <= 0L || System.currentTimeMillis() <= this.endTimestamp) continue;
            this.hasTimeout = true;
            break;
        }
    }

    private void translateDerivedDatatypeConstraints(AbstractVariable decl, IDatatype type, DecisionVariableDeclaration localDecl, IModelElement parent, int refCounter) {
        if (type instanceof DerivedDatatype) {
            AbstractVariable declaration;
            DerivedDatatype dType = (DerivedDatatype)type;
            int count = dType.getConstraintCount();
            DecisionVariableDeclaration dVar = dType.getTypeDeclaration();
            Object object = declaration = null == localDecl ? decl : localDecl;
            if (count > 0 && dVar != declaration) {
                this.substVisitor.setMappings(this.contexts);
                this.substVisitor.addVariableMapping((AbstractVariable)dVar, declaration, refCounter);
                for (int i = 0; i < count; ++i) {
                    ConstraintSyntaxTree cst = dType.getConstraint(i).getConsSyntax();
                    if (null != localDecl) {
                        cst = ReasoningUtils.createContainerCall((ConstraintSyntaxTree)new Variable(decl), Container.FORALL, cst, localDecl);
                    }
                    cst = this.substVisitor.accept(cst);
                    try {
                        cst.inferDatatype();
                        this.addConstraint(this.topLevelConstraints, new Constraint(cst, parent), true, null);
                        continue;
                    }
                    catch (CSTSemanticException e) {
                        LOGGER.exception((Exception)((Object)e));
                    }
                }
                this.substVisitor.clear();
            }
            this.translateDerivedDatatypeConstraints(decl, dType.getBasisType(), localDecl, parent, refCounter);
        } else if (type instanceof Reference) {
            this.translateDerivedDatatypeConstraints(decl, ((Reference)type).getType(), localDecl, parent, refCounter + 1);
        }
    }

    private void translateAnnotationDeclarations(AbstractVariable decl, IDecisionVariable variable, ConstraintSyntaxTree cAcc) {
        ConstraintSyntaxTree acc;
        Object object = acc = null == cAcc ? new Variable(decl) : cAcc;
        if (null != variable) {
            for (int i = 0; i < variable.getAttributesCount(); ++i) {
                IDecisionVariable att = variable.getAttribute(i);
                this.translateAnnotationDeclaration((Attribute)att.getDeclaration(), att, acc);
            }
        } else {
            for (int i = 0; i < decl.getAttributesCount(); ++i) {
                this.translateAnnotationDeclaration(decl.getAttribute(i), null, acc);
            }
        }
    }

    private void translateAnnotationDeclaration(Attribute decl, IDecisionVariable variable, ConstraintSyntaxTree cAcc) {
        ConstraintSyntaxTree attAcc = cAcc;
        if (null != cAcc && !this.contexts.isContextsRegistering() && (this.contexts.size() > 1 || TypeQueries.isCompound((IDatatype)DerivedDatatype.resolveToBasis((IDatatype)variable.getDeclaration().getType())))) {
            attAcc = new AttributeVariable(cAcc, decl);
        }
        this.translateDeclaration((AbstractVariable)decl, variable, attAcc);
    }

    private void translateDeclaration(AbstractVariable decl, IDecisionVariable var, ConstraintSyntaxTree cAcc) {
        ++this.variablesCounter;
        IDatatype type = decl.getType();
        ConstraintSyntaxTree defaultValue = decl.getDefaultValue();
        boolean isConstraintType = TypeQueries.isConstraint((IDatatype)type);
        AbstractVariable self = null;
        ConstraintSyntaxTree selfEx = null;
        this.translateDerivedDatatypeConstraints(decl, type, null, decl.getTopLevelParent(), 0);
        if (this.incremental) {
            defaultValue = isConstraintType ? defaultValue : null;
        } else {
            this.translateAnnotationDeclarations(decl, var, cAcc);
        }
        if (null != defaultValue) {
            type = ReasoningUtils.inferTypeSafe(defaultValue, type);
        }
        if (null != var && null != var.getValue()) {
            type = var.getValue().getType();
        }
        boolean isCompound = TypeQueries.isCompound((IDatatype)type);
        boolean isContainer = TypeQueries.isContainer((IDatatype)type);
        int compoundMode = -1;
        if (isCompound) {
            self = decl;
            compoundMode = this.translateCompoundDeclaration(decl, var, cAcc, (Compound)type, 1);
        } else if (null != defaultValue && !this.incremental) {
            if (cAcc instanceof CompoundAccess) {
                selfEx = ((CompoundAccess)cAcc).getCompoundExpression();
            }
        } else if (this.incremental && !isContainer) {
            defaultValue = null;
        }
        if (!(null == defaultValue || decl.isAttribute() && decl.getParent() instanceof AttributeAssignment)) {
            try {
                Object acc;
                if (isConstraintType) {
                    --this.variablesCounter;
                    this.createConstraintVariableConstraint(defaultValue, selfEx, self, (IModelElement)decl, var);
                }
                if (decl instanceof Attribute) {
                    Attribute attribute = (Attribute)decl;
                    acc = cAcc == null ? new Variable((AbstractVariable)attribute) : (cAcc instanceof AttributeVariable ? cAcc : new AttributeVariable(cAcc, attribute));
                } else {
                    acc = null != selfEx ? cAcc : new Variable(decl);
                }
                defaultValue = new OCLFeatureCall(acc, "=", new ConstraintSyntaxTree[]{defaultValue});
                defaultValue = this.substituteVariables(defaultValue, selfEx, self);
                ConstraintList targetCons = this.defaultConstraints;
                if (this.substVisitor.containsSelf() || ReasoningUtils.isOverriddenSlot(decl)) {
                    targetCons = this.deferredDefaultConstraints;
                }
                this.addConstraint(targetCons, (Constraint)new DefaultConstraint(defaultValue, (IModelElement)this.project), true, var);
                this.substVisitor.clear();
            }
            catch (CSTSemanticException e) {
                LOGGER.exception((Exception)((Object)e));
            }
        }
        if (isCompound) {
            this.translateCompoundDeclaration(decl, var, cAcc, (Compound)type, compoundMode);
        } else if (isContainer) {
            this.translateContainerDeclaration(decl, var, type, cAcc);
        }
    }

    private void translateContainerDeclaration(AbstractVariable decl, IDecisionVariable var, IDatatype type, ConstraintSyntaxTree cAcc) {
        this.contexts.pushContext(decl, false);
        Container declType = (Container)type;
        IDatatype dContainedType = ReasoningUtils.getDeepestContainedType(declType);
        IDatatype dContainedBasisType = DerivedDatatype.resolveToBasis((IDatatype)dContainedType);
        ContainerValue val = ReasoningUtils.getRelevantValue(decl, var, this.incremental, ContainerValue.class);
        if (TypeQueries.isConstraint((IDatatype)dContainedBasisType)) {
            if (null != val) {
                this.createContainerConstraintValueConstraints(val, cAcc, null, (IModelElement)decl, var);
            }
        } else if (TypeQueries.isCompound((IDatatype)dContainedBasisType)) {
            Set used = (Set)ReasoningUtils.SET_COMPOUND_POOL.getInstance();
            if (null != val) {
                ReasoningUtils.getUsedCompoundTypes((Value)val, used);
                Set tmp = (Set)ReasoningUtils.SET_COMPOUND_POOL.getInstance();
                ReasoningUtils.purgeRefines(used, (Set<Compound>)tmp);
                ReasoningUtils.SET_COMPOUND_POOL.releaseInstance((Object)used);
                used = tmp;
            } else if (dContainedBasisType instanceof Compound) {
                used.add((Compound)dContainedBasisType);
            }
            for (Compound uType : used) {
                this.translateCompoundContainer(decl, uType, dContainedType, cAcc);
            }
            ReasoningUtils.SET_COMPOUND_POOL.releaseInstance((Object)used);
        }
        if (dContainedType instanceof DerivedDatatype || dContainedType instanceof Reference) {
            this.translateDerivedDatatypeConstraints(decl, dContainedType, new DecisionVariableDeclaration("derivedType", dContainedType, null), (IModelElement)this.project, 0);
        }
        this.contexts.popContext();
    }

    private void translateCompoundContainer(AbstractVariable decl, Compound type, IDatatype declaredContainedType, ConstraintSyntaxTree cAcc) {
        if (!this.contexts.alreadyProcessed((IDatatype)type)) {
            this.contexts.recordProcessed((IDatatype)type);
            DecisionVariableDeclaration localDecl = new DecisionVariableDeclaration("cmp" + this.contexts.size(), (IDatatype)type, null);
            Variable localVar = new Variable((AbstractVariable)localDecl);
            Variable declVar = new Variable(decl);
            Variable containerOp = null == cAcc ? declVar : cAcc;
            try {
                if (TypeQueries.isSequence((IDatatype)decl.getType())) {
                    containerOp = new OCLFeatureCall((ConstraintSyntaxTree)containerOp, "asSet", new ConstraintSyntaxTree[0]);
                }
                if (ReasoningUtils.isNestedContainer(decl.getType())) {
                    containerOp = new OCLFeatureCall((ConstraintSyntaxTree)containerOp, "flatten", new ConstraintSyntaxTree[0]);
                }
                if (!TypeQueries.sameTypes((IDatatype)type, (IDatatype)declaredContainedType)) {
                    containerOp = new OCLFeatureCall((ConstraintSyntaxTree)containerOp, "selectByKind", new ConstraintSyntaxTree[]{ReasoningUtils.createTypeValueConstant((IDatatype)type)});
                }
            }
            catch (IvmlException e) {
                LOGGER.exception((Exception)((Object)e));
            }
            this.contexts.pushContext(null, (ConstraintSyntaxTree)containerOp, localDecl, true);
            this.registerCompoundMapping(type, (ConstraintSyntaxTree)localVar, null, declVar, (IDatatype)type);
            this.translateCompoundContent((AbstractVariable)localDecl, null, type, (ConstraintSyntaxTree)(null == cAcc ? null : localVar));
            this.contexts.popContext();
        }
    }

    private int translateCompoundDeclaration(AbstractVariable decl, IDecisionVariable variable, ConstraintSyntaxTree cAcc, Compound type, int mode) {
        int nextMode = -1;
        if (!this.contexts.alreadyProcessed((IDatatype)type)) {
            if (0 == mode || 1 == mode) {
                this.contexts.recordProcessed((IDatatype)type);
                this.contexts.pushContext(decl, null == variable);
                this.contexts.transferTypeExcludes((IDatatype)type);
                Variable declVar = new Variable(decl);
                this.registerCompoundMapping(type, cAcc, variable, declVar, (IDatatype)(null == variable ? type : variable.getValue().getType()));
                nextMode = 2;
            }
            if (0 == mode || 2 == mode) {
                this.translateCompoundContent(decl, variable, type, cAcc);
                this.contexts.popContext();
                nextMode = -1;
            }
        }
        return nextMode;
    }

    private void registerCompoundMapping(Compound type, ConstraintSyntaxTree cAcc, IDecisionVariable var, Variable declVar, IDatatype target) {
        int n = type.getInheritedElementCount();
        for (int i = 0; i < n; ++i) {
            DecisionVariableDeclaration nestedDecl = type.getInheritedElement(i);
            CompoundAccess acc = null == cAcc ? new CompoundAccess((ConstraintSyntaxTree)declVar, nestedDecl.getName()) : new CompoundAccess(ReasoningUtils.createAsTypeCast(cAcc, (IDatatype)type, target), nestedDecl.getName());
            this.contexts.registerMapping((AbstractVariable)nestedDecl, (ConstraintSyntaxTree)acc);
            int m = nestedDecl.getAttributesCount();
            for (int a = 0; a < m; ++a) {
                Attribute attr = nestedDecl.getAttribute(a);
                AttributeVariable aAcc = new AttributeVariable((ConstraintSyntaxTree)acc, attr);
                this.contexts.registerMapping((AbstractVariable)attr, (ConstraintSyntaxTree)aAcc);
            }
        }
        this.annotationMapper.initialize(type, cAcc, declVar, target);
        try {
            this.annotationMapper.visitAnnotations((IAttributeAccess)declVar.getVariable());
        }
        catch (IvmlException ivmlException) {
            // empty catch block
        }
        this.annotationMapper.clear();
    }

    private void translateCompoundContent(AbstractVariable decl, IDecisionVariable variable, Compound type, ConstraintSyntaxTree cAcc) {
        int i;
        int n;
        if (null != variable) {
            n = variable.getNestedElementsCount();
            for (i = 0; i < n; ++i) {
                IDecisionVariable nestedVar = variable.getNestedElement(i);
                AbstractVariable nestedDecl = nestedVar.getDeclaration();
                if (this.contexts.isElementTypeExcluded(nestedDecl.getParent())) continue;
                this.translateDeclaration(nestedDecl, nestedVar, this.contexts.getMapping(nestedDecl));
            }
        } else {
            n = type.getInheritedElementCount();
            for (i = 0; i < n; ++i) {
                DecisionVariableDeclaration nestedDecl = type.getInheritedElement(i);
                if (this.contexts.isElementTypeExcluded(nestedDecl.getParent())) continue;
                this.translateDeclaration((AbstractVariable)nestedDecl, null, this.contexts.getMapping((AbstractVariable)nestedDecl));
            }
        }
        if (!this.incremental) {
            for (int a = 0; a < type.getAssignmentCount(); ++a) {
                this.translateAnnotationAssignments(type.getAssignment(a), variable, null, cAcc);
            }
        }
        AbstractVariable self = null == cAcc ? decl : null;
        this.processCompoundEvals(type, cAcc, self);
        this.otherConstraintsProc.setParameter(cAcc, self, variable);
        ConstraintFunctions.allCompoundConstraints(type, this.otherConstraintsProc, false, false, (IModelElement)decl);
        this.otherConstraintsProc.clear();
    }

    private void processCompoundEvals(Compound cmpType, ConstraintSyntaxTree selfEx, AbstractVariable self) {
        if (!this.contexts.isTypeExcluded((IDatatype)cmpType)) {
            for (int r = 0; r < cmpType.getRefinesCount(); ++r) {
                this.processCompoundEvals(cmpType.getRefines(r), selfEx, self);
            }
            for (int i = 0; i < cmpType.getModelElementCount(); ++i) {
                if (!(cmpType.getModelElement(i) instanceof PartialEvaluationBlock)) continue;
                PartialEvaluationBlock evalBlock = (PartialEvaluationBlock)cmpType.getModelElement(i);
                this.processEvalConstraints(evalBlock, selfEx, self);
            }
        }
    }

    private void processEvalConstraints(PartialEvaluationBlock evalBlock, ConstraintSyntaxTree selfEx, AbstractVariable self) {
        int i;
        for (i = 0; i < evalBlock.getNestedCount(); ++i) {
            this.processEvalConstraints(evalBlock.getNested(i), selfEx, self);
        }
        for (i = 0; i < evalBlock.getEvaluableCount(); ++i) {
            if (!(evalBlock.getEvaluable(i) instanceof Constraint)) continue;
            Constraint evalConstraint = (Constraint)evalBlock.getEvaluable(i);
            ConstraintSyntaxTree evalCst = evalConstraint.getConsSyntax();
            ConstraintSyntaxTree cst = this.substituteVariables(evalCst, selfEx, self);
            try {
                this.addConstraint(this.otherConstraints, new Constraint(cst, (IModelElement)this.project), true, null);
                continue;
            }
            catch (CSTSemanticException e) {
                LOGGER.exception((Exception)((Object)e));
            }
        }
    }

    void createContainerConstraintValueConstraints(ContainerValue val, ConstraintSyntaxTree selfEx, AbstractVariable self, IModelElement parent, IDecisionVariable nestedVariable) {
        for (int n = 0; n < val.getElementSize(); ++n) {
            Value cVal = val.getElement(n);
            ConstraintSyntaxTree cst = ReasoningUtils.getConstraintValueConstraintExpression(cVal);
            if (null != cst) {
                this.createConstraintVariableConstraint(cst, selfEx, self, parent, nestedVariable);
                continue;
            }
            if (!(cVal instanceof ContainerValue)) continue;
            this.createContainerConstraintValueConstraints((ContainerValue)cVal, selfEx, self, parent, nestedVariable);
        }
    }

    private void translateAnnotationAssignments(AttributeAssignment assignment, IDecisionVariable var, List<AttributeAssignment.Assignment> effectiveAssignments, ConstraintSyntaxTree compound) {
        ArrayList<AttributeAssignment.Assignment> assng = null == effectiveAssignments ? new ArrayList<AttributeAssignment.Assignment>() : effectiveAssignments;
        for (int d = 0; d < assignment.getAssignmentDataCount(); ++d) {
            assng.add(assignment.getAssignmentData(d));
        }
        HashSet<String> done = new HashSet<String>();
        for (int d = assng.size() - 1; d >= 0; --d) {
            AttributeAssignment.Assignment effectiveAssignment = (AttributeAssignment.Assignment)assng.get(d);
            String name = effectiveAssignment.getName();
            if (done.contains(name)) continue;
            done.add(name);
            for (int e = 0; e < assignment.getElementCount(); ++e) {
                IDecisionVariable v;
                DecisionVariableDeclaration aElt = assignment.getElement(e);
                String aEltName = aElt.getName();
                this.contexts.activate((AbstractVariable)aElt);
                Object acc = null != compound ? new CompoundAccess(compound, aEltName) : (null != var ? new CompoundAccess((ConstraintSyntaxTree)new Variable(var.getDeclaration()), aEltName) : new Variable((AbstractVariable)aElt));
                this.translateAnnotationAssignment(effectiveAssignment, aElt, compound);
                IDatatype aEltType = aElt.getType();
                if (null != var && null != (v = var.getNestedElement(aEltName)) && null != v.getValue()) {
                    aEltType = v.getValue().getType();
                }
                if (TypeQueries.isCompound((IDatatype)aEltType)) {
                    Compound cmp = (Compound)aEltType;
                    for (int s = 0; s < cmp.getDeclarationCount(); ++s) {
                        DecisionVariableDeclaration slot = cmp.getDeclaration(s);
                        this.translateAnnotationAssignment(effectiveAssignment, slot, (ConstraintSyntaxTree)new CompoundAccess((ConstraintSyntaxTree)acc, slot.getName()));
                    }
                }
                this.contexts.deactivate((AbstractVariable)aElt);
            }
        }
        for (int a = 0; a < assignment.getAssignmentCount(); ++a) {
            this.translateAnnotationAssignments(assignment.getAssignment(a), var, assng, compound);
        }
    }

    private void translateAnnotationAssignment(AttributeAssignment.Assignment assignment, DecisionVariableDeclaration element, ConstraintSyntaxTree compound) {
        Attribute attrib = ModelQuery.findAttribute((IModelElement)element, (String)assignment.getName());
        if (null != attrib) {
            if (null == compound) {
                compound = this.contexts.getMapping((AbstractVariable)element);
            }
            AttributeVariable cst = compound == null ? new AttributeVariable((ConstraintSyntaxTree)new Variable((AbstractVariable)element), attrib) : new AttributeVariable(compound, attrib);
            cst = new OCLFeatureCall((ConstraintSyntaxTree)cst, "=", new ConstraintSyntaxTree[]{assignment.getExpression()});
            cst = this.substituteVariables((ConstraintSyntaxTree)cst, compound, null);
            ReasoningUtils.inferTypeSafe((ConstraintSyntaxTree)cst, null);
            try {
                this.addConstraint(this.otherConstraints, (Constraint)new AnnotationAssignmentConstraint((ConstraintSyntaxTree)cst, (IModelElement)this.project), false, null);
            }
            catch (CSTSemanticException e) {
                LOGGER.exception((Exception)((Object)e));
            }
        }
    }

    private void translateConstraints(Project project) {
        project.accept((IModelVisitor)this.projectVisitor);
        this.constraintBase.addAll(this.defaultConstraints, true);
        this.constraintBase.addAll(this.deferredDefaultConstraints, true);
        this.constraintBase.addAll(this.topLevelConstraints, true);
        this.constraintBase.addAll(this.otherConstraints, true);
        this.constraintCounter = this.constraintBase.size();
        this.variablesInConstraintsCounter = this.variablesMap.getDeclarationSize();
        if (null != this.copiedState) {
            ConstraintList copy = new ConstraintList();
            copy.addAll((ConstraintList)this.constraintBase);
            this.copiedState.constraintBase.add(copy);
        }
        this.contexts.clear();
    }

    private void addConstraint(ConstraintList target, Constraint constraint, boolean checkForInitializers, IDecisionVariable variable) {
        ConstraintSyntaxTree cst = constraint.getConsSyntax();
        try {
            cst = this.contexts.composeExpression(cst);
            constraint.setConsSyntax(cst);
        }
        catch (CSTSemanticException e) {
            LOGGER.exception((Exception)((Object)e));
        }
        boolean add = true;
        if (this.incremental) {
            boolean bl = add = !CSTUtils.isAssignment((ConstraintSyntaxTree)cst);
            if (add) {
                this.variablesFinder.setConfiguration(this.config);
                cst.accept((IConstraintTreeVisitor)this.variablesFinder);
                add = !this.variablesFinder.isConstraintFrozen();
                this.variablesFinder.clear();
            }
        }
        if (checkForInitializers) {
            this.initChecker.accept(cst, constraint.getParent(), variable);
        }
        if (add) {
            if (this.inTopLevelEvals && (target == this.otherConstraints || target == this.topLevelConstraints)) {
                target.addFirst(constraint);
            } else {
                target.addLast(constraint);
            }
            this.simpleAssignmentFinder.acceptAndClear(constraint, this.config);
        }
    }

    Constraint createConstraintVariableConstraint(ConstraintSyntaxTree cst, ConstraintSyntaxTree selfEx, AbstractVariable self, IModelElement parent, IDecisionVariable variable) {
        return this.createConstraintVariableConstraint(cst, self, !((cst = this.substituteVariables(cst, selfEx, self)) instanceof ConstantValue), parent, variable);
    }

    Constraint createConstraintVariableConstraint(ConstraintSyntaxTree cst, AbstractVariable self, boolean checkForInitializers, IModelElement parent, IDecisionVariable variable) {
        ConstraintVariableConstraint constraint = null;
        try {
            constraint = new ConstraintVariableConstraint(cst, parent);
            this.addConstraint(this.otherConstraints, (Constraint)constraint, checkForInitializers, variable);
            this.registerConstraint(variable, (Constraint)constraint);
        }
        catch (CSTSemanticException e) {
            LOGGER.exception((Exception)((Object)e));
        }
        return constraint;
    }

    private void registerConstraint(IDecisionVariable variable, Constraint constraint) {
        if (null != variable) {
            this.variablesMap.registerConstraint(variable, constraint);
            if (null != this.copiedState) {
                this.copiedState.variablesMap.registerConstraint(variable, constraint);
            }
        }
    }

    private void analyzeEvaluationResult(Constraint constraint) {
        if (this.evaluator.constraintFailed()) {
            FailedElementDetails failedElementDetails = new FailedElementDetails();
            failedElementDetails.setProblemPoints(new HashSet<IDecisionVariable>(this.usedVariables));
            failedElementDetails.setProblemConstraintPart(this.getFailedConstraintPart());
            failedElementDetails.setProblemConstraint(constraint);
            failedElementDetails.setErrorClassifier(102);
            this.failedElements.addProblemConstraint(constraint, failedElementDetails);
        } else if (this.evaluator.constraintFulfilled()) {
            this.failedElements.removeProblemConstraint(constraint);
        }
        for (int j = 0; j < this.evaluator.getMessageCount(); ++j) {
            EvaluationVisitor.Message msg = this.evaluator.getMessage(j);
            AbstractVariable var = msg.getVariable();
            if (var == null || var.getParent() instanceof OperationDefinition || var.getParent() instanceof Constraint) continue;
            this.usedVariables.clear();
            this.usedVariables.add(msg.getDecision());
            FailedElementDetails failedelementDetails = new FailedElementDetails();
            failedelementDetails.setProblemPoints(new HashSet<IDecisionVariable>(this.usedVariables));
            failedelementDetails.setProblemConstraintPart(constraint.getConsSyntax());
            failedelementDetails.setProblemConstraint(constraint);
            failedelementDetails.setErrorClassifier(101);
            this.failedElements.addProblemVariable(var, failedelementDetails);
        }
        if (this.evaluator.constraintFulfilled() && Constraint.Type.DEFAULT == constraint.getType()) {
            this.simpleAssignmentFinder.acceptAndClear(constraint, this.config, false);
        }
    }

    ConstraintSyntaxTree substituteVariables(ConstraintSyntaxTree cst, ConstraintSyntaxTree selfEx, AbstractVariable self) {
        this.substVisitor.setMappings(this.contexts);
        if (selfEx != null) {
            this.substVisitor.setSelf(selfEx);
        }
        if (self != null) {
            this.substVisitor.setSelf(self);
        }
        cst = this.substVisitor.acceptAndClear(cst);
        ReasoningUtils.inferTypeSafe(cst, null);
        return cst;
    }

    private void conflictingDefault(AbstractVariable decl) {
    }

    private Configuration createCleanConfiguration(Project project) {
        return new Configuration(project, false);
    }

    private ConstraintSyntaxTree getFailedConstraintPart() {
        ConstraintSyntaxTree cstPart = null;
        if (this.evaluator.getFailedExpression() != null) {
            cstPart = this.evaluator.getFailedExpression()[0];
        }
        return cstPart;
    }

    IDecisionVariable getConstraintVariable(Constraint constraint) {
        return this.variablesMap.getDecisionVariableForConstraint(constraint);
    }

    int constraintCount() {
        return this.constraintCounter;
    }

    int variableCount() {
        return this.variablesCounter;
    }

    int variableInConstraintCount() {
        return this.variablesInConstraintsCounter;
    }

    int reevaluationCount() {
        return this.reevaluationCounter;
    }

    FailedElements getFailedElements() {
        return this.failedElements;
    }

    boolean setIncremental(boolean incremental) {
        boolean old = this.incremental;
        this.incremental = incremental;
        return old;
    }

    protected EvaluationVisitor createEvaluationVisitor() {
        return new EvalVisitor();
    }

    boolean hasTimeout() {
        return this.hasTimeout;
    }

    boolean wasStopped() {
        return this.wasStopped;
    }

    boolean isRunning() {
        return this.isRunning;
    }

    boolean stop() {
        this.wasStopped = true;
        return true;
    }

    void markForReuse() {
        this.reuseInstance = true;
    }

    void clear() {
        this.defaultConstraints.clear();
        this.deferredDefaultConstraints.clear();
        this.topLevelConstraints.clear();
        this.otherConstraints.clear();
        this.failedElements.clear();
        this.scopeAssignments.clearScopeAssignments();
        this.constraintBase.clear();
        this.reevaluationCounter = 0;
        this.hasTimeout = false;
        this.isRunning = false;
        this.wasStopped = false;
        this.usedVariables.clear();
        this.substVisitor.clear();
        this.contexts.clear();
        this.simpleAssignmentFinder.clear();
    }

    void reInit() {
        this.hasTimeout = false;
        this.isRunning = false;
        this.wasStopped = false;
        this.reevaluationCounter = 0;
        this.translationTime = 0L;
        this.evaluationTime = 0L;
        this.failedElements.clear();
        this.assignmentState = AssignmentState.DERIVED;
    }

    long getEvaluationTime() {
        return this.translationTime;
    }

    long getTranslationTime() {
        return this.evaluationTime;
    }

    void setAssignmentState(IAssignmentState state) {
        if (null != state) {
            this.assignmentState = state;
        }
    }

    void setInterceptor(IReasonerInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    final void addAssignedVariableToScope(IDecisionVariable variable) {
        this.scopeAssignments.addAssignedVariable(variable);
    }

    final boolean contextContainsMapping(AbstractVariable var) {
        return this.contexts.containsMapping(var);
    }

    final void contextRegisterMapping(AbstractVariable var, ConstraintSyntaxTree acc) {
        this.contexts.registerMapping(var, acc);
    }

    private class OtherConstraintsProcessor
    extends AbstractConstraintProcessor {
        private ConstraintSyntaxTree selfEx;
        private AbstractVariable self;
        private IDecisionVariable variable;

        private OtherConstraintsProcessor() {
        }

        private void setParameter(ConstraintSyntaxTree selfEx, AbstractVariable self, IDecisionVariable variable) {
            this.selfEx = selfEx;
            this.self = self;
            this.variable = variable;
        }

        private void clear() {
            this.selfEx = null;
            this.self = null;
            this.variable = null;
        }

        @Override
        public ConstraintSyntaxTree process(ConstraintSyntaxTree cst, AbstractConstraintProcessor.ExpressionType type, String slot, IModelElement parent) {
            cst = Resolver.this.substituteVariables(cst, this.selfEx, this.self);
            try {
                AttachedConstraint constraint = new AttachedConstraint(cst, Resolver.this.contexts.getCurrentType(), parent);
                Resolver.this.addConstraint(Resolver.this.otherConstraints, (Constraint)constraint, true, this.variable);
                if (AbstractConstraintProcessor.ExpressionType.CONSTRAINT == type) {
                    Resolver.this.registerConstraint(this.variable, (Constraint)constraint);
                }
            }
            catch (CSTSemanticException e) {
                LOGGER.exception((Exception)((Object)e));
            }
            return cst;
        }

        @Override
        public ContextStack getContextStack() {
            return Resolver.this.contexts;
        }
    }

    private class CompoundAnnotationMapper
    extends AnnotationVisitor {
        private ConstraintSyntaxTree cAcc;
        private Compound type;
        private Variable declVar;
        private IDatatype target;

        private CompoundAnnotationMapper() {
        }

        protected void initialize(Compound type, ConstraintSyntaxTree cAcc, Variable declVar, IDatatype target) {
            this.type = type;
            this.cAcc = cAcc;
            this.declVar = declVar;
            this.target = target;
        }

        protected void clear() {
            this.type = null;
            this.cAcc = null;
            this.declVar = null;
            this.target = null;
        }

        protected void processAttributeAssignment(AttributeAssignment assng) throws IvmlException {
        }

        protected void processAttribute(Attribute attr) throws IvmlException {
            AttributeVariable acc = null == this.cAcc ? new AttributeVariable((ConstraintSyntaxTree)this.declVar, attr) : new AttributeVariable(ReasoningUtils.createAsTypeCast(this.cAcc, (IDatatype)this.type, this.target), attr);
            for (Attribute iter = attr; null != iter; iter = iter.getOrigin()) {
                Resolver.this.contexts.registerMapping((AbstractVariable)iter, (ConstraintSyntaxTree)acc);
            }
        }
    }

    private class ConstraintTranslationVisitor
    extends ModelVisitorAdapter {
        private List<PartialEvaluationBlock> evals = null;

        private ConstraintTranslationVisitor() {
        }

        public void visitProject(Project project) {
            for (int e = 0; e < project.getElementCount(); ++e) {
                project.getElement(e).accept((IModelVisitor)this);
            }
            if (null != this.evals) {
                Resolver.this.inTopLevelEvals = true;
                for (PartialEvaluationBlock block : this.evals) {
                    int i;
                    for (i = 0; i < block.getNestedCount(); ++i) {
                        block.getNested(i).accept((IModelVisitor)this);
                    }
                    for (i = 0; i < block.getEvaluableCount(); ++i) {
                        block.getEvaluable(i).accept((IModelVisitor)this);
                    }
                }
                Resolver.this.inTopLevelEvals = false;
            }
        }

        public void visitDecisionVariableDeclaration(DecisionVariableDeclaration decl) {
            Resolver.this.translateDeclaration((AbstractVariable)decl, Resolver.this.config.getDecision((AbstractVariable)decl), null);
        }

        public void visitConstraint(Constraint constraint) {
            Resolver.this.addConstraint(Resolver.this.topLevelConstraints, constraint, true, null);
        }

        public void visitPartialEvaluationBlock(PartialEvaluationBlock block) {
            if (!Resolver.this.inTopLevelEvals) {
                if (null == this.evals) {
                    this.evals = new LinkedList<PartialEvaluationBlock>();
                }
                this.evals.add(block);
            }
        }

        public void visitAttributeAssignment(AttributeAssignment assignment) {
            boolean oldReg = Resolver.this.contexts.setRegisterContexts(true);
            for (int v = 0; v < assignment.getElementCount(); ++v) {
                assignment.getElement(v).accept((IModelVisitor)this);
            }
            for (int c = 0; c < assignment.getConstraintsCount(); ++c) {
                Resolver.this.addConstraint(Resolver.this.topLevelConstraints, assignment.getConstraint(c), true, null);
            }
            for (int a = 0; a < assignment.getAssignmentCount(); ++a) {
                assignment.getAssignment(a).accept((IModelVisitor)this);
            }
            if (!Resolver.this.incremental) {
                Resolver.this.translateAnnotationAssignments(assignment, null, null, null);
            }
            Resolver.this.contexts.setRegisterContexts(oldReg);
        }
    }

    private static class ReasonerState {
        private List<ConstraintList> constraintBase = new LinkedList<ConstraintList>();
        private VariablesMap variablesMap = new VariablesMap();

        private ReasonerState() {
        }
    }
}

