/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.reasoning.core.frontend.IReasonerInstance;
import net.ssehub.easy.reasoning.core.frontend.ReasonerFrontend;
import net.ssehub.easy.reasoning.core.reasoner.EvaluationResult;
import net.ssehub.easy.reasoning.core.reasoner.IReasoner;
import net.ssehub.easy.reasoning.core.reasoner.IReasonerInterceptor;
import net.ssehub.easy.reasoning.core.reasoner.IReasonerMessage;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerDescriptor;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.reasoning.sseReasoner.Descriptor;
import net.ssehub.easy.reasoning.sseReasoner.Engine;
import net.ssehub.easy.reasoning.sseReasoner.EvalVisitor;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IConfiguration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cstEvaluation.EvaluationVisitor;
import net.ssehub.easy.varModel.cstEvaluation.IValueChangeListener;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.values.Value;
import org.osgi.service.component.ComponentContext;

public class Reasoner
implements IReasoner {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(Reasoner.class, "net.ssehub.easy.reasoning.sseReasoner");
    private static final Descriptor DESCRIPTOR = new Descriptor();
    private IReasonerInterceptor interceptor;

    public ReasonerDescriptor getDescriptor() {
        return DESCRIPTOR;
    }

    public ReasoningResult upgrade(URI url, ProgressObserver observer) {
        return null;
    }

    public ReasoningResult isConsistent(Project project, ReasonerConfiguration reasonerConfig, ProgressObserver observer) {
        reasonerConfig = null == reasonerConfig ? new ReasonerConfiguration() : reasonerConfig;
        Engine engine = new Engine(project, this.createConfiguration(project, null, reasonerConfig, true), reasonerConfig, observer, this.interceptor);
        return engine.reason();
    }

    public ReasoningResult check(Project project, Configuration cfg, ReasonerConfiguration reasonerConfig, ProgressObserver observer) {
        reasonerConfig = null == reasonerConfig ? new ReasonerConfiguration() : reasonerConfig;
        Engine engine = new Engine(project, this.createConfiguration(project, cfg, reasonerConfig, true), reasonerConfig, observer, this.interceptor);
        return engine.reason();
    }

    public ReasoningResult propagate(Project project, Configuration cfg, ReasonerConfiguration reasonerConfig, ProgressObserver observer) {
        reasonerConfig = null == reasonerConfig ? new ReasonerConfiguration() : reasonerConfig;
        Engine engine = new Engine(project, this.createConfiguration(project, cfg, reasonerConfig, false), reasonerConfig, observer, this.interceptor);
        return engine.reason();
    }

    public ReasoningResult initialize(Project project, Configuration cfg, ReasonerConfiguration reasonerConfig, ProgressObserver observer) {
        reasonerConfig = null == reasonerConfig ? new ReasonerConfiguration() : reasonerConfig;
        Engine engine = new Engine(project, this.createConfiguration(project, cfg, reasonerConfig, false), reasonerConfig, observer, this.interceptor);
        ReasoningResult res = engine.reason();
        return res;
    }

    public EvaluationResult evaluate(Project project, Configuration cfg, List<Constraint> constraints, ReasonerConfiguration reasonerConfig, ProgressObserver observer) {
        final EvaluationResult result = new EvaluationResult(DESCRIPTOR.getName());
        EvalVisitor evaluator = new EvalVisitor((IConfiguration)cfg, null, false, new IValueChangeListener(){

            public void notifyUnresolved(IDecisionVariable variable) {
            }

            public void notifyChanged(IDecisionVariable variable, Value oldValue) {
                result.addAffected(variable);
            }
        });
        evaluator.setDispatchScope(project);
        for (int c = 0; c < constraints.size(); ++c) {
            EvaluationResult.ConstraintEvaluationResult eRes;
            Constraint constraint = constraints.get(c);
            evaluator.visit(constraint.getConsSyntax());
            Value eVal = null;
            if (evaluator.constraintFailed()) {
                eRes = EvaluationResult.ConstraintEvaluationResult.FALSE;
            } else if (evaluator.constraintFulfilled()) {
                eRes = EvaluationResult.ConstraintEvaluationResult.TRUE;
                eVal = evaluator.getResult();
            } else {
                eRes = EvaluationResult.ConstraintEvaluationResult.UNKNOWN;
            }
            result.addEvaluationPair(new EvaluationResult.EvaluationPair(constraint, eRes, eVal));
            for (int m = 0; m < evaluator.getMessageCount(); ++m) {
                EvaluationVisitor.Message eMsg = evaluator.getMessage(m);
                ArrayList<AbstractVariable> conflicts = new ArrayList<AbstractVariable>();
                conflicts.add(eMsg.getVariable());
                Message msg = new Message(eMsg.getDescription(), conflicts, eMsg.getStatus());
                ArrayList<Project> conflictProjects = new ArrayList<Project>();
                conflictProjects.add(project);
                msg.addConflictingElementProjects(conflictProjects);
                ArrayList problemVariables = new ArrayList();
                HashSet<IDecisionVariable> tmp = new HashSet<IDecisionVariable>();
                tmp.add(eMsg.getDecision());
                problemVariables.add(tmp);
                msg.addProblemVariables(problemVariables);
                ArrayList<Constraint> problemConstraints = new ArrayList<Constraint>();
                problemConstraints.add(constraint);
                result.addMessage(msg);
            }
            evaluator.clearIntermediary();
        }
        evaluator.clear();
        return result;
    }

    protected void activate(ComponentContext context) {
        ReasonerFrontend.getInstance().getRegistry().register((IReasoner)this);
        LOGGER.info("EASy-Producer IVML Reasoner started ");
    }

    protected void deactivate(ComponentContext context) {
        ReasonerFrontend.getInstance().getRegistry().unregister((IReasoner)this);
    }

    public void notify(IReasonerMessage message) {
    }

    private Configuration createConfiguration(Project project, Configuration cfg, ReasonerConfiguration rConfig, boolean freshConfig) {
        Object result = rConfig.isRuntimeMode() || !freshConfig ? cfg : null;
        if (null == result) {
            result = new Configuration(project, false);
        }
        return result;
    }

    public IReasonerInstance createInstance(Project project, Configuration cfg, ReasonerConfiguration reasonerConfiguration) {
        return new ReasonerInstance(project, cfg, reasonerConfiguration, this.interceptor);
    }

    public void setInterceptor(IReasonerInterceptor interceptor) {
        this.interceptor = interceptor;
    }

    private class ReasonerInstance
    implements IReasonerInstance {
        private Engine engine;
        private Project project;
        private Configuration cfg;
        private ReasonerConfiguration reasonerConfiguration;
        private IReasonerInterceptor interceptor;

        private ReasonerInstance(Project project, Configuration cfg, ReasonerConfiguration reasonerConfiguration, IReasonerInterceptor interceptor) {
            this.project = project;
            this.cfg = cfg;
            this.interceptor = interceptor;
            this.reasonerConfiguration = null == reasonerConfiguration ? new ReasonerConfiguration() : reasonerConfiguration;
        }

        public ReasonerDescriptor getDescriptor() {
            return DESCRIPTOR;
        }

        public ReasoningResult isConsistent(ProgressObserver observer) {
            return Reasoner.this.isConsistent(this.project, this.reasonerConfiguration, observer);
        }

        public ReasoningResult check(ProgressObserver observer) {
            return Reasoner.this.check(this.project, this.cfg, this.reasonerConfiguration, observer);
        }

        public ReasoningResult propagate(ProgressObserver observer) {
            if (null == this.engine) {
                this.engine = new Engine(this.project, Reasoner.this.createConfiguration(this.project, this.cfg, this.reasonerConfiguration, false), this.reasonerConfiguration, observer, this.interceptor);
                this.engine.markForReuse();
            } else {
                this.engine.reInit();
            }
            ReasoningResult res = this.engine.reason();
            this.engine.clear();
            return res;
        }

        public EvaluationResult evaluate(List<Constraint> constraints, ProgressObserver observer) {
            return Reasoner.this.evaluate(this.project, this.cfg, constraints, this.reasonerConfiguration, observer);
        }

        public void notify(IReasonerMessage message) {
            Reasoner.this.notify(message);
        }

        public boolean isRunning() {
            return this.engine.isRunning();
        }

        public boolean stop() {
            return this.engine.stop();
        }
    }
}

