/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.reasoning.core.reasoner.IMeasurementKey;
import net.ssehub.easy.reasoning.core.reasoner.IReasonerInterceptor;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.reasoning.sseReasoner.Measures;
import net.ssehub.easy.reasoning.sseReasoner.Resolver;
import net.ssehub.easy.reasoning.sseReasoner.functions.FailedElementDetails;
import net.ssehub.easy.reasoning.sseReasoner.functions.FailedElements;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.Project;

public class Engine {
    private static final String VIOLATED_CONSTRAINTS = "Constraints not satisfied:";
    private static final String VIOLATED_VARIABLES = "Reassignment is forbitten in the same project. Failed variables:";
    private Resolver resolver;
    private ReasoningResult result;
    private Project project;
    private List<ModelElement> failedModelElements = new ArrayList<ModelElement>();
    private List<Set<AbstractVariable>> variablesInConstraints = new ArrayList<Set<AbstractVariable>>();
    private List<Set<IDecisionVariable>> problemDecisions = new ArrayList<Set<IDecisionVariable>>();
    private List<ConstraintSyntaxTree> problemConstraintParts = new ArrayList<ConstraintSyntaxTree>();
    private List<Constraint> problemConstraints = new ArrayList<Constraint>();
    private List<Project> failedElementProjects = new ArrayList<Project>();
    private List<Message.SuggestionType> failedElementSuggestions = new ArrayList<Message.SuggestionType>();
    private List<IDecisionVariable> constraintVariables = new ArrayList<IDecisionVariable>();
    private List<Integer> errorClassification = new ArrayList<Integer>();
    private ReasonerConfiguration.IAdditionalInformationLogger infoLogger;
    private long evaluationTime;
    private int reevaluationCount;
    private int failedConstraints = 0;
    private int failedAssignments = 0;

    public Engine(Project project, Configuration cfg, ReasonerConfiguration reasonerConfig, ProgressObserver observer, IReasonerInterceptor interceptor) {
        this.project = project;
        this.resolver = new Resolver(project, cfg, reasonerConfig);
        this.resolver.setInterceptor(interceptor);
        boolean isRuntimeMode = reasonerConfig.isRuntimeMode();
        this.resolver.setIncremental(isRuntimeMode);
        this.result = new ReasoningResult();
        this.infoLogger = reasonerConfig.getLogger();
        if (!isRuntimeMode) {
            cfg.unfreeze((IAssignmentState)AssignmentState.DERIVED);
        }
    }

    public ReasoningResult reason() {
        long startTime = System.currentTimeMillis();
        this.resolver.resolve();
        this.result.setTimeout(this.resolver.hasTimeout());
        this.result.setStopped(this.resolver.wasStopped());
        FailedElements failedElements = this.resolver.getFailedElements();
        if (failedElements.hasProblems()) {
            this.analyzeProblemConstraints(failedElements);
            this.analyzeProblemVariables(failedElements);
        }
        this.evaluationTime = System.currentTimeMillis() - startTime;
        this.reevaluationCount = this.resolver.reevaluationCount();
        this.infoLogger.info("");
        this.infoLogger.info("Model: " + this.project.getName());
        this.infoLogger.info("Number of variables involved in constraints: " + this.resolver.variableInConstraintCount());
        this.infoLogger.info("Number of constraints: " + this.resolver.constraintCount());
        this.infoLogger.info("Number of reevaluations: " + this.reevaluationCount);
        this.result.setMeasure((IMeasurementKey)Measures.REEVALUATION_COUNT, (Number)this.reevaluationCount);
        this.infoLogger.info("Number of problem constraints: " + this.failedConstraints);
        this.infoLogger.info("Number of problem assignments: " + this.failedAssignments);
        this.infoLogger.info("Total time: " + this.evaluationTime);
        this.infoLogger.info("Translation time: " + this.resolver.getTranslationTime());
        this.infoLogger.info("Evaluation time: " + this.resolver.getEvaluationTime());
        return this.result;
    }

    private void analyzeProblemConstraints(FailedElements failedElements) {
        if (failedElements.problemConstraintCount() > 0) {
            Map<Constraint, FailedElementDetails> problemConstraintMap = failedElements.getProblemConstraintMap();
            Iterator<Constraint> problemIterator = failedElements.getProblemConstraints();
            while (problemIterator.hasNext()) {
                ++this.failedConstraints;
                Constraint constraint = problemIterator.next();
                this.failedModelElements.add((ModelElement)constraint);
                FailedElementDetails failedElementDetails = problemConstraintMap.get(constraint);
                if (constraint.getTopLevelParent() instanceof Project) {
                    this.failedElementProjects.add((Project)constraint.getTopLevelParent());
                }
                this.constraintVariables.add(this.resolver.getConstraintVariable(constraint));
                Set<IDecisionVariable> problemVars = failedElementDetails.getProblemPoints();
                HashSet<AbstractVariable> vars = new HashSet<AbstractVariable>();
                for (IDecisionVariable problemVar : problemVars) {
                    vars.add(problemVar.getDeclaration());
                }
                this.variablesInConstraints.add(vars);
                this.problemDecisions.add(problemVars);
                this.problemConstraintParts.add(failedElementDetails.getProblemConstraintPart());
                this.problemConstraints.add(failedElementDetails.getProblemConstraint());
                this.failedElementSuggestions.add(Message.SuggestionType.PROBLEM_POINTS);
                this.errorClassification.add(failedElementDetails.getErrorClassifier());
            }
            Message problemConstraintMsg = this.createMessage(VIOLATED_CONSTRAINTS);
            this.result.addMessage(problemConstraintMsg);
            this.printMessage(problemConstraintMsg);
            this.clearFailedInfo();
        }
    }

    private void analyzeProblemVariables(FailedElements failedElements) {
        if (failedElements.problemVariabletCount() > 0) {
            Map<AbstractVariable, FailedElementDetails> problemVariableMap = failedElements.getProblemVariableMap();
            Iterator<AbstractVariable> problemVariables = failedElements.getProblemVariables();
            while (problemVariables.hasNext()) {
                ++this.failedAssignments;
                AbstractVariable problemVariable = problemVariables.next();
                this.failedModelElements.add((ModelElement)problemVariable);
                FailedElementDetails failedElementDetails = problemVariableMap.get(problemVariable);
                if (problemVariable.getTopLevelParent() instanceof Project) {
                    this.failedElementProjects.add((Project)problemVariable.getTopLevelParent());
                }
                this.failedElementSuggestions.add(Message.SuggestionType.REASSIGNMENT);
                HashSet<AbstractVariable> vars = new HashSet<AbstractVariable>();
                vars.add(problemVariable);
                this.problemDecisions.add(failedElementDetails.getProblemPoints());
                this.problemConstraintParts.add(failedElementDetails.getProblemConstraintPart());
                this.problemConstraints.add(failedElementDetails.getProblemConstraint());
                this.variablesInConstraints.add(vars);
                this.constraintVariables.add(null);
                this.errorClassification.add(failedElementDetails.getErrorClassifier());
            }
            Message problemVarialbeMsg = this.createMessage(VIOLATED_VARIABLES);
            this.result.addMessage(problemVarialbeMsg);
            this.printMessage(problemVarialbeMsg);
            this.clearFailedInfo();
        }
    }

    private void clearFailedInfo() {
        this.failedModelElements.clear();
        this.variablesInConstraints.clear();
        this.problemDecisions.clear();
        this.problemConstraintParts.clear();
        this.problemConstraints.clear();
        this.failedElementProjects.clear();
        this.failedElementSuggestions.clear();
        this.constraintVariables.clear();
        this.errorClassification.clear();
    }

    private Message createMessage(String text) {
        Message msg = new Message(text, this.failedModelElements, Status.ERROR);
        msg.addConstraintVariables(this.variablesInConstraints);
        msg.addProblemVariables(this.problemDecisions);
        msg.addProblemConstraintParts(this.problemConstraintParts);
        msg.addProblemConstraints(this.problemConstraints);
        msg.addConflictingElementProjects(this.failedElementProjects);
        msg.addConflictingElementSuggestions(this.failedElementSuggestions);
        msg.addNamedConstraintVariables(this.constraintVariables);
        msg.addErrorClassification(this.errorClassification);
        return msg;
    }

    private void printMessage(Message msg) {
        this.infoLogger.info(msg.toString());
    }

    public long getEvaluationTime() {
        return this.evaluationTime;
    }

    public long getReevaluationCount() {
        return this.reevaluationCount;
    }

    boolean isRunning() {
        return this.resolver.isRunning();
    }

    boolean stop() {
        return this.resolver.stop();
    }

    void clear() {
        this.result = new ReasoningResult();
        this.clearFailedInfo();
        this.evaluationTime = 0L;
        this.reevaluationCount = 0;
        this.failedConstraints = 0;
        this.failedAssignments = 0;
        this.resolver.clear();
    }

    void markForReuse() {
        this.resolver.markForReuse();
    }

    void reInit() {
        this.resolver.reInit();
    }

    void setAssignmentState(IAssignmentState state) {
        this.resolver.setAssignmentState(state);
    }
}

