/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.sseReasoner;

import net.ssehub.easy.reasoning.sseReasoner.Resolver;
import net.ssehub.easy.reasoning.sseReasoner.model.ReasoningUtils;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.TypeQueries;
import net.ssehub.easy.varModel.model.values.BooleanValue;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.ConstraintValue;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.IValueVisitor;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueVisitorAdapter;

class CheckInitializerVisitor
extends ValueVisitorAdapter
implements IConstraintTreeVisitor {
    private Resolver resolver;
    private boolean isCompoundInitializer;
    private ConstraintSyntaxTree expression;
    private Value value;
    private boolean process;
    private IDecisionVariable variable;
    private IModelElement parent;
    private boolean substituteVars;

    public CheckInitializerVisitor(Resolver resolver) {
        this.resolver = resolver;
    }

    public void accept(ConstraintSyntaxTree cst, IModelElement parent, IDecisionVariable variable) {
        this.process = false;
        cst.accept((IConstraintTreeVisitor)this);
        IDecisionVariable sVariable = this.variable;
        IModelElement sParent = this.parent;
        boolean sSubstituteVars = this.substituteVars;
        this.process = true;
        this.parent = parent;
        this.variable = variable;
        if (null != this.expression) {
            this.substituteVars = this.isCompoundInitializer;
            this.expression.accept((IConstraintTreeVisitor)this);
        } else if (null != this.value) {
            this.substituteVars = false;
            this.value.accept((IValueVisitor)this);
        }
        variable = sVariable;
        parent = sParent;
        this.substituteVars = sSubstituteVars;
        this.isCompoundInitializer = false;
        this.expression = null;
        this.value = null;
    }

    public void visitCompoundValue(CompoundValue value) {
        Compound cmp = (Compound)value.getType();
        for (String slot : value.getSlotNames()) {
            Value slotValue = value.getNestedValue(slot);
            if (null == slotValue) continue;
            DecisionVariableDeclaration slotDecl = cmp.getElement(slot);
            IDatatype slotType = slotDecl.getType();
            if (TypeQueries.isContainer((IDatatype)slotType)) {
                slotValue.accept((IValueVisitor)this);
                continue;
            }
            if (!TypeQueries.isConstraint((IDatatype)slotType)) continue;
            this.createConstraintFromValue(slotValue);
        }
    }

    public void visitContainerValue(ContainerValue value) {
        if (TypeQueries.isConstraint((IDatatype)value.getContainedType())) {
            for (int s = 0; s < value.getElementSize(); ++s) {
                this.createConstraintFromValue(value.getElement(s));
            }
        } else {
            for (int s = 0; s < value.getElementSize(); ++s) {
                value.getElement(s).accept((IValueVisitor)this);
            }
        }
    }

    public void visitConstraintValue(ConstraintValue value) {
    }

    public void visitBooleanValue(BooleanValue value) {
    }

    private void createConstraintFromValue(Value value) {
        ConstraintSyntaxTree cst = ReasoningUtils.getConstraintValueConstraintExpression(value);
        if (null != cst) {
            this.resolver.createConstraintVariableConstraint(cst, null, null, this.parent, null);
        }
    }

    public void visitCompoundInitializer(CompoundInitializer compoundInit) {
        for (int i = 0; i < compoundInit.getExpressionCount(); ++i) {
            ConstraintSyntaxTree initEx = compoundInit.getExpression(i);
            initEx.accept((IConstraintTreeVisitor)this);
            if (!this.process) continue;
            this.checkForConstraint(compoundInit.getSlotDeclaration(i).getType(), initEx);
        }
    }

    public void visitContainerInitializer(ContainerInitializer containerInit) {
        for (int i = 0; i < containerInit.getExpressionCount(); ++i) {
            ConstraintSyntaxTree cst = containerInit.getExpression(i);
            cst.accept((IConstraintTreeVisitor)this);
            if (!this.process) continue;
            this.checkForConstraint(containerInit.getType().getContainedType(), cst);
        }
    }

    private void checkForConstraint(IDatatype type, ConstraintSyntaxTree cst) {
        if (TypeQueries.isConstraint((IDatatype)type)) {
            if (this.substituteVars) {
                cst = this.resolver.substituteVariables(cst, null, null);
            }
            this.resolver.createConstraintVariableConstraint(cst, null, false, this.parent, this.variable);
        }
    }

    public void visitConstantValue(ConstantValue value) {
    }

    public void visitVariable(Variable variable) {
    }

    public void visitAnnotationVariable(AttributeVariable variable) {
        this.visitVariable((Variable)variable);
    }

    public void visitParenthesis(Parenthesis parenthesis) {
        parenthesis.getExpr().accept((IConstraintTreeVisitor)this);
    }

    public void visitComment(Comment comment) {
    }

    public void visitOclFeatureCall(OCLFeatureCall call) {
        if (null != call.getOperand()) {
            if ((call.getOperand() instanceof Variable || call.getOperand() instanceof CompoundAccess) && call.getParameterCount() == 1 && call.getOperation().equals("=")) {
                ConstraintSyntaxTree param0 = call.getParameter(0);
                if (param0 instanceof ContainerInitializer) {
                    this.expression = call.getParameter(0);
                } else if (param0 instanceof CompoundInitializer) {
                    this.isCompoundInitializer = true;
                    this.expression = call.getParameter(0);
                } else if (param0 instanceof ConstantValue) {
                    this.value = ((ConstantValue)param0).getConstantValue();
                }
            }
            call.getOperand().accept((IConstraintTreeVisitor)this);
            for (int i = 0; i < call.getParameterCount(); ++i) {
                call.getParameter(i).accept((IConstraintTreeVisitor)this);
            }
        }
    }

    public void visitLet(Let let) {
        let.getInExpression().accept((IConstraintTreeVisitor)this);
    }

    public void visitIfThen(IfThen ifThen) {
        ifThen.getIfExpr().accept((IConstraintTreeVisitor)this);
        ifThen.getThenExpr().accept((IConstraintTreeVisitor)this);
        ifThen.getElseExpr().accept((IConstraintTreeVisitor)this);
    }

    public void visitContainerOperationCall(ContainerOperationCall call) {
        call.getContainer().accept((IConstraintTreeVisitor)this);
        call.getExpression().accept((IConstraintTreeVisitor)this);
    }

    public void visitCompoundAccess(CompoundAccess access) {
        access.getCompoundExpression().accept((IConstraintTreeVisitor)this);
    }

    public void visitUnresolvedExpression(UnresolvedExpression expression) {
    }

    public void visitSelf(Self self) {
    }

    public void visitBlockExpression(BlockExpression block) {
        int n = block.getExpressionCount();
        for (int e = 0; e < n; ++e) {
            block.getExpression(e).accept((IConstraintTreeVisitor)this);
        }
    }

    public void visitMultiAndExpression(MultiAndExpression expression) {
        for (int e = 0; e < expression.getExpressionCount(); ++e) {
            expression.getExpression(e).accept((IConstraintTreeVisitor)this);
        }
    }
}

