/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.reasoner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.reasoning.core.reasoner.IMeasurementKey;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.Project;

public class ReasoningResult {
    private List<IDecisionVariable> affected = null;
    private List<Message> messages = new ArrayList<Message>();
    private boolean hasConflict = false;
    private boolean hasTimeout;
    private boolean wasStopped;
    private Map<IMeasurementKey, Number> measures;

    public ReasoningResult() {
    }

    public ReasoningResult(String reasonerName) {
        this();
        String message = "Reasoning not supported by " + reasonerName;
        Message unsupportedReasoning = new Message(message, null, Status.UNSUPPORTED);
        this.addMessage(unsupportedReasoning);
    }

    public void addAffected(IDecisionVariable var) {
        if (null == this.affected) {
            this.affected = new ArrayList<IDecisionVariable>();
        }
        this.affected.add(var);
    }

    public void addMessage(Message message) {
        this.messages.add(message);
        if (Status.ERROR == message.getStatus()) {
            this.hasConflict = true;
        }
    }

    public void setTimeout(boolean hasTimeout) {
        this.hasTimeout = hasTimeout;
    }

    public void setStopped(boolean wasStopped) {
        this.wasStopped = wasStopped;
    }

    public boolean hasTimeout() {
        return this.hasTimeout;
    }

    public boolean wasStopped() {
        return this.wasStopped;
    }

    public boolean hasConflict() {
        return this.hasConflict;
    }

    public boolean hasInfo() {
        boolean hasInfo = false;
        for (int i = 0; i < this.messages.size() && !hasInfo; ++i) {
            if (Status.INFO != this.messages.get(i).getStatus()) continue;
            hasInfo = true;
        }
        return hasInfo;
    }

    public boolean reasoningUnsupported() {
        boolean unsupported = false;
        if (1 == this.messages.size() && Status.UNSUPPORTED == this.messages.get(0).getStatus()) {
            unsupported = true;
        }
        return unsupported;
    }

    public int getMessageCount() {
        return this.messages.size();
    }

    public Message getMessage(int index) {
        return this.messages.get(index);
    }

    public boolean providesInformationOnAffectedVariables() {
        return this.affected != null;
    }

    public int getAffectedVariablesCount() {
        return null != this.affected ? this.affected.size() : 0;
    }

    public IDecisionVariable getAffectedVariable(int index) {
        return this.affected.get(index);
    }

    public void setMeasure(IMeasurementKey key, Number value) {
        if (null != key) {
            if (null == this.measures) {
                this.measures = new HashMap<IMeasurementKey, Number>();
            }
            this.measures.put(key, value);
        }
    }

    public Number getMeasure(IMeasurementKey key) {
        return null == key || null == this.measures ? (Number)null : (Number)this.measures.get(key);
    }

    public Set<IMeasurementKey> measurementKeys() {
        return null == this.measures ? null : this.measures.keySet();
    }

    public void logInformation(Project prj, ReasonerConfiguration rConfig) {
        this.logInformation(prj, rConfig, true);
    }

    public void logInformation(Project prj, ReasonerConfiguration rConfig, boolean withMessages) {
        this.logInformation(prj, rConfig.getLogger(), withMessages);
    }

    public void logInformation(Project prj, ReasonerConfiguration.IAdditionalInformationLogger infoLogger, boolean withMessages) {
        infoLogger.info("Model: " + prj.getName());
        if (null != this.measures) {
            Set<IMeasurementKey> keys = this.measures.keySet();
            IMeasurementKey[] sortedKeys = new IMeasurementKey[keys.size()];
            keys.toArray(sortedKeys);
            Arrays.sort(sortedKeys, new Comparator<IMeasurementKey>(){

                @Override
                public int compare(IMeasurementKey o1, IMeasurementKey o2) {
                    return -Integer.compare(o1.outputPos(), o2.outputPos());
                }
            });
            for (int k = 0; k < sortedKeys.length; ++k) {
                IMeasurementKey key = sortedKeys[k];
                infoLogger.info(key.getExplanation() + ": " + this.getMeasure(key));
            }
        }
        if (withMessages && !this.messages.isEmpty()) {
            infoLogger.info("");
            for (int m = 0; m < this.messages.size(); ++m) {
                infoLogger.info(this.messages.get(m));
            }
        }
        infoLogger.info("");
    }
}

