/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.reasoner;

import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.varModel.capabilities.IReasonerCapability;

public class ReasonerDescriptor {
    private URL downloadSource;
    private String name;
    private String version;
    private String license;
    private String licenseRestriction;
    private Set<IReasonerCapability> capabilities;

    public ReasonerDescriptor(String name, String version, String license, String licenseRestriction, URL downloadSource) {
        this.name = name;
        this.version = version;
        this.license = license;
        this.licenseRestriction = licenseRestriction;
        this.downloadSource = downloadSource;
    }

    protected void addCapability(IReasonerCapability capability) {
        if (null != capability) {
            if (null == this.capabilities) {
                this.capabilities = new HashSet<IReasonerCapability>();
            }
            this.capabilities.add(capability);
        }
    }

    protected void addCapabilities(Collection<IReasonerCapability> capabilities) {
        if (null != capabilities) {
            for (IReasonerCapability capability : capabilities) {
                this.addCapability(capability);
            }
        }
    }

    public URL getDownloadSource() {
        return this.downloadSource;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getLicense() {
        return this.license;
    }

    public String getLicenseRestriction() {
        return this.licenseRestriction;
    }

    public boolean isReadyForUse() {
        return true;
    }

    public boolean providesAffectedVariables() {
        return true;
    }

    public boolean hasCapability(IReasonerCapability capability) {
        boolean result = null == this.capabilities || null == capability ? false : this.capabilities.contains(capability);
        return result;
    }

    public int getCapabilityCount() {
        return null == this.capabilities ? 0 : this.capabilities.size();
    }

    public IReasonerCapability[] getCapabilities() {
        IReasonerCapability[] result = new IReasonerCapability[this.getCapabilityCount()];
        if (null != this.capabilities) {
            this.capabilities.toArray(result);
        }
        return result;
    }
}

