/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.reasoner;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.reasoning.core.reasoner.IUpgrader;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;

public class FileUpgrader
extends IUpgrader {
    public FileUpgrader(URI source, String dest, Map<String, String> files, String marker, ProgressObserver observer) {
        super(source, dest, files, marker, observer);
    }

    @Override
    public ReasoningResult upgrade() {
        ReasoningResult result = new ReasoningResult();
        if (!this.doUpgrade(result)) {
            result.addMessage(new Message("cannot handle '" + this.getSource() + "'", null, Status.ERROR));
        }
        return result;
    }

    @Override
    protected boolean doUpgrade(ReasoningResult result) {
        boolean done = false;
        if (null == this.getExtension()) {
            File sourceDir = new File(this.getSource());
            Iterator<Map.Entry<String, String>> iter = this.allFileMappings();
            while (iter.hasNext()) {
                Map.Entry<String, String> entry = iter.next();
                File sourceFile = new File(sourceDir, entry.getKey());
                File targetFile = this.obtainTargetFile(entry.getValue());
                try {
                    this.copy(sourceFile, targetFile);
                }
                catch (IOException e) {
                    this.error(result, e);
                }
            }
            done = true;
        }
        return done;
    }

    protected String getExtension() {
        String path = this.getSource().getPath();
        int lastSep = Math.max(0, path.lastIndexOf(47));
        int extensionDot = path.lastIndexOf(46);
        String extension = null;
        if (extensionDot > lastSep) {
            extension = path.substring(extensionDot + 1);
        }
        return extension;
    }
}

