/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.reasoner;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.values.Value;

public class EvaluationResult
extends ReasoningResult {
    private List<EvaluationPair> evaluatedConstraints = new ArrayList<EvaluationPair>();

    public EvaluationResult() {
    }

    public EvaluationResult(String reasonerName) {
        super(reasonerName);
    }

    public void addEvaluationPair(EvaluationPair pair) {
        this.evaluatedConstraints.add(pair);
    }

    public int getEvaluationPairCount() {
        return this.evaluatedConstraints.size();
    }

    public EvaluationPair getEvaluationPair(int index) {
        return this.evaluatedConstraints.get(index);
    }

    public static class EvaluationPair {
        private Constraint constraint;
        private ConstraintEvaluationResult result;
        private Value value;

        public EvaluationPair(Constraint constraint) {
            this(constraint, ConstraintEvaluationResult.UNKNOWN, null);
        }

        public EvaluationPair(Constraint constraint, ConstraintEvaluationResult result) {
            this(constraint, result, null);
        }

        public EvaluationPair(Constraint constraint, ConstraintEvaluationResult result, Value value) {
            this.constraint = constraint;
            this.result = result;
            this.value = value;
        }

        public void setResult(ConstraintEvaluationResult result) {
            assert (null != result);
            this.result = result;
        }

        public Constraint getConstraint() {
            return this.constraint;
        }

        public ConstraintEvaluationResult getResult() {
            return this.result;
        }

        public Value getValue() {
            return this.value;
        }
    }

    public static enum ConstraintEvaluationResult {
        TRUE,
        FALSE,
        UNKNOWN;

    }
}

