/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.reasoner;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.reasoning.core.reasoner.AttributeValues;
import net.ssehub.easy.reasoning.core.reasoner.Message;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.reasoning.core.reasoner.ReasoningResult;
import net.ssehub.easy.varModel.confModel.AssignmentState;
import net.ssehub.easy.varModel.confModel.Configuration;
import net.ssehub.easy.varModel.confModel.IAssignmentState;
import net.ssehub.easy.varModel.confModel.IConfigurationElement;
import net.ssehub.easy.varModel.confModel.IConfigurationVisitor;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.values.Value;

public class AttributesCheckVisitor
implements IConfigurationVisitor {
    private ReasoningResult result;
    private Map<String, List<Value>> values = new HashMap<String, List<Value>>();
    private boolean isValid = true;

    private AttributesCheckVisitor(ReasoningResult result, AttributeValues values) {
        this.result = result;
        Iterator<Attribute> iter = values.getAttributes();
        while (iter.hasNext()) {
            Attribute attr = iter.next();
            int valueCount = values.getAttributeValuesCount(attr);
            if (valueCount <= 0) continue;
            String key = attr.getName();
            List<Value> valueList = this.values.get(key);
            if (null == valueList) {
                valueList = new ArrayList<Value>();
                this.values.put(key, valueList);
            }
            for (int v = 0; v < valueCount; ++v) {
                valueList.add(values.getAttributeValue(attr, v));
            }
        }
    }

    public static boolean check(Configuration configuration, ReasonerConfiguration reasonerConfiguration, ReasoningResult result) {
        return AttributesCheckVisitor.check(configuration, ReasonerConfiguration.getAttributeValues(reasonerConfiguration), result);
    }

    public static boolean check(Configuration configuration, AttributeValues values, ReasoningResult result) {
        boolean isOk = true;
        if (null != values && !values.isEmpty()) {
            AttributesCheckVisitor visitor = new AttributesCheckVisitor(result, values);
            configuration.accept((IConfigurationVisitor)visitor);
            isOk = visitor.isValid();
        }
        return isOk;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public void visitConfiguration(Configuration configuration) {
        Iterator iter = configuration.iterator();
        while (iter.hasNext()) {
            ((IDecisionVariable)iter.next()).accept((IConfigurationVisitor)this);
        }
    }

    public void visitDecisionVariable(IDecisionVariable variable) {
        for (int n = 0; n < variable.getNestedElementsCount(); ++n) {
            variable.getNestedElement(n).accept((IConfigurationVisitor)this);
        }
        this.isValid &= this.checkDecisionVariable(variable);
    }

    private boolean checkDecisionVariable(IDecisionVariable variable) {
        boolean isValid = true;
        AbstractVariable decl = variable.getDeclaration();
        if (!decl.isAttribute()) {
            int aCount = variable.getAttributesCount();
            for (int a = 0; a < aCount; ++a) {
                IDecisionVariable attribute = variable.getAttribute(a);
                if (this.checkDecisionVariable(attribute, variable.getState())) continue;
                this.result.addMessage(AttributesCheckVisitor.createMessage(AttributesCheckVisitor.getQualifiedName(variable), attribute.getDeclaration().getQualifiedName(), attribute.getValue(), (ModelElement)decl));
                isValid = false;
            }
        }
        return isValid;
    }

    private static String getQualifiedName(IDecisionVariable variable) {
        IConfigurationElement parent = variable.getParent();
        String result = parent instanceof Configuration ? ((Configuration)parent).getProject().getName() + "::" : (parent instanceof IDecisionVariable ? AttributesCheckVisitor.getQualifiedName((IDecisionVariable)parent) + "::" : "");
        result = result + variable.getDeclaration().getName();
        return result;
    }

    private boolean checkDecisionVariable(IDecisionVariable attribute, IAssignmentState state) {
        List<Value> valueList;
        boolean isValid = true;
        Value val = attribute.getValue();
        if (null != val && null != (valueList = this.values.get(attribute.getDeclaration().getName())) && valueList.contains(val) && AssignmentState.FROZEN != state) {
            isValid = false;
        }
        return isValid;
    }

    public static Message createMessage(String variableName, String attributeName, Value value, ModelElement conflictingModelElement) {
        return new Message("variable " + variableName + " is not frozen according to attribute " + attributeName + " = " + AttributeValues.toString(value), Message.createList(conflictingModelElement), Status.ERROR);
    }
}

