/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.reasoning.core.impl;

import java.util.ArrayList;
import net.ssehub.easy.reasoning.core.frontend.IMessageListener;
import net.ssehub.easy.reasoning.core.impl.ReasonerMessage;
import net.ssehub.easy.reasoning.core.reasoner.IReasoner;
import net.ssehub.easy.reasoning.core.reasoner.IReasonerMessage;
import net.ssehub.easy.reasoning.core.reasoner.IReasonerRegistry;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerDescriptor;

public class ReasonerRegistry
implements IReasonerRegistry {
    private static ReasonerRegistry reasonerRegistry = null;
    private ArrayList<IReasoner> reasoner = new ArrayList();
    private ArrayList<IMessageListener> listener = new ArrayList();

    private ReasonerRegistry() {
    }

    public static ReasonerRegistry getInstance() {
        if (null == reasonerRegistry) {
            reasonerRegistry = new ReasonerRegistry();
        }
        return reasonerRegistry;
    }

    @Override
    public void register(IReasoner reasoner) {
        this.reasoner.add(reasoner);
    }

    @Override
    public void unregister(IReasoner reasoner) {
        this.reasoner.remove(reasoner);
    }

    public void register(IMessageListener listener) {
        this.listener.add(listener);
    }

    public void unregister(IMessageListener listener) {
        this.listener.remove(listener);
    }

    @Override
    public void notifyAllReasoners(IReasoner source, IReasonerMessage.IType type) {
        ReasonerMessage message = new ReasonerMessage(source, type);
        for (IReasoner r : this.reasoner) {
            if (source == this.reasoner) continue;
            r.notify(message);
            for (IMessageListener listener : this.listener) {
                listener.notify(source.getDescriptor(), type);
            }
        }
    }

    public int getReasonerCount() {
        return this.reasoner.size();
    }

    public IReasoner getReasoner(int index) {
        return this.reasoner.get(index);
    }

    public IReasoner findReasoner(ReasonerDescriptor descriptor) {
        IReasoner result = null;
        int size = this.reasoner.size();
        for (int r = 0; null == result && r < size; ++r) {
            IReasoner tmp = this.reasoner.get(r);
            ReasonerDescriptor dsc = this.reasoner.get(r).getDescriptor();
            if (null == dsc || !dsc.equals(descriptor)) continue;
            result = tmp;
        }
        return result;
    }

    public IReasoner findReasoner(String name, String version) {
        IReasoner result = null;
        if (null != name) {
            int size = this.reasoner.size();
            for (int r = 0; null == result && r < size; ++r) {
                IReasoner tmp = this.reasoner.get(r);
                ReasonerDescriptor dsc = this.reasoner.get(r).getDescriptor();
                if (!name.equals(dsc.getName()) || null != version && !version.equals(dsc.getVersion())) continue;
                result = tmp;
            }
        }
        return result;
    }
}

