/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.translation;

import de.uni_hildesheim.sse.ivml.AccessName;
import de.uni_hildesheim.sse.ivml.AnnotateTo;
import de.uni_hildesheim.sse.ivml.AttrAssignment;
import de.uni_hildesheim.sse.ivml.Eval;
import de.uni_hildesheim.sse.ivml.ExpressionStatement;
import de.uni_hildesheim.sse.ivml.Freeze;
import de.uni_hildesheim.sse.ivml.IvmlPackage;
import de.uni_hildesheim.sse.ivml.OpDefStatement;
import de.uni_hildesheim.sse.ivml.QualifiedName;
import de.uni_hildesheim.sse.ivml.Typedef;
import de.uni_hildesheim.sse.ivml.VariableDeclaration;
import de.uni_hildesheim.sse.ivml.VariableDeclarationPart;
import de.uni_hildesheim.sse.translation.CommentUtils;
import de.uni_hildesheim.sse.translation.TypeContext;
import java.util.LinkedList;
import java.util.List;
import net.ssehub.easy.dslCore.translation.MessageReceiver;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.varModel.cstEvaluation.DispatchInformation;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.StructuredComment;
import net.ssehub.easy.varModel.model.datatypes.CustomOperation;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class Utils {
    private Utils() {
    }

    public static String getQualifiedNameString(QualifiedName name) {
        return Utils.getQualifiedNameString(name, null);
    }

    public static String getQualifiedNameString(QualifiedName name, AccessName aName) {
        StringBuilder result = new StringBuilder();
        for (String s : name.getQName()) {
            result.append(s);
        }
        if (null != aName) {
            for (String s : aName.getAName()) {
                result.append(s);
            }
        }
        return result.toString();
    }

    public static <T> List<T> select(List<EObject> list, Class<T> type) {
        LinkedList<T> result = new LinkedList<T>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            EObject tmp = list.get(i);
            if (!type.isInstance(tmp)) continue;
            result.add(type.cast(tmp));
        }
        return result;
    }

    private static <T> List<T> assign(List<T> list, Object element, Class<T> type) {
        if (type.isInstance(element)) {
            if (null == list) {
                list = new LinkedList<T>();
            }
            list.add(type.cast(element));
        }
        return list;
    }

    public static SplitResult split(List<EObject> elements) {
        SplitResult result = new SplitResult();
        Utils.split(elements, result);
        return result;
    }

    public static void split(List<EObject> elements, SplitResult result) {
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            EObject tmp = elements.get(i);
            result.typedefs = Utils.assign(result.typedefs, tmp, Typedef.class);
            result.varDecls = Utils.assign(result.varDecls, tmp, VariableDeclaration.class);
            result.freezes = Utils.assign(result.freezes, tmp, Freeze.class);
            result.evals = Utils.assign(result.evals, tmp, Eval.class);
            result.exprs = Utils.assign(result.exprs, tmp, ExpressionStatement.class);
            result.attrs = Utils.assign(result.attrs, tmp, AnnotateTo.class);
            result.opdefs = Utils.assign(result.opdefs, tmp, OpDefStatement.class);
            result.attrAssignments = Utils.assign(result.attrAssignments, tmp, AttrAssignment.class);
        }
    }

    public static final boolean isImportResolutionEnabled() {
        return VarModel.INSTANCE.locations().getLocationCount() > 0;
    }

    public static String toString(VariableDeclaration varDecl) {
        String result = "";
        for (VariableDeclarationPart p : varDecl.getDecls()) {
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + p.getName();
        }
        return result;
    }

    static String unqualified(IDatatype type) {
        return IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)type);
    }

    static StructuredComment createStructuredComment(EObject object, TypeContext context, List<Comment> comments) {
        StructuredComment comment = comments.isEmpty() ? null : CommentUtils.ensureStructuredComment(object, context);
        return comment;
    }

    static void assignComments(StructuredComment target, List<?> elements, List<Comment> comments, IModelElement parent) {
        assert (comments.size() == elements.size());
        for (int i = 0; i < comments.size(); ++i) {
            Comment comment = comments.get(i);
            if (null == comment) continue;
            comment.setParent(parent);
            target.assignComment(elements.get(i), comment);
        }
    }

    static void setAnnotations(OpDefStatement op, CustomOperation operation, Project project, MessageReceiver receiver) {
        if (null != op.getAnnotations()) {
            operation.setAnnotations(op.getAnnotations().getId());
            boolean dispCase = operation.hasAnnotation("dispatchCase");
            boolean override = operation.hasAnnotation("override");
            if (dispCase || override) {
                IDatatype[] paramTypes = new IDatatype[operation.getParameterCount()];
                for (int p = 0; p < paramTypes.length; ++p) {
                    paramTypes[p] = operation.getParameterType(p);
                }
                DispatchInformation di = new DispatchInformation(operation, paramTypes, true);
                di.checkForDispatch(project);
                if (dispCase && di.getCandidatesCount() > 0) {
                    if (di.getDispatchBasisCount() > 1) {
                        receiver.warning("Multiple matching dispatch basis operations found for " + operation.getSignature(), (EObject)op, (EStructuralFeature)IvmlPackage.Literals.OP_DEF_STATEMENT__ANNOTATIONS, 20211);
                    } else if (di.getDispatchBasisCount() == 0) {
                        receiver.warning("No matching dispatch basis operations found for " + operation.getSignature(), (EObject)op, (EStructuralFeature)IvmlPackage.Literals.OP_DEF_STATEMENT__ANNOTATIONS, 20211);
                    }
                }
                if (override) {
                    boolean ok;
                    boolean bl = ok = di.getCandidatesCount() > 0 && di.getOverrideCount() < di.getCandidatesCount();
                    if (!ok) {
                        receiver.warning("No matching non-overriding operation found for " + operation.getSignature(), (EObject)op, (EStructuralFeature)IvmlPackage.Literals.OP_DEF_STATEMENT__ANNOTATIONS, 20211);
                    }
                }
            }
        }
    }

    static void checkDefaultParamSequence(OpDefStatement op, DecisionVariableDeclaration[] param, MessageReceiver receiver) {
        int lastNonDefaultParam = -1;
        int lastDefaultParam = -1;
        for (int p = 0; p < param.length; ++p) {
            if (null == param[p].getName()) {
                lastNonDefaultParam = p;
                continue;
            }
            if (lastDefaultParam >= 0) continue;
            lastDefaultParam = p;
        }
        if (param.length > 0 && lastDefaultParam > 0 && lastNonDefaultParam > lastDefaultParam) {
            receiver.error("parameters with default values must follow parameters without default values", (EObject)op, (EStructuralFeature)IvmlPackage.Literals.ACTUAL_ARGUMENT_LIST__NAME, 20211);
        }
    }

    static void alreadyDefinedError(String name, EObject object, EStructuralFeature feature) throws TranslatorException {
        throw new TranslatorException("name '" + name + "' is already defined in the same scope", object, feature, 20205);
    }

    static String toString(List<VariableDeclarationPart> parts) {
        String result = "";
        for (int i = 0; i < parts.size(); ++i) {
            if (i > 0) {
                result = result + ",";
            }
            result = result + parts.get(i).getName();
        }
        return result;
    }

    public static class SplitResult {
        private List<Typedef> typedefs;
        private List<VariableDeclaration> varDecls;
        private List<Freeze> freezes;
        private List<Eval> evals;
        private List<ExpressionStatement> exprs;
        private List<AnnotateTo> attrs;
        private List<OpDefStatement> opdefs;
        private List<AttrAssignment> attrAssignments;

        public List<Typedef> getTypedefs() {
            return this.typedefs;
        }

        public List<VariableDeclaration> getVarDecls() {
            return this.varDecls;
        }

        public List<Freeze> getFreezes() {
            return this.freezes;
        }

        public List<Eval> getEvals() {
            return this.evals;
        }

        public List<ExpressionStatement> getExprs() {
            return this.exprs;
        }

        public List<AnnotateTo> getAttrs() {
            return this.attrs;
        }

        public List<OpDefStatement> getOpdefs() {
            return this.opdefs;
        }

        public List<AttrAssignment> getAttrAssignments() {
            return this.attrAssignments;
        }
    }
}

