/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.translation;

import de.uni_hildesheim.sse.ModelUtility;
import de.uni_hildesheim.sse.ivml.DerivedType;
import de.uni_hildesheim.sse.ivml.IvmlPackage;
import de.uni_hildesheim.sse.ivml.Type;
import de.uni_hildesheim.sse.ivml.Typedef;
import de.uni_hildesheim.sse.translation.ContainableElementsMapAndComparator;
import de.uni_hildesheim.sse.translation.UnknownTypeException;
import de.uni_hildesheim.sse.translation.Utils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.ssehub.easy.basics.messages.IIdentifiable;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.dslCore.translation.MessageReceiver;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.varModel.capabilities.DefaultReasonerAccess;
import net.ssehub.easy.varModel.capabilities.IReasonerCapability;
import net.ssehub.easy.varModel.capabilities.IvmlReasonerCapabilities;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.Variable;
import net.ssehub.easy.varModel.cst.VariablePool;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.ContainableModelElementList;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.IvmlException;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.Container;
import net.ssehub.easy.varModel.model.datatypes.CustomDatatype;
import net.ssehub.easy.varModel.model.datatypes.IContainableElementsSorter;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;
import net.ssehub.easy.varModel.model.datatypes.IntegerType;
import net.ssehub.easy.varModel.model.datatypes.MetaType;
import net.ssehub.easy.varModel.model.datatypes.RealType;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.datatypes.Sequence;
import net.ssehub.easy.varModel.model.datatypes.Set;
import net.ssehub.easy.varModel.model.datatypes.StringType;
import net.ssehub.easy.varModel.model.datatypes.VersionType;
import net.ssehub.easy.varModel.model.values.NullValue;
import net.ssehub.easy.varModel.model.values.Value;
import net.ssehub.easy.varModel.model.values.ValueFactory;
import net.ssehub.easy.varModel.persistency.AbstractVarModelWriter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;

public class TypeContext
implements IResolutionScope {
    private ContainableModelElementList implicitDefinitions = new ContainableModelElementList(null);
    private Project project;
    private MessageReceiver messageReceiver;
    private VariablePool variablePool = new VariablePool();
    private Map<Compound, Self> selfPool = new HashMap<Compound, Self>();
    private Stack<ContainableModelElementList> directContext = new Stack();
    private ContainableElementsMapAndComparator sortMap = new ContainableElementsMapAndComparator();
    private Map<IContainableElementsSorter, ContainableElementsMapAndComparator> elementSortMaps = new HashMap<IContainableElementsSorter, ContainableElementsMapAndComparator>();
    private Map<String, List<Compound>> unresolvedCompoundRefinements = new HashMap<String, List<Compound>>();

    public TypeContext(Project project, MessageReceiver messageReceiver) {
        this.project = project;
        this.messageReceiver = messageReceiver;
    }

    public TypeContext(TypeContext context) {
        this.project = context.project;
        this.messageReceiver = context.messageReceiver;
    }

    public void pushLayer(IModelElement parent) {
        if (null == parent && !this.directContext.isEmpty()) {
            parent = this.directContext.peek().getParent();
        }
        this.directContext.push(new ContainableModelElementList(parent));
    }

    public int pushParent(DecisionVariableDeclaration decVar) {
        return this.pushParentRec((IModelElement)decVar);
    }

    private int pushParentRec(IModelElement elt) {
        int result = 0;
        if (null != elt && !(elt instanceof Project)) {
            result = this.pushParentRec(elt.getParent());
            if (elt instanceof Compound) {
                this.pushLayer(elt);
                this.addToContext((Compound)elt);
                ++result;
            }
        }
        return result;
    }

    public void popLayer(int count) {
        for (int i = 1; i <= count; ++i) {
            this.popLayer();
        }
    }

    public void popLayer() {
        this.directContext.pop();
    }

    public void addToContext(Compound comp) {
        this.addToContext(comp, new HashSet<Compound>());
    }

    private void addToContext(Compound comp, java.util.Set<Compound> done) {
        if (!done.contains(comp)) {
            done.add(comp);
            for (int r = 0; r < comp.getRefinesCount(); ++r) {
                this.addToContext(comp.getRefines(r), done);
            }
            int count = comp.getElementCount();
            for (int c = 0; c < count; ++c) {
                this.addToContext(comp.getElement(c));
            }
            for (int a = 0; a < comp.getAssignmentCount(); ++a) {
                this.addToContext(comp.getAssignment(a));
            }
        }
    }

    public void addToContext(AttributeAssignment assignment) {
        if (null != assignment) {
            int count = assignment.getElementCount();
            for (int c = 0; c < count; ++c) {
                this.addToContext(assignment.getElement(c));
            }
            for (int a = 0; a < assignment.getAssignmentCount(); ++a) {
                this.addToContext(assignment.getAssignment(a));
            }
        }
    }

    void addToContext(Compound compound, String unresolvedParentCompound) {
        List<Compound> uncompletedCompounds = this.unresolvedCompoundRefinements.get(unresolvedParentCompound);
        if (null == uncompletedCompounds) {
            uncompletedCompounds = new ArrayList<Compound>();
            this.unresolvedCompoundRefinements.put(unresolvedParentCompound, uncompletedCompounds);
        }
        uncompletedCompounds.add(compound);
    }

    List<Compound> getUnresolvedCompoundRefinments(String parentCompound) {
        return this.unresolvedCompoundRefinements.get(parentCompound);
    }

    void clearUnresolvedCompounds(String parentCompound) {
        this.unresolvedCompoundRefinements.remove(parentCompound);
    }

    public void addToContext(OperationDefinition opDef) {
        this.directContext.peek().add((Object)opDef);
    }

    public void addToContext(DecisionVariableDeclaration var) {
        String varName = var.getName();
        ContainableModelElementList lst = this.directContext.peek();
        int found = -1;
        for (int i = 0; found < 0 && i < lst.getElementCount(); ++i) {
            ContainableModelElement elt = lst.getElement(i);
            if (!elt.getName().equals(varName) || !(elt instanceof DecisionVariableDeclaration)) continue;
            found = i;
        }
        if (found >= 0) {
            lst.set(found, (Object)var);
        } else {
            lst.add((Object)var);
        }
    }

    public Project getProject() {
        return this.project;
    }

    public final Variable obtainVariable(AbstractVariable decl) {
        return this.variablePool.obtainVariable(decl);
    }

    public IDatatype resolveType(Type type) throws TranslatorException {
        IDatatype result = null;
        String typeName = "";
        EReference causingFeature = null;
        Class<IDatatype> restriction = null;
        if (null != type) {
            if (null != type.getType()) {
                typeName = type.getType().getType();
                restriction = IDatatype.class;
                causingFeature = IvmlPackage.Literals.TYPE__ID;
            } else if (null != type.getId()) {
                typeName = Utils.getQualifiedNameString(type.getId());
                restriction = IDatatype.class;
                causingFeature = IvmlPackage.Literals.TYPE__ID;
            } else if (null != type.getDerived()) {
                causingFeature = IvmlPackage.Literals.TYPE__TYPE;
                DerivedType derived = type.getDerived();
                typeName = ModelUtility.stringValue(derived.getType());
                if (derived.getOp().equals("setOf")) {
                    restriction = Container.class;
                } else if (derived.getOp().equals("sequenceOf")) {
                    restriction = Container.class;
                } else if (derived.getOp().equals("refTo")) {
                    restriction = Reference.class;
                } else {
                    throw new TranslatorException("<unspecified type>", (EObject)type, (EStructuralFeature)causingFeature, 20100);
                }
                try {
                    String searchName = ModelUtility.stringValue(derived, true);
                    result = ModelQuery.findElementByTypeName((IResolutionScope)this, (String)searchName, restriction);
                }
                catch (ModelQueryException e) {
                    throw new TranslatorException((IIdentifiable)e, (EObject)type, (EStructuralFeature)causingFeature);
                }
                if (null == result) {
                    IDatatype containedType = this.resolveType(derived.getType());
                    if (derived.getOp().equals("setOf")) {
                        result = this.addImplicitDefinition((CustomDatatype)new Set(typeName, containedType, (IModelElement)this.project));
                        restriction = Set.class;
                    } else if (derived.getOp().equals("sequenceOf")) {
                        result = this.addImplicitDefinition((CustomDatatype)new Sequence(typeName, containedType, (IModelElement)this.project));
                        restriction = Sequence.class;
                    } else if (derived.getOp().equals("refTo")) {
                        result = this.addImplicitDefinition((CustomDatatype)new Reference(typeName, containedType, (ModelElement)this.project));
                        restriction = Reference.class;
                    }
                }
            }
        }
        if (null != typeName && null == result) {
            try {
                result = this.findType(typeName, restriction);
            }
            catch (ModelQueryException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)type, (EStructuralFeature)causingFeature);
            }
            if (null == result) {
                throw new UnknownTypeException(typeName, type, (EStructuralFeature)causingFeature);
            }
        }
        return result;
    }

    public IDatatype findRefType(IDatatype contained) {
        String typeName2;
        IDatatype result = null;
        try {
            typeName2 = ModelQuery.getReferenceTypeSearchName((IDatatype)contained);
            result = ModelQuery.findElementByTypeName((IResolutionScope)this, (String)typeName2, Reference.class);
        }
        catch (ModelQueryException typeName2) {
            // empty catch block
        }
        if (null == result) {
            typeName2 = "refTo(" + IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)contained) + ")";
            result = this.addImplicitDefinition((CustomDatatype)new Reference(typeName2, contained, (ModelElement)this.project));
        }
        if (null == result) {
            result = Reference.TYPE;
        }
        return result;
    }

    public ContainableModelElement findElementByName(String name, Class<? extends ModelElement> type) throws ModelQueryException {
        ContainableModelElement result = null;
        for (int c = this.directContext.size() - 1; null == result && c >= 0; --c) {
            result = ModelQuery.findElementByName((IResolutionScope)((IResolutionScope)this.directContext.get(c)), (String)name, type);
        }
        if (null == result) {
            result = ModelQuery.findElementByName((IResolutionScope)this.project, (String)name, type);
        }
        return result;
    }

    public AbstractVariable findVariable(String name, Class<? extends AbstractVariable> type) throws ModelQueryException {
        ModelQueryException ex = null;
        AbstractVariable result = null;
        for (int c = this.directContext.size() - 1; null == result && c >= 0; --c) {
            try {
                result = ModelQuery.findVariable((IResolutionScope)((IResolutionScope)this.directContext.get(c)), (String)name, type);
                continue;
            }
            catch (ModelQueryException e) {
                ex = e;
            }
        }
        if (null == result && null != (result = ModelQuery.findVariable((IResolutionScope)this.project, (String)name, type)) && name.indexOf("::") < 0 && !(this.findActualParent((IModelElement)result) instanceof Project)) {
            result = null;
        }
        if (null == result && ex != null) {
            throw ex;
        }
        return result;
    }

    private IModelElement findActualParent(IModelElement elt) {
        IModelElement result;
        for (result = elt.getParent(); null != result && null != result.getParent() && !(result instanceof Project) && !(result instanceof Compound); result = result.getParent()) {
        }
        return result;
    }

    public IModelElement findVariableUse(String name) throws ModelQueryException {
        IModelElement result = null;
        for (int c = this.directContext.size() - 1; null == result && c >= 0; --c) {
            result = ModelQuery.findVariableUse((IResolutionScope)((IResolutionScope)this.directContext.get(c)), (String)name, null);
        }
        if (null == result) {
            result = ModelQuery.findVariableUse((IResolutionScope)this.project, (String)name, null);
        }
        return result;
    }

    public IDatatype findType(String name, Class<? extends IDatatype> type) throws ModelQueryException {
        IDatatype result = null;
        for (int c = this.directContext.size() - 1; null == result && c >= 0; --c) {
            result = ModelQuery.findType((IResolutionScope)((IResolutionScope)this.directContext.get(c)), (String)name, type);
        }
        if (null == result) {
            result = ModelQuery.findType((IResolutionScope)this.project, (String)name, type);
        }
        return result;
    }

    public Compound[] findCompounds(List<String> names, boolean nullOnFail) throws ModelQueryException {
        Compound[] result;
        if (null == names || names.isEmpty()) {
            result = null;
        } else {
            result = new Compound[names.size()];
            for (int n = 0; null != result && n < names.size(); ++n) {
                result[n] = (Compound)this.findType(names.get(n), Compound.class);
                if (!nullOnFail || null != result[n]) continue;
                result = null;
            }
        }
        return result;
    }

    public static boolean allResolved(IDatatype[] types) {
        boolean resolved;
        if (null != types) {
            resolved = true;
            for (int t = 0; resolved && t < types.length; ++t) {
                resolved = types[t] != null;
            }
        } else {
            resolved = false;
        }
        return resolved;
    }

    public ContainableModelElement getElement(int index) {
        return (ContainableModelElement)this.implicitDefinitions.get(index);
    }

    public int getElementCount() {
        return this.implicitDefinitions.size();
    }

    CustomDatatype addImplicitDefinition(CustomDatatype type) {
        this.implicitDefinitions.add((Object)type);
        return type;
    }

    public ConstraintSyntaxTree resolveValue(de.uni_hildesheim.sse.ivml.Value value, IModelElement parent, EObject object, EStructuralFeature feature) throws TranslatorException {
        ConstraintSyntaxTree result = null;
        if (null != value.getNValue()) {
            String sValue = value.getNValue().getVal();
            IDatatype type = sValue.indexOf(46) > 0 ? RealType.TYPE : IntegerType.TYPE;
            result = TypeContext.createConstantValue(object, feature, type, sValue);
        } else if (null != value.getQValue()) {
            String sValue = Utils.getQualifiedNameString(value.getQValue());
            result = Version.isVersion((String)sValue) ? this.createValueTree(sValue, VersionType.TYPE, object, feature) : this.processQValue(sValue, object, feature);
        } else if (null != value.getSValue()) {
            result = this.createValueTree(value.getSValue(), StringType.TYPE, object, feature);
        } else if (null != value.getBValue()) {
            result = this.createValueTree(value.getBValue(), BooleanType.TYPE, object, feature);
        } else if (null != value.getSelf()) {
            result = this.resolveSelf(parent, object, feature);
        } else if (null != value.getNullValue()) {
            result = new ConstantValue(NullValue.INSTANCE);
            if (!DefaultReasonerAccess.hasCapability((IReasonerCapability)IvmlReasonerCapabilities.NULL_VALUE)) {
                this.messageReceiver.warning("'null' values are currently not fully supported by the reasoner", object, feature, 0);
            }
        } else if (null != value.getVersion()) {
            result = this.createValueTree(value.getVersion(), VersionType.TYPE, object, feature);
        } else if (null != value.getTValue()) {
            IDatatype type = this.resolveType(value.getTValue());
            if (null != type) {
                result = TypeContext.createConstantValue(object, feature, MetaType.TYPE, type);
            }
        } else {
            throw new TranslatorException("<no type alternative>", object, feature, 20204);
        }
        return result;
    }

    private static ConstantValue createConstantValue(EObject object, EStructuralFeature feature, IDatatype type, Object ... values) throws TranslatorException {
        ConstantValue result = null;
        if (null != type) {
            try {
                result = new ConstantValue(ValueFactory.createValue((IDatatype)type, (Object[])values));
            }
            catch (IvmlException e) {
                throw new TranslatorException((IIdentifiable)e, object, feature);
            }
        }
        return result;
    }

    private ConstraintSyntaxTree resolveSelf(IModelElement parent, EObject object, EStructuralFeature feature) throws TranslatorException {
        Self result = null;
        if (parent instanceof Constraint) {
            if ((parent = parent.getParent()) instanceof Compound) {
                result = this.getSelf((Compound)parent);
            }
        } else if (parent instanceof Compound) {
            result = this.getSelf((Compound)parent);
        }
        if (null == result) {
            throw new TranslatorException("self is only defined in compounds", object, feature, 20207);
        }
        return result;
    }

    private Self getSelf(Compound comp) {
        Self self = this.selfPool.get(comp);
        if (null == self) {
            self = new Self(comp);
            this.selfPool.put(comp, self);
        }
        return self;
    }

    ConstraintSyntaxTree processQValue(String sValue, EObject object, EStructuralFeature feature) throws TranslatorException {
        Variable result = null;
        IvmlException varException = null;
        AbstractVariable var = null;
        try {
            var = this.findVariable(sValue, null);
        }
        catch (IvmlException e) {
            varException = e;
        }
        if (null == var) {
            try {
                Value litValue = ModelQuery.enumLiteralAsValue((IResolutionScope)this.project, (String)sValue);
                if (null != litValue) {
                    this.checkEnumOclCompliance(sValue, object, feature);
                    result = new ConstantValue(litValue);
                }
                IDatatype type = this.findType(sValue, null);
                if (null == type && sValue.equals(this.project.getName())) {
                    type = this.project.getType();
                }
                if (null != type) {
                    result = new ConstantValue(ValueFactory.createValue((IDatatype)MetaType.TYPE, (Object[])new Object[]{type}));
                }
                if (null != varException) {
                    throw new TranslatorException((IIdentifiable)varException, object, feature);
                }
                throw new TranslatorException("'" + sValue + "' is unknown", object, feature, 20207);
            }
            catch (IvmlException e) {
                throw new TranslatorException((IIdentifiable)e, object, feature);
            }
        } else {
            result = this.obtainVariable(var);
        }
        return result;
    }

    public void checkEnumOclCompliance(String qName, EObject object, EStructuralFeature feature) {
        if (AbstractVarModelWriter.considerOclCompliance() && qName.indexOf(46) > 0) {
            this.messageReceiver.warning("OCL compliance: Enum literal access shall be stated by '::' rather than '.'", object, feature, 20211);
        }
    }

    private ConstraintSyntaxTree createValueTree(String sValue, IDatatype type, EObject object, EStructuralFeature feature) throws TranslatorException {
        ConstantValue result = null;
        try {
            result = new ConstantValue(ValueFactory.createValue((IDatatype)type, (Object[])new Object[]{sValue}));
        }
        catch (IvmlException e) {
            throw new TranslatorException((IIdentifiable)e, object, feature);
        }
        return result;
    }

    public int getImportsCount() {
        return 0;
    }

    public ProjectImport getImport(int index) {
        throw new IndexOutOfBoundsException();
    }

    public IModelElement getParent() {
        return null;
    }

    public String getName() {
        return "";
    }

    public boolean hasInterfaces() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean addToProject(EObject key, Comment comment, ContainableModelElement element) {
        if (null != key) {
            this.sortMap.put(key, comment, element);
        }
        return this.project.add(element);
    }

    public void sortProjectElements(List<EObject> topLevelElements) {
        TypeContext.setIndexes(topLevelElements, this.sortMap);
        this.project.sortContainedElements((Comparator)this.sortMap);
    }

    private static void setIndexes(List<EObject> elements, ContainableElementsMapAndComparator map) {
        int size = elements.size();
        for (int e = 0; e < size; ++e) {
            EObject tmp = elements.get(e);
            if (tmp instanceof Typedef) {
                Typedef typedef = (Typedef)tmp;
                if (null != typedef.getTCompound()) {
                    tmp = typedef.getTCompound();
                } else if (null != typedef.getTEnum()) {
                    tmp = typedef.getTEnum();
                } else if (null != typedef.getTMapping()) {
                    tmp = typedef.getTMapping();
                }
            }
            map.setIndex(tmp, e);
        }
    }

    public void registerSorter(IContainableElementsSorter sorter, EObject key, Comment comment, ContainableModelElement element) {
        ContainableElementsMapAndComparator map = this.elementSortMaps.get(sorter);
        if (null == map) {
            map = new ContainableElementsMapAndComparator();
            this.elementSortMaps.put(sorter, map);
        }
        map.put(key, comment, element);
    }

    public void closeSorter(IContainableElementsSorter sorter, List<EObject> elements) {
        ContainableElementsMapAndComparator sortMap = this.elementSortMaps.get(sorter);
        if (null != sortMap) {
            TypeContext.setIndexes(elements, sortMap);
            sorter.sortContainedElements((Comparator)sortMap);
            sortMap.clear();
            this.elementSortMaps.remove(sorter);
        }
    }

    public void clear() {
        this.variablePool.clear();
        this.implicitDefinitions.clear();
        this.project = null;
        this.directContext.clear();
        this.sortMap.clear();
        for (ContainableElementsMapAndComparator c : this.elementSortMaps.values()) {
            c.clear();
        }
        this.elementSortMaps.clear();
    }

    public ContainableModelElement getElement(String name) {
        return this.project.getElement(name);
    }
}

