/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.translation;

import de.uni_hildesheim.sse.translation.TypeContext;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.StructuredComment;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.RuleCall;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

class CommentUtils {
    private static final String TOKEN_WHITESPACE = "WS";
    private static final String TOKEN_SL_COMMENT = "SL_COMMENT";
    private static final String TOKEN_ML_COMMENT = "ML_COMMENT";

    CommentUtils() {
    }

    static String commentsToString(EObject object) {
        ICompositeNode cnode = NodeModelUtils.getNode((EObject)object);
        String result = null;
        if (null != cnode) {
            StringBuilder commentBuilder = null;
            BidiTreeIterator iter = cnode.getAsTreeIterable().iterator();
            String lastType = null;
            while (iter.hasNext()) {
                INode cur = (INode)iter.next();
                EObject grammarElement = cur.getGrammarElement();
                if (grammarElement instanceof TerminalRule) {
                    TerminalRule terminal = (TerminalRule)grammarElement;
                    String name = terminal.getName();
                    boolean isWs = name.equals(TOKEN_WHITESPACE);
                    if (!isWs && !name.equals(TOKEN_SL_COMMENT) && !name.equals(TOKEN_ML_COMMENT)) continue;
                    if (!isWs) {
                        lastType = name;
                    }
                    if (null == commentBuilder) {
                        commentBuilder = new StringBuilder();
                    }
                    commentBuilder.append(cur.getText());
                    continue;
                }
                if (grammarElement instanceof RuleCall) continue;
                break;
            }
            if (null != commentBuilder) {
                int start;
                int size = commentBuilder.length();
                for (start = 0; start < size && Character.isWhitespace(commentBuilder.charAt(start)); ++start) {
                }
                if (start >= size) {
                    commentBuilder = null;
                }
            }
            if (null != commentBuilder) {
                int end;
                int start;
                for (start = 0; start < commentBuilder.length() && Character.isWhitespace(commentBuilder.charAt(start)) && !Character.isSpaceChar(commentBuilder.charAt(start)); ++start) {
                }
                if (TOKEN_SL_COMMENT.equals(lastType)) {
                    int lastNonWsChar = end;
                    boolean firstNonWsChar = true;
                    for (end = commentBuilder.length() - 1; end >= 0 && Character.isWhitespace(commentBuilder.charAt(end)); --end) {
                        if (Character.isSpaceChar(commentBuilder.charAt(end)) || !firstNonWsChar) continue;
                        lastNonWsChar = end;
                        firstNonWsChar = false;
                    }
                    if (lastNonWsChar < commentBuilder.length()) {
                        end = lastNonWsChar + 1;
                    }
                } else {
                    while (end >= 0 && Character.isSpaceChar(commentBuilder.charAt(end))) {
                        --end;
                    }
                }
                if (start > end) {
                    start = 0;
                    end = commentBuilder.length();
                }
                result = commentBuilder.substring(start, end);
            }
        }
        return result;
    }

    static Comment toComment(EObject object, IModelElement parent) {
        String comment = CommentUtils.commentsToString(object);
        Comment result = null == comment ? null : new Comment(comment, parent);
        return result;
    }

    static StructuredComment toStructuredComment(EObject object, ModelElement parent) {
        String comment = CommentUtils.commentsToString(object);
        StructuredComment result = null == comment ? null : new StructuredComment(comment, (IModelElement)parent);
        return result;
    }

    static StructuredComment ensureStructuredComment(EObject object, TypeContext context) {
        String comment = CommentUtils.commentsToString(object);
        StructuredComment result = null == comment ? new StructuredComment(null, (IModelElement)context.getProject()) : new StructuredComment(comment, (IModelElement)context.getProject());
        context.addToProject(null, null, (ContainableModelElement)result);
        return result;
    }

    static void println(String comment) {
        System.out.println(comment.replaceAll("\r", "\\\\r").replaceAll("\n", "\\\\n"));
    }
}

