/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.translation;

import de.uni_hildesheim.sse.ivml.AccessName;
import de.uni_hildesheim.sse.ivml.AnnotateTo;
import de.uni_hildesheim.sse.ivml.AttrAssignment;
import de.uni_hildesheim.sse.ivml.Eval;
import de.uni_hildesheim.sse.ivml.ExpressionStatement;
import de.uni_hildesheim.sse.ivml.Freeze;
import de.uni_hildesheim.sse.ivml.OpDefStatement;
import de.uni_hildesheim.sse.ivml.QualifiedName;
import de.uni_hildesheim.sse.ivml.Typedef;
import de.uni_hildesheim.sse.ivml.VariableDeclaration;
import de.uni_hildesheim.sse.ivml.VariableDeclarationPart;
import java.util.LinkedList;
import java.util.List;
import net.ssehub.easy.varModel.management.VarModel;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utils {
    private Utils() {
    }

    public static String getQualifiedNameString(QualifiedName name) {
        return Utils.getQualifiedNameString(name, null);
    }

    public static String getQualifiedNameString(QualifiedName name, AccessName aName) {
        StringBuilder result = new StringBuilder();
        for (String s : name.getQName()) {
            result.append(s);
        }
        if (null != aName) {
            for (String s : aName.getAName()) {
                result.append(s);
            }
        }
        return result.toString();
    }

    public static <T> List<T> select(List<EObject> list, Class<T> type) {
        LinkedList<T> result = new LinkedList<T>();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            EObject tmp = list.get(i);
            if (!type.isInstance(tmp)) continue;
            result.add(type.cast(tmp));
        }
        return result;
    }

    private static <T> List<T> assign(List<T> list, Object element, Class<T> type) {
        if (type.isInstance(element)) {
            if (null == list) {
                list = new LinkedList<T>();
            }
            list.add(type.cast(element));
        }
        return list;
    }

    public static SplitResult split(List<EObject> elements) {
        SplitResult result = new SplitResult();
        Utils.split(elements, result);
        return result;
    }

    public static void split(List<EObject> elements, SplitResult result) {
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            EObject tmp = elements.get(i);
            result.typedefs = Utils.assign(result.typedefs, tmp, Typedef.class);
            result.varDecls = Utils.assign(result.varDecls, tmp, VariableDeclaration.class);
            result.freezes = Utils.assign(result.freezes, tmp, Freeze.class);
            result.evals = Utils.assign(result.evals, tmp, Eval.class);
            result.exprs = Utils.assign(result.exprs, tmp, ExpressionStatement.class);
            result.attrs = Utils.assign(result.attrs, tmp, AnnotateTo.class);
            result.opdefs = Utils.assign(result.opdefs, tmp, OpDefStatement.class);
            result.attrAssignments = Utils.assign(result.attrAssignments, tmp, AttrAssignment.class);
        }
    }

    public static final boolean isImportResolutionEnabled() {
        return VarModel.INSTANCE.locations().getLocationCount() > 0;
    }

    public static String toString(VariableDeclaration varDecl) {
        String result = "";
        for (VariableDeclarationPart p : varDecl.getDecls()) {
            if (result.length() > 0) {
                result = result + ", ";
            }
            result = result + p.getName();
        }
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SplitResult {
        private List<Typedef> typedefs;
        private List<VariableDeclaration> varDecls;
        private List<Freeze> freezes;
        private List<Eval> evals;
        private List<ExpressionStatement> exprs;
        private List<AnnotateTo> attrs;
        private List<OpDefStatement> opdefs;
        private List<AttrAssignment> attrAssignments;

        public List<Typedef> getTypedefs() {
            return this.typedefs;
        }

        public List<VariableDeclaration> getVarDecls() {
            return this.varDecls;
        }

        public List<Freeze> getFreezes() {
            return this.freezes;
        }

        public List<Eval> getEvals() {
            return this.evals;
        }

        public List<ExpressionStatement> getExprs() {
            return this.exprs;
        }

        public List<AnnotateTo> getAttrs() {
            return this.attrs;
        }

        public List<OpDefStatement> getOpdefs() {
            return this.opdefs;
        }

        public List<AttrAssignment> getAttrAssignments() {
            return this.attrAssignments;
        }
    }
}

