/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.translation;

import de.uni_hildesheim.sse.ivml.AnnotateTo;
import de.uni_hildesheim.sse.ivml.AttrAssignment;
import de.uni_hildesheim.sse.ivml.AttrAssignmentPart;
import de.uni_hildesheim.sse.ivml.ConflictStmt;
import de.uni_hildesheim.sse.ivml.Eval;
import de.uni_hildesheim.sse.ivml.Export;
import de.uni_hildesheim.sse.ivml.Expression;
import de.uni_hildesheim.sse.ivml.ExpressionStatement;
import de.uni_hildesheim.sse.ivml.Freeze;
import de.uni_hildesheim.sse.ivml.FreezeStatement;
import de.uni_hildesheim.sse.ivml.ImportStmt;
import de.uni_hildesheim.sse.ivml.InterfaceDeclaration;
import de.uni_hildesheim.sse.ivml.IvmlPackage;
import de.uni_hildesheim.sse.ivml.OpDefParameter;
import de.uni_hildesheim.sse.ivml.OpDefStatement;
import de.uni_hildesheim.sse.ivml.QualifiedName;
import de.uni_hildesheim.sse.ivml.Typedef;
import de.uni_hildesheim.sse.ivml.TypedefCompound;
import de.uni_hildesheim.sse.ivml.TypedefEnum;
import de.uni_hildesheim.sse.ivml.TypedefEnumLiteral;
import de.uni_hildesheim.sse.ivml.TypedefMapping;
import de.uni_hildesheim.sse.ivml.VariabilityUnit;
import de.uni_hildesheim.sse.ivml.VariableDeclaration;
import de.uni_hildesheim.sse.ivml.VariableDeclarationPart;
import de.uni_hildesheim.sse.ivml.VersionStmt;
import de.uni_hildesheim.sse.translation.CommentUtils;
import de.uni_hildesheim.sse.translation.DerivedTypeMetaCompoundAccessVisitor;
import de.uni_hildesheim.sse.translation.ExpressionTranslator;
import de.uni_hildesheim.sse.translation.ImportTranslator;
import de.uni_hildesheim.sse.translation.ResultEntry;
import de.uni_hildesheim.sse.translation.TypeContext;
import de.uni_hildesheim.sse.translation.UnknownVariableException;
import de.uni_hildesheim.sse.translation.Utils;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.messages.IIdentifiable;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.modelManagement.AvailableModels;
import net.ssehub.easy.basics.modelManagement.IDeferredModelLoader;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelProcessingListener;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.dslCore.TranslationResult;
import net.ssehub.easy.dslCore.translation.MessageReceiver;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.AttributeAssignment;
import net.ssehub.easy.varModel.model.Comment;
import net.ssehub.easy.varModel.model.ConstantDecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.ContainableModelElement;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.EvaluationBlock;
import net.ssehub.easy.varModel.model.FreezeBlock;
import net.ssehub.easy.varModel.model.IAttributableElement;
import net.ssehub.easy.varModel.model.IDecisionVariableContainer;
import net.ssehub.easy.varModel.model.IFreezable;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IPartialEvaluable;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.IvmlException;
import net.ssehub.easy.varModel.model.ModelElement;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.ModelQueryException;
import net.ssehub.easy.varModel.model.OperationDefinition;
import net.ssehub.easy.varModel.model.PartialEvaluationBlock;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.ProjectInterface;
import net.ssehub.easy.varModel.model.StructuredComment;
import net.ssehub.easy.varModel.model.datatypes.AnyType;
import net.ssehub.easy.varModel.model.datatypes.BooleanType;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.ConstraintType;
import net.ssehub.easy.varModel.model.datatypes.CustomDynamicOperation;
import net.ssehub.easy.varModel.model.datatypes.CustomOperation;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.Enum;
import net.ssehub.easy.varModel.model.datatypes.EnumLiteral;
import net.ssehub.easy.varModel.model.datatypes.FreezeVariableType;
import net.ssehub.easy.varModel.model.datatypes.IContainableElementsSorter;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Operation;
import net.ssehub.easy.varModel.model.datatypes.OrderedEnum;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelTranslator
extends net.ssehub.easy.dslCore.translation.ModelTranslator<ExpressionTranslator> {
    private Map<TypedefCompound, Compound> compoundMapping = new HashMap<TypedefCompound, Compound>();
    private Map<AttrAssignment, AttributeAssignment> assignmentMapping = new HashMap<AttrAssignment, AttributeAssignment>();
    private Map<VariableDeclarationPart, DecisionVariableDeclaration> varMapping = new HashMap<VariableDeclarationPart, DecisionVariableDeclaration>();
    private Map<TypedefMapping, DerivedDatatype> typedefMapping = new HashMap<TypedefMapping, DerivedDatatype>();
    private Set<EObject> definitionsProcessed = new HashSet<EObject>();
    private DerivedTypeMetaCompoundAccessVisitor derivedTypeVisitor = new DerivedTypeMetaCompoundAccessVisitor((MessageReceiver)this);
    private IModelProcessingListener<Project> onLoadMsgCleanupListener = new IModelProcessingListener<Project>(){

        public void notifyProcessingStarted(ModelInfo<Project> info, IModelProcessingListener.Type type) {
            if (IModelProcessingListener.Type.LOADING == type) {
                ModelTranslator.this.expressionTranslator.clearMessages(info);
            }
        }

        public void notifyProcessingEnded(ModelInfo<Project> info, IModelProcessingListener.Type type) {
        }
    };
    private ExpressionTranslator expressionTranslator = (ExpressionTranslator)this.getExpressionTranslator();

    public ModelTranslator() {
        super((net.ssehub.easy.dslCore.translation.ExpressionTranslator)new ExpressionTranslator());
    }

    public Result createModel(VariabilityUnit unit, URI uri, boolean registerSuccessful, ImportResolver<Project> impResolver) {
        Result result = new Result(this);
        if (null != unit.getProjects()) {
            HashSet<String> names = new HashSet<String>();
            for (de.uni_hildesheim.sse.ivml.Project p : unit.getProjects()) {
                String name = p.getName();
                if (!names.contains(name)) {
                    result.add(this.createProject(p, uri, registerSuccessful, (List<de.uni_hildesheim.sse.ivml.Project>)unit.getProjects(), impResolver));
                    names.add(name);
                    continue;
                }
                this.error("project '" + name + "' occurs multiple times in the same file", p, (EStructuralFeature)IvmlPackage.Literals.PROJECT__NAME, 20210);
            }
        }
        return result;
    }

    public Result createEmptyResult() {
        return new Result(this);
    }

    private Comment handleBasicComment(EObject object, TypeContext context) {
        Comment comment = CommentUtils.toComment(object, (IModelElement)context.getProject());
        if (null != comment) {
            context.addToProject(null, null, (ContainableModelElement)comment);
        }
        return comment;
    }

    private void assignProjectComment(Project project, Object element, Comment comment) {
        StructuredComment sComment = project.getComments();
        if (null == sComment) {
            sComment = new StructuredComment(null, (IModelElement)project);
        }
        sComment.assignComment(element, comment);
    }

    private ResultEntry createProject(de.uni_hildesheim.sse.ivml.Project project, URI uri, boolean registerSuccessful, List<de.uni_hildesheim.sse.ivml.Project> inProgress, ImportResolver<Project> impResolver) {
        int errorCount = this.getErrorCount();
        Project result = new Project(project.getName());
        TypeContext context = new TypeContext(result, (MessageReceiver)this);
        result.setComments(CommentUtils.toStructuredComment(project, (ModelElement)result));
        if (null != project.getVersion()) {
            try {
                Version version = new Version(project.getVersion().getVersion());
                result.setVersion(version);
                this.assignProjectComment(result, version, CommentUtils.toComment(project.getVersion(), (IModelElement)result));
            }
            catch (VersionFormatException e) {
                this.error((IIdentifiable)e, project, (EStructuralFeature)IvmlPackage.Literals.PROJECT__VERSION);
            }
        }
        for (Object importStmt : project.getImports()) {
            this.processImport((ImportStmt)importStmt, context);
        }
        for (Object importStmt : project.getConflicts()) {
            this.processConflict((ConflictStmt)importStmt, context);
        }
        Utils.SplitResult splitRes = Utils.split(project.getContents().getElements());
        this.resolveImports(project, result, uri, inProgress, impResolver, false);
        this.processDefinitions(splitRes.getTypedefs(), splitRes.getVarDecls(), splitRes.getAttrAssignments(), context, false);
        this.resolveImports(project, result, uri, inProgress, impResolver, true);
        this.processDefinitions(splitRes.getTypedefs(), splitRes.getVarDecls(), splitRes.getAttrAssignments(), context, true);
        for (InterfaceDeclaration iface : project.getInterfaces()) {
            this.processInterface(iface, context);
        }
        this.checkCompounds(project, result);
        ResultEntry entry = new ResultEntry(project, result, context, splitRes);
        if (registerSuccessful) {
            entry.setRegistrationInfo(uri, errorCount);
        }
        return entry;
    }

    private void checkCompounds(de.uni_hildesheim.sse.ivml.Project eProject, Project project) {
        HashMap<String, DecisionVariableDeclaration> decls = new HashMap<String, DecisionVariableDeclaration>();
        HashMap<Compound, TypedefCompound> cmpMapping = new HashMap<Compound, TypedefCompound>();
        for (Map.Entry<TypedefCompound, Compound> e : this.compoundMapping.entrySet()) {
            cmpMapping.put(e.getValue(), e.getKey());
        }
        for (int e = 0; e < project.getElementCount(); ++e) {
            ContainableModelElement elt = project.getElement(e);
            if (elt instanceof Compound) {
                this.checkCompound(eProject, (Compound)elt, cmpMapping, decls);
            }
            decls.clear();
        }
    }

    private void checkCompound(de.uni_hildesheim.sse.ivml.Project eProject, Compound cmp, Map<Compound, TypedefCompound> cmpMapping, Map<String, DecisionVariableDeclaration> done) {
        for (int d = 0; d < cmp.getDeclarationCount(); ++d) {
            DecisionVariableDeclaration decl = cmp.getDeclaration(d);
            String name = decl.getName();
            DecisionVariableDeclaration known = done.get(name);
            if (null == known) {
                done.put(name, decl);
                continue;
            }
            if (decl.getType().isAssignableFrom(known.getType())) continue;
            TypedefCompound tdC = cmpMapping.get(known.getParent());
            EList<EObject> elts = tdC.getElements();
            Object cause = eProject;
            EAttribute feature = IvmlPackage.Literals.PROJECT__NAME;
            VariableDeclaration slot = null;
            for (int e = 0; null == slot && e < elts.size(); ++e) {
                EObject elt = (EObject)elts.get(e);
                if (!(elt instanceof VariableDeclaration)) continue;
                VariableDeclaration vd = (VariableDeclaration)elt;
                EList<VariableDeclarationPart> parts = vd.getDecls();
                for (int p = 0; null == slot && p < parts.size(); ++p) {
                    if (!name.equals(((VariableDeclarationPart)parts.get(p)).getName())) continue;
                    slot = vd;
                    cause = slot;
                    feature = IvmlPackage.Literals.VARIABLE_DECLARATION_PART__NAME;
                }
            }
            this.error("Slot '" + name + "' in compound '" + known.getParent().getName() + "' does not refine slot with same name in refining compound '" + cmp.getName() + "'", (EObject)cause, (EStructuralFeature)feature, 10203);
        }
        for (int r = 0; r < cmp.getRefinesCount(); ++r) {
            this.checkCompound(eProject, cmp.getRefines(r), cmpMapping, done);
        }
    }

    void completeLoading(ResultEntry entry) {
        Utils.SplitResult splitRes = entry.getSplitResult();
        TypeContext context = entry.getContext();
        if (null != splitRes.getAttrs()) {
            for (AnnotateTo annotation : splitRes.getAttrs()) {
                this.processAnnotation(annotation, context);
            }
        }
        if (null != splitRes.getOpdefs()) {
            this.processOpDefs(splitRes.getOpdefs(), context);
        }
        this.processExpressions(splitRes.getTypedefs(), splitRes.getAttrAssignments(), splitRes.getExprs(), context);
        if (null != splitRes.getEvals()) {
            for (Eval eval : splitRes.getEvals()) {
                this.processEval(eval, context, null);
            }
        }
        if (null != splitRes.getFreezes()) {
            for (Freeze freeze : splitRes.getFreezes()) {
                this.processFreeze(freeze, context);
            }
        }
        context.sortProjectElements((List<EObject>)entry.getEProject().getContents().getElements());
        context.clear();
        entry.registerIfNeeded(this.getErrorCount());
    }

    private void resolveImports(de.uni_hildesheim.sse.ivml.Project input, Project project, URI uri, List<de.uni_hildesheim.sse.ivml.Project> inProgress, ImportResolver<Project> impResolver, boolean transitiveLoading) {
        if (Utils.isImportResolutionEnabled()) {
            ArrayList infoInProgress = new ArrayList();
            AvailableModels available = VarModel.INSTANCE.availableModels();
            for (int p = 0; p < inProgress.size(); ++p) {
                de.uni_hildesheim.sse.ivml.Project pr = inProgress.get(p);
                VersionStmt versionStatement = pr.getVersion();
                String vString = null == versionStatement ? null : versionStatement.getVersion();
                try {
                    List info = available.getModelInfo(pr.getName(), vString);
                    if (null == info) continue;
                    infoInProgress.addAll(info);
                    continue;
                }
                catch (VersionFormatException e) {
                    this.error(e.getMessage(), input, (EStructuralFeature)IvmlPackage.Literals.PROJECT__IMPORTS, 20209);
                }
            }
            IModelProcessingListener oldListener = impResolver.setProcessingListener(this.onLoadMsgCleanupListener);
            List resolutionMessages = VarModel.INSTANCE.resolveImports((IModel)project, uri, infoInProgress, impResolver, transitiveLoading);
            impResolver.setProcessingListener(oldListener);
            for (int i = 0; i < resolutionMessages.size(); ++i) {
                this.collect((IMessage)resolutionMessages.get(i), input, (EStructuralFeature)IvmlPackage.Literals.PROJECT__IMPORTS, 20209);
            }
        }
    }

    public void processExpressionStatement(ExpressionStatement statement, TypeContext context, IDecisionVariableContainer parent, boolean internal) throws TranslatorException {
        if (null != statement.getExpr()) {
            IDecisionVariableContainer cParent = parent;
            if (null == cParent) {
                cParent = context.getProject();
            }
            try {
                Comment comment = CommentUtils.toComment(statement, (IModelElement)parent);
                Constraint constraint = new Constraint((IModelElement)cParent);
                constraint.setConsSyntax(this.expressionTranslator.processExpression(statement.getExpr(), context, (IModelElement)constraint));
                if (null != parent) {
                    parent.add(comment);
                    parent.addConstraint(constraint, internal);
                    context.registerSorter((IContainableElementsSorter)parent, statement, comment, (ContainableModelElement)constraint);
                } else {
                    if (null != comment) {
                        context.addToProject(null, null, (ContainableModelElement)comment);
                    }
                    context.addToProject(statement, comment, (ContainableModelElement)constraint);
                }
            }
            catch (IvmlException e) {
                this.error((IIdentifiable)e, statement, (EStructuralFeature)IvmlPackage.Literals.EXPRESSION_STATEMENT__EXPR);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpressions(List<Typedef> typedefs, List<AttrAssignment> assignments, List<ExpressionStatement> exprs, TypeContext context) {
        if (null != typedefs) {
            this.processTypeDefExpressions(typedefs, context);
        }
        this.compoundMapping.clear();
        if (null != assignments) {
            this.processAttributeAssignmentExpressions(assignments, context);
        }
        this.assignmentMapping.clear();
        for (Map.Entry<VariableDeclarationPart, DecisionVariableDeclaration> entry : this.varMapping.entrySet()) {
            DecisionVariableDeclaration decVar = entry.getValue();
            VariableDeclarationPart part = entry.getKey();
            try {
                int layers = context.pushParent(decVar);
                this.expressionTranslator.initLevel();
                ConstraintSyntaxTree dfltExpr = this.expressionTranslator.processExpression(decVar.getType(), part.getDefault(), context, decVar.getParent());
                IDatatype dfltExprType = dfltExpr.inferDatatype();
                String rhsError = null;
                if (Reference.TYPE.isAssignableFrom(decVar.getType()) && AnyType.TYPE == dfltExprType && !ConstantValue.isNull((ConstraintSyntaxTree)dfltExpr)) {
                    rhsError = "";
                }
                if (null != rhsError || !decVar.getType().isAssignableFrom(dfltExprType)) {
                    if (null == rhsError) {
                        rhsError = "of type '" + IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)dfltExprType) + "' ";
                    }
                    throw new TranslatorException("cannot assign the expression " + rhsError + "to a variable of type '" + IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)decVar.getType()) + "'", (EObject)part, (EStructuralFeature)IvmlPackage.Literals.VARIABLE_DECLARATION_PART__DEFAULT, 20203);
                }
                decVar.setValue(dfltExpr);
                if (!ConstraintType.TYPE.isAssignableFrom(decVar.getType())) {
                    this.expressionTranslator.errorAboutTopLevelWarning(part, (EStructuralFeature)IvmlPackage.Literals.VARIABLE_DECLARATION_PART__DEFAULT);
                }
                context.popLayer(layers);
            }
            catch (IvmlException e) {
                this.error((IIdentifiable)e, part, (EStructuralFeature)IvmlPackage.Literals.VARIABLE_DECLARATION_PART__DEFAULT);
            }
            catch (TranslatorException e) {
                this.error(e);
            }
        }
        this.varMapping.clear();
        for (Map.Entry<Object, Object> entry : this.typedefMapping.entrySet()) {
            TypedefMapping mapping = (TypedefMapping)entry.getKey();
            DerivedDatatype type = (DerivedDatatype)entry.getValue();
            context.pushLayer(null);
            try {
                context.addToContext(type.getTypeDeclaration());
                Expression expression = mapping.getConstraint().getExpressions();
                if (null == expression) continue;
                Constraint[] constraints = new Constraint[]{new Constraint((IModelElement)type)};
                ConstraintSyntaxTree cst = this.expressionTranslator.processExpression(expression, context, (IModelElement)constraints[0]);
                constraints[0].setConsSyntax(cst);
                this.derivedTypeVisitor.setContext(mapping, (EStructuralFeature)IvmlPackage.Literals.TYPEDEF_MAPPING__CONSTRAINT);
                cst.accept((IConstraintTreeVisitor)this.derivedTypeVisitor);
                this.derivedTypeVisitor.clear();
                type.setConstraints(constraints);
            }
            catch (IvmlException e) {
                this.error((IIdentifiable)e, mapping, (EStructuralFeature)IvmlPackage.Literals.TYPEDEF_MAPPING__CONSTRAINT);
            }
            catch (TranslatorException e) {
                this.error(e);
            }
            finally {
                context.popLayer();
            }
        }
        this.typedefMapping.clear();
        if (null != exprs) {
            for (ExpressionStatement expressionStatement : exprs) {
                try {
                    this.processExpressionStatement(expressionStatement, context, null, false);
                }
                catch (TranslatorException e) {
                    this.error(e);
                }
            }
        }
    }

    private void processTypeDefExpressions(List<Typedef> typedefs, TypeContext context) {
        for (Typedef typedef : typedefs) {
            Compound compound;
            TypedefCompound tCompound = typedef.getTCompound();
            if (null == tCompound || null == (compound = this.compoundMapping.get(typedef.getTCompound()))) continue;
            context.pushLayer((IModelElement)compound);
            context.addToContext(compound);
            Utils.SplitResult split = Utils.split(tCompound.getElements());
            if (null != split.getExprs()) {
                for (ExpressionStatement expression : split.getExprs()) {
                    try {
                        this.processExpressionStatement(expression, context, (IDecisionVariableContainer)compound, false);
                    }
                    catch (TranslatorException e) {
                        this.error(e);
                    }
                }
            }
            if (null != split.getAttrAssignments()) {
                this.processAttributeAssignmentExpressions(split.getAttrAssignments(), context);
            }
            if (null != split.getEvals()) {
                for (Eval eval : split.getEvals()) {
                    this.processEval(eval, context, compound);
                }
            }
            context.popLayer();
            context.closeSorter((IContainableElementsSorter)compound, (List<EObject>)tCompound.getElements());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processAttributeAssignmentExpressions(List<AttrAssignment> assignments, TypeContext context) {
        for (AttrAssignment assgn : assignments) {
            AttributeAssignment assignment = this.assignmentMapping.get(assgn);
            if (null == assignment) continue;
            context.pushLayer(null);
            context.addToContext(assignment);
            try {
                for (AttrAssignmentPart part : assgn.getParts()) {
                    this.expressionTranslator.initLevel();
                    ConstraintSyntaxTree valueEx = this.expressionTranslator.processLogicalExpression(part.getValue(), context, (IModelElement)assignment);
                    this.expressionTranslator.errorAboutTopLevelWarning(part, (EStructuralFeature)IvmlPackage.Literals.ATTR_ASSIGNMENT_PART__VALUE);
                    AttributeAssignment.Assignment data = new AttributeAssignment.Assignment(part.getName(), "=", valueEx);
                    assignment.add(data);
                    for (int e = 0; e < assignment.getElementCount(); ++e) {
                        try {
                            DecisionVariableDeclaration var = assignment.getElement(e);
                            String attributeName = var.getName() + "." + data.getName();
                            AbstractVariable attribute = context.findVariable(attributeName, null);
                            if (null == attribute || !(attribute instanceof Attribute)) {
                                throw new UnknownVariableException(attributeName, part, (EStructuralFeature)IvmlPackage.Literals.ATTR_ASSIGNMENT_PART__NAME);
                            }
                            OCLFeatureCall cst = new OCLFeatureCall((ConstraintSyntaxTree)context.obtainVariable(attribute), data.getOperation(), new ConstraintSyntaxTree[]{data.getExpression()});
                            Constraint constraint = new Constraint((IModelElement)assignment);
                            constraint.setConsSyntax((ConstraintSyntaxTree)cst);
                            assignment.addConstraint(constraint, true);
                            continue;
                        }
                        catch (ModelQueryException ex) {
                            this.error((IIdentifiable)ex, part, (EStructuralFeature)IvmlPackage.Literals.ATTR_ASSIGNMENT_PART__NAME);
                            continue;
                        }
                        catch (CSTSemanticException ex) {
                            this.error((IIdentifiable)ex, part, (EStructuralFeature)IvmlPackage.Literals.ATTR_ASSIGNMENT_PART__NAME);
                        }
                    }
                }
                Utils.SplitResult split = Utils.split(assgn.getElements());
                if (null != split.getExprs()) {
                    for (ExpressionStatement expression : split.getExprs()) {
                        try {
                            this.processExpressionStatement(expression, context, (IDecisionVariableContainer)assignment, false);
                        }
                        catch (TranslatorException e) {
                            this.error(e);
                        }
                    }
                }
                if (null == split.getAttrAssignments()) continue;
                this.processAttributeAssignmentExpressions(split.getAttrAssignments(), context);
            }
            catch (TranslatorException e) {
                this.error(e);
            }
            finally {
                context.popLayer();
                context.closeSorter((IContainableElementsSorter)assignment, (List<EObject>)assgn.getElements());
            }
        }
    }

    private void processDefinitions(List<Typedef> typedefs, List<VariableDeclaration> vardecls, List<AttrAssignment> assignments, TypeContext context, boolean force) {
        int assgnCount;
        int declsCount;
        int typesCount;
        LinkedList<Typedef> typesToDo = new LinkedList<Typedef>();
        if (null != typedefs) {
            for (Typedef typedef : typedefs) {
                if (null != typedef.getTEnum() && !this.definitionsProcessed.contains(typedef)) {
                    try {
                        this.processEnum(typedef.getTEnum(), context);
                        this.definitionsProcessed.add(typedef);
                    }
                    catch (TranslatorException e) {
                        if (!force) continue;
                        this.error(e);
                    }
                    continue;
                }
                if (null != typedef.getTMapping()) {
                    typesToDo.add(typedef);
                    continue;
                }
                if (null == typedef.getTCompound()) continue;
                typesToDo.add(typedef);
            }
        }
        LinkedList<VariableDeclaration> declsToDo = new LinkedList<VariableDeclaration>();
        if (null != vardecls) {
            declsToDo.addAll(vardecls);
        }
        LinkedList<AttrAssignment> assgnToDo = new LinkedList<AttrAssignment>();
        if (null != assignments) {
            assgnToDo.addAll(assignments);
        }
        do {
            typesCount = typesToDo.size();
            declsCount = declsToDo.size();
            assgnCount = assgnToDo.size();
            if (typesCount > 0) {
                this.processTypedefs(typesToDo, context, force);
            }
            if (declsCount > 0) {
                this.processVars(declsToDo, context, force);
            }
            if (assgnCount <= 0) continue;
            this.processAttributeAssignments(assgnToDo, context, force);
        } while ((typesCount != typesToDo.size() || declsCount != declsToDo.size() || assgnCount != assgnToDo.size()) && (typesCount > 0 || declsCount > 0));
        if (force) {
            if (typesCount > 0) {
                this.processTypedefs(typesToDo, context, true);
            }
            if (declsCount > 0) {
                this.processVars(declsToDo, context, true);
            }
            if (assgnCount > 0) {
                this.processAttributeAssignments(assgnToDo, context, true);
            }
        }
    }

    private void processOpDefs(List<OpDefStatement> opDefs, TypeContext context) {
        int opsCount;
        LinkedList<OpDefStatement> opsToDo = new LinkedList<OpDefStatement>();
        opsToDo.addAll(opDefs);
        do {
            if ((opsCount = opsToDo.size()) <= 0) continue;
            this.processOpDefs(opsToDo, context, false);
        } while (opsCount != opsToDo.size() && opsCount > 0);
        if (opsCount > 0) {
            this.processOpDefs(opsToDo, context, true);
        }
    }

    private void processOpDefs(List<OpDefStatement> opDefs, TypeContext context, boolean force) {
        Iterator<OpDefStatement> opIter = opDefs.iterator();
        while (opIter.hasNext()) {
            OpDefStatement opDef = opIter.next();
            try {
                boolean done = false;
                done = this.processOpdef(opDef, context, force);
                if (!done) continue;
                opIter.remove();
            }
            catch (TranslatorException e) {
                opIter.remove();
                this.error(e);
            }
        }
    }

    private void processTypedefs(List<Typedef> compounds, TypeContext context, boolean force) {
        Iterator<Typedef> tdIter = compounds.iterator();
        while (tdIter.hasNext()) {
            Typedef typedef = tdIter.next();
            if (this.definitionsProcessed.contains(typedef)) continue;
            try {
                boolean done = false;
                if (null != typedef.getTCompound()) {
                    done = this.processCompound(typedef.getTCompound(), context, force);
                }
                if (null != typedef.getTMapping()) {
                    done = this.processMapping(typedef.getTMapping(), context, force);
                }
                if (!done) continue;
                this.definitionsProcessed.add(typedef);
                tdIter.remove();
            }
            catch (TranslatorException e) {
                tdIter.remove();
                this.error(e);
            }
        }
    }

    private void processVars(List<VariableDeclaration> vars, TypeContext context, boolean force) {
        Iterator<VariableDeclaration> dIter = vars.iterator();
        while (dIter.hasNext()) {
            VariableDeclaration vDecl = dIter.next();
            if (this.definitionsProcessed.contains(vDecl)) continue;
            try {
                if (!this.processVariableDeclaration(vDecl, context, null, true, force)) continue;
                dIter.remove();
                this.definitionsProcessed.add(vDecl);
            }
            catch (TranslatorException e) {
                dIter.remove();
                this.error(e);
            }
        }
    }

    private void processAttributeAssignments(List<AttrAssignment> assignments, TypeContext context, boolean force) {
        Iterator<AttrAssignment> aIter = assignments.iterator();
        while (aIter.hasNext()) {
            AttrAssignment assgn = aIter.next();
            if (this.definitionsProcessed.contains(assgn)) continue;
            try {
                if (!this.processAttributeAssignment(assgn, context, null, true, force)) continue;
                this.definitionsProcessed.add(assgn);
                aIter.remove();
            }
            catch (TranslatorException e) {
                aIter.remove();
                this.error(e);
            }
        }
    }

    private String toString(List<VariableDeclarationPart> parts) {
        String result = "";
        for (int i = 0; i < parts.size(); ++i) {
            if (i > 0) {
                result = result + ",";
            }
            result = result + parts.get(i).getName();
        }
        return result;
    }

    private boolean processVariableDeclaration(VariableDeclaration decl, TypeContext context, IDecisionVariableContainer container, boolean process, boolean force) throws TranslatorException {
        IDatatype type;
        boolean ok = true;
        try {
            type = context.resolveType(decl.getType());
        }
        catch (TranslatorException e) {
            type = null;
            if (!force) {
                ok = false;
            }
            throw e;
        }
        if ((ok &= null != type) && process || force) {
            for (VariableDeclarationPart part : decl.getDecls()) {
                DecisionVariableDeclaration decVar;
                Object parent = null != container ? container : context.getProject();
                Comment comment = null;
                if (null == container) {
                    comment = this.handleBasicComment(decl, context);
                }
                this.expressionTranslator.warnDiscouragedNames(part.getName(), part, (EStructuralFeature)IvmlPackage.Literals.VARIABLE_DECLARATION_PART__NAME);
                if (null != decl.getConst()) {
                    if (null == part.getDefault()) {
                        throw new TranslatorException("constant '" + part.getName() + "' must be defined immediatley", (EObject)part, (EStructuralFeature)IvmlPackage.Literals.VARIABLE_DECLARATION__CONST, 20205);
                    }
                    decVar = new ConstantDecisionVariableDeclaration(part.getName(), type, (IModelElement)parent);
                } else {
                    decVar = new DecisionVariableDeclaration(part.getName(), type, (IModelElement)parent);
                }
                if (null != part.getDefault()) {
                    this.varMapping.put(part, decVar);
                }
                if (null != container) {
                    if (container.add(decVar)) continue;
                    this.alreadyDefinedError(part.getName(), part, (EStructuralFeature)IvmlPackage.Literals.VARIABLE_DECLARATION_PART__NAME);
                    continue;
                }
                if (context.addToProject(decl, comment, (ContainableModelElement)decVar)) continue;
                this.alreadyDefinedError(part.getName(), part, (EStructuralFeature)IvmlPackage.Literals.VARIABLE_DECLARATION_PART__NAME);
            }
        }
        return ok;
    }

    private void alreadyDefinedError(String name, EObject object, EStructuralFeature feature) throws TranslatorException {
        throw new TranslatorException("name '" + name + "' is already defined in the same scope", object, feature, 20205);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean processOpdef(OpDefStatement op, TypeContext context, boolean force) throws TranslatorException {
        boolean done;
        block18: {
            done = true;
            Project project = context.getProject();
            IDatatype resultType = context.resolveType(op.getResult());
            context.pushLayer(null);
            Comment comment = this.handleBasicComment(op, context);
            OperationDefinition opDef = new OperationDefinition((ModelElement)context.getProject());
            try {
                DecisionVariableDeclaration[] params;
                EList<OpDefParameter> eParamList = op.getParam().getList();
                if (null == eParamList || 0 == eParamList.size()) {
                    params = null;
                } else {
                    params = new DecisionVariableDeclaration[eParamList.size()];
                    for (int p = 0; p < params.length; ++p) {
                        OpDefParameter parameter = (OpDefParameter)eParamList.get(p);
                        IDatatype type = context.resolveType(parameter.getType());
                        params[p] = new DecisionVariableDeclaration(parameter.getId(), type, (IModelElement)opDef);
                        if (null != parameter.getVal()) {
                            try {
                                params[p].setValue(this.expressionTranslator.processExpression(parameter.getVal(), context, (IModelElement)opDef));
                                this.expressionTranslator.errorAboutTopLevelWarning(op, (EStructuralFeature)IvmlPackage.Literals.OP_DEF_PARAMETER__VAL);
                            }
                            catch (IvmlException e) {
                                throw new TranslatorException((IIdentifiable)e, (EObject)op, (EStructuralFeature)IvmlPackage.Literals.OP_DEF_PARAMETER__VAL);
                            }
                        }
                        context.addToContext(params[p]);
                    }
                    this.checkDefaultParamSequence(op, params);
                }
                IDatatype projectType = project.getType();
                Object operation = null != op.getStatic() ? new CustomOperation(resultType, op.getId(), projectType, null, params) : new CustomDynamicOperation(resultType, op.getId(), projectType, null, params);
                opDef.setOperation(operation);
                context.addToContext(opDef);
                project.add(opDef);
                ConstraintSyntaxTree impl = this.processOpDefImpl(op, context, (IModelElement)opDef);
                if (null == impl) break block18;
                try {
                    IDatatype implType = impl.inferDatatype();
                    if (!resultType.isAssignableFrom(implType)) {
                        throw new TranslatorException("implementation type '" + ModelTranslator.unqualified(implType) + "' does not match operation result type '" + ModelTranslator.unqualified(resultType) + "'", (EObject)op, (EStructuralFeature)IvmlPackage.Literals.OP_DEF_STATEMENT__IMPL, 20203);
                    }
                    operation.setFunction(impl);
                }
                catch (IvmlException e) {
                    throw new TranslatorException((IIdentifiable)e, (EObject)op, (EStructuralFeature)IvmlPackage.Literals.OP_DEF_STATEMENT__IMPL);
                }
                project.remove(opDef);
                if (this.findOperation(projectType, (Operation)operation, false)) {
                    throw new TranslatorException("operation '" + op.getId() + "' defined multiple times on project", (EObject)op, (EStructuralFeature)IvmlPackage.Literals.OP_DEF_PARAMETER__TYPE, 20205);
                }
                if (operation.getParameterCount() > 0 && this.findOperation(operation.getParameterType(0), (Operation)operation, true)) {
                    throw new TranslatorException("operation '" + op.getId() + "' is ambigously defined on type '" + IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)operation.getParameterType(0)) + '\"', (EObject)op, (EStructuralFeature)IvmlPackage.Literals.OP_DEF_PARAMETER__TYPE, 20206);
                }
                project.add(opDef);
                context.addToProject(op, comment, (ContainableModelElement)opDef);
            }
            catch (TranslatorException e) {
                project.remove(opDef);
                if (force) {
                    this.error(e);
                } else {
                    done = false;
                }
            }
            finally {
                context.popLayer();
            }
        }
        return done;
    }

    private static String unqualified(IDatatype type) {
        return IvmlDatatypeVisitor.getUnqualifiedType((IDatatype)type);
    }

    private void checkDefaultParamSequence(OpDefStatement op, DecisionVariableDeclaration[] param) {
        int lastNonDefaultParam = -1;
        int lastDefaultParam = -1;
        for (int p = 0; p < param.length; ++p) {
            if (null == param[p].getName()) {
                lastNonDefaultParam = p;
                continue;
            }
            if (lastDefaultParam >= 0) continue;
            lastDefaultParam = p;
        }
        if (param.length > 0 && lastDefaultParam > 0 && lastNonDefaultParam > lastDefaultParam) {
            this.error("parameters with default values must follow parameters without default values", op, (EStructuralFeature)IvmlPackage.Literals.ACTUAL_ARGUMENT_LIST__NAME, 20211);
        }
    }

    private ConstraintSyntaxTree processOpDefImpl(OpDefStatement op, TypeContext context, IModelElement parent) throws TranslatorException {
        ConstraintSyntaxTree impl = null;
        if (null != op.getImpl()) {
            impl = this.expressionTranslator.processExpression(op.getImpl(), context, parent);
        } else if (null != op.getBlock()) {
            impl = this.expressionTranslator.processBlockExpression(op.getBlock(), context, parent);
        }
        return impl;
    }

    protected void processInterface(InterfaceDeclaration eIface, TypeContext context) {
        if (null != eIface.getName()) {
            ArrayList<Comment> comments = new ArrayList<Comment>();
            ArrayList<DecisionVariableDeclaration> exports = new ArrayList<DecisionVariableDeclaration>();
            EList<Export> eExports = eIface.getExports();
            for (Export export : eExports) {
                comments.add(CommentUtils.toComment(export, null));
                for (QualifiedName qn : export.getNames()) {
                    String name = Utils.getQualifiedNameString(qn);
                    try {
                        DecisionVariableDeclaration variable = (DecisionVariableDeclaration)context.findVariable(name, DecisionVariableDeclaration.class);
                        if (null == variable) {
                            this.error("cannot resolve '" + name + "'", eIface, (EStructuralFeature)IvmlPackage.Literals.INTERFACE_DECLARATION__EXPORTS, 20207);
                        }
                        exports.add(variable);
                    }
                    catch (IvmlException e) {
                        this.error((IIdentifiable)e, eIface, (EStructuralFeature)IvmlPackage.Literals.INTERFACE_DECLARATION__EXPORTS);
                    }
                }
            }
            DecisionVariableDeclaration[] exp = new DecisionVariableDeclaration[exports.size()];
            exports.toArray(exp);
            StructuredComment sComment = this.createStructuredComment(eIface, context, comments);
            ProjectInterface iface = new ProjectInterface(eIface.getName(), exp, (ModelElement)context.getProject());
            if (null != sComment && exports.size() == eExports.size() && eExports.size() == comments.size()) {
                this.assignComments(sComment, exports, comments, (IModelElement)iface);
            }
            if (!context.addToProject(eIface, (Comment)sComment, (ContainableModelElement)iface)) {
                this.error("interface '" + iface.getName() + "' is defined multiple times in this project", eIface, (EStructuralFeature)IvmlPackage.Literals.INTERFACE_DECLARATION__NAME, 20205);
            }
        }
    }

    protected void processAnnotation(AnnotateTo annotation, TypeContext context) {
        if (null != annotation.getNames()) {
            Attribute initial = null;
            for (String name : annotation.getNames()) {
                if (null == name) continue;
                Attribute tmp = this.processAnnotation(annotation, name, context, initial);
                if (null != initial) continue;
                initial = tmp;
            }
        }
    }

    protected Attribute processAnnotation(AnnotateTo annotation, String name, TypeContext context, Attribute initial) {
        Attribute attr = null;
        DecisionVariableDeclaration elt = null;
        try {
            AbstractVariable var = context.findVariable(name, null);
            if (null == var) {
                if (context.getProject().getName().equals(name)) {
                    elt = context.getProject().getVariable();
                } else {
                    this.error("cannot find '" + name + '\"', annotation, (EStructuralFeature)IvmlPackage.Literals.ANNOTATE_TO__NAMES, 20207);
                }
            } else if (var instanceof Attribute) {
                this.error("cannot annotate annotations", annotation, (EStructuralFeature)IvmlPackage.Literals.ANNOTATE_TO__NAMES, 20208);
            } else {
                elt = (DecisionVariableDeclaration)var;
            }
        }
        catch (IvmlException e) {
            this.error((IIdentifiable)e, annotation, (EStructuralFeature)IvmlPackage.Literals.ANNOTATE_TO__NAMES);
        }
        if (null != elt) {
            try {
                IDatatype type = context.resolveType(annotation.getAnnotationType());
                VariableDeclarationPart vDecl = annotation.getAnnotationDecl();
                Comment comment = this.handleBasicComment(annotation, context);
                if (vDecl.getName().startsWith("e") || vDecl.getName().startsWith("v")) {
                    this.error("annotation name '" + vDecl.getName() + "' must not start with 'v' or 'e'" + elt.getName() + "'", annotation, (EStructuralFeature)IvmlPackage.Literals.ANNOTATE_TO__NAMES, 20208);
                }
                this.expressionTranslator.warnDiscouragedNames(vDecl.getName(), vDecl, (EStructuralFeature)IvmlPackage.Literals.VARIABLE_DECLARATION_PART__NAME);
                attr = new Attribute(vDecl.getName(), type, (IModelElement)context.getProject(), (IAttributableElement)elt);
                if (null != vDecl.getDefault()) {
                    try {
                        this.expressionTranslator.initLevel();
                        ConstraintSyntaxTree deflt = this.expressionTranslator.processExpression(type, vDecl.getDefault(), context, (IModelElement)context.getProject());
                        attr.setValue(deflt);
                    }
                    catch (IvmlException e) {
                        this.error((IIdentifiable)e, vDecl, (EStructuralFeature)IvmlPackage.Literals.VARIABLE_DECLARATION_PART__DEFAULT);
                    }
                }
                if (!elt.attribute(attr)) {
                    this.error("annotation '" + attr.getName() + "' is defined multiple times on '" + elt.getName() + "'", annotation, (EStructuralFeature)IvmlPackage.Literals.ANNOTATE_TO__NAMES, 20208);
                }
                context.addToProject(annotation, comment, (ContainableModelElement)attr);
                if (null != initial) {
                    initial.addSeries(attr);
                }
            }
            catch (TranslatorException e) {
                this.error(e);
            }
        }
        if (annotation.getSname().equals("attribute")) {
            this.warning("The keyword 'attribute' is deprecated. For future compatibility please use 'annotate' instead.", annotation, (EStructuralFeature)IvmlPackage.Literals.ANNOTATE_TO__SNAME, 20208);
        }
        return attr;
    }

    private boolean findOperation(IDatatype datatype, Operation operation, boolean considerOperand) {
        boolean found = false;
        for (int op = 0; !found && op < datatype.getOperationCount(); ++op) {
            Operation defOperation = datatype.getOperation(op);
            int defParamCount = defOperation.getParameterCount();
            if (considerOperand) {
                ++defParamCount;
            }
            if (!defOperation.getName().equals(operation.getName()) || defParamCount != operation.getParameterCount()) continue;
            boolean paramMatch = true;
            int defPInc = 0;
            if (considerOperand) {
                paramMatch = defOperation.getOperand().equals(operation.getParameterType(0));
                defPInc = 1;
            }
            for (int p = 0; paramMatch && p < defOperation.getParameterCount(); ++p) {
                paramMatch = defOperation.getParameterType(p + defPInc).equals(operation.getParameterType(p));
            }
            found = paramMatch;
        }
        return found;
    }

    private void processEnum(TypedefEnum tenum, TypeContext context) throws TranslatorException {
        int noOrdinals = 0;
        int allOrdinals = 0;
        int literalCount = tenum.getLiterals().size();
        Comment comment = this.handleBasicComment(tenum, context);
        for (TypedefEnumLiteral literal : tenum.getLiterals()) {
            if (null == literal.getValue()) {
                ++noOrdinals;
                continue;
            }
            ++allOrdinals;
        }
        if (noOrdinals != literalCount && allOrdinals != literalCount) {
            this.error("either all nor no enum values may have explicit ordinal values", tenum, (EStructuralFeature)IvmlPackage.Literals.TYPEDEF_ENUM__LITERALS, 20202);
        } else {
            Object iEnum = noOrdinals == literalCount ? new Enum(tenum.getName(), (ModelElement)context.getProject(), new String[0]) : new OrderedEnum(tenum.getName(), (ModelElement)context.getProject());
            for (int l = 0; l < literalCount; ++l) {
                TypedefEnumLiteral lit = (TypedefEnumLiteral)tenum.getLiterals().get(l);
                int pos = noOrdinals == literalCount ? l : Integer.parseInt(lit.getValue().getVal());
                if (iEnum.add(new EnumLiteral(lit.getName(), pos, (Enum)iEnum))) continue;
                this.error("enum value '" + lit.getName() + "' is defined twice", lit, (EStructuralFeature)IvmlPackage.Literals.TYPEDEF_ENUM_LITERAL__NAME, 20202);
            }
            if (!context.addToProject(tenum, comment, (ContainableModelElement)iEnum)) {
                throw new TranslatorException("duplicated type name '" + tenum.getName() + "'", (EObject)tenum, (EStructuralFeature)IvmlPackage.Literals.TYPEDEF_ENUM__NAME, 20210);
            }
        }
    }

    private boolean processCompound(TypedefCompound tcomp, TypeContext context, boolean force) throws TranslatorException {
        Compound[] superCompounds;
        boolean resolvable = true;
        EList<String> refines = tcomp.getSuper();
        if (null != refines) {
            try {
                superCompounds = context.findCompounds((List<String>)refines, true);
            }
            catch (ModelQueryException e) {
                throw new TranslatorException((IIdentifiable)e, (EObject)tcomp, (EStructuralFeature)IvmlPackage.Literals.TYPEDEF_COMPOUND__SUPER);
            }
            resolvable = force || TypeContext.allResolved((IDatatype[])superCompounds);
        } else {
            superCompounds = null;
        }
        Compound stored = this.compoundMapping.get(tcomp);
        if (null != stored && 0 == stored.getRefinesCount() && null != superCompounds) {
            stored.setRefines(superCompounds);
        }
        this.expressionTranslator.warnDiscouragedNames(tcomp.getName(), tcomp, (EStructuralFeature)IvmlPackage.Literals.TYPEDEF_COMPOUND__NAME);
        Compound compound = null != stored ? stored : new Compound(tcomp.getName(), (ModelElement)context.getProject(), tcomp.getAbstract() != null, superCompounds);
        Utils.SplitResult split = Utils.split(tcomp.getElements());
        if (!force) {
            resolvable &= this.variableDeclarationsResolvable(split.getVarDecls(), context, (IDecisionVariableContainer)compound, force);
            resolvable &= this.attributeAssignmentsResolvable(split.getAttrAssignments(), context, (IDecisionVariableContainer)compound, force);
        }
        if (null == stored) {
            this.compoundMapping.put(tcomp, compound);
            Comment comment = CommentUtils.toComment(tcomp, (IModelElement)context.getProject());
            context.addToProject(null, null, (ContainableModelElement)comment);
            context.addToProject(tcomp, comment, (ContainableModelElement)compound);
        }
        if (resolvable) {
            this.resolveAssignments(split.getAttrAssignments(), context, (IDecisionVariableContainer)compound, force);
            this.resolveDeclarations(split.getVarDecls(), context, (IDecisionVariableContainer)compound, force);
        }
        if (null != compound) {
            List<Compound> childs;
            if (null != refines && !refines.isEmpty() && null == superCompounds) {
                for (int r = 0; r < refines.size(); ++r) {
                    context.addToContext(compound, (String)refines.get(r));
                }
            }
            if (null != (childs = context.getUnresolvedCompoundRefinments(compound.getName()))) {
                for (int i = 0; i < childs.size(); ++i) {
                    Compound child = childs.get(i);
                    if (0 != child.getRefinesCount()) continue;
                    child.setRefines(new Compound[]{compound});
                }
            }
            context.clearUnresolvedCompounds(compound.getName());
            if (resolvable && null != refines && !refines.isEmpty() && null == superCompounds) {
                throw new TranslatorException("cannot resolve '" + tcomp.getSuper() + "'", (EObject)tcomp, (EStructuralFeature)IvmlPackage.Literals.TYPEDEF_COMPOUND__SUPER, 20207);
            }
        }
        return resolvable;
    }

    private boolean processAttributeAssignment(AttrAssignment assgn, TypeContext context, IDecisionVariableContainer parent, boolean process, boolean force) throws TranslatorException {
        boolean resolvable = true;
        Object mParent = null == parent ? context.getProject() : parent;
        AttributeAssignment assignment = new AttributeAssignment((IModelElement)mParent);
        Utils.SplitResult split = Utils.split(assgn.getElements());
        if (!force) {
            resolvable &= this.variableDeclarationsResolvable(split.getVarDecls(), context, (IDecisionVariableContainer)assignment, force);
            resolvable &= this.attributeAssignmentsResolvable(split.getAttrAssignments(), context, (IDecisionVariableContainer)assignment, force);
        }
        if (resolvable && (process || force)) {
            this.assignmentMapping.put(assgn, assignment);
            this.resolveAssignments(split.getAttrAssignments(), context, (IDecisionVariableContainer)assignment, force);
            this.resolveDeclarations(split.getVarDecls(), context, (IDecisionVariableContainer)assignment, force);
            Comment comment = CommentUtils.toComment(assgn, (IModelElement)mParent);
            if (null != parent) {
                parent.add(assignment);
            } else {
                context.addToProject(null, null, (ContainableModelElement)comment);
                context.addToProject(assgn, comment, (ContainableModelElement)assignment);
            }
        }
        return resolvable;
    }

    private boolean variableDeclarationsResolvable(List<VariableDeclaration> varDecls, TypeContext context, IDecisionVariableContainer parent, boolean force) throws TranslatorException {
        boolean resolvable = true;
        if (null != varDecls) {
            for (int v = 0; resolvable && v < varDecls.size(); resolvable &= this.processVariableDeclaration(varDecls.get(v), context, parent, false, force), ++v) {
            }
        }
        return resolvable;
    }

    private boolean attributeAssignmentsResolvable(List<AttrAssignment> attrAssignments, TypeContext context, IDecisionVariableContainer parent, boolean force) throws TranslatorException {
        boolean resolvable = true;
        if (null != attrAssignments) {
            for (int a = 0; resolvable && a < attrAssignments.size(); resolvable &= this.processAttributeAssignment(attrAssignments.get(a), context, parent, false, force), ++a) {
            }
        }
        return resolvable;
    }

    private void resolveDeclarations(List<VariableDeclaration> varDecls, TypeContext context, IDecisionVariableContainer parent, boolean force) throws TranslatorException {
        if (null != varDecls) {
            for (int v = 0; v < varDecls.size(); ++v) {
                VariableDeclaration vDecl = varDecls.get(v);
                Comment comment = CommentUtils.toComment(vDecl, (IModelElement)parent);
                parent.add(comment);
                this.processVariableDeclaration(vDecl, context, parent, true, force);
                context.registerSorter((IContainableElementsSorter)parent, vDecl, comment, (ContainableModelElement)parent.getElement(v));
            }
        }
    }

    private void resolveAssignments(List<AttrAssignment> attrAssignments, TypeContext context, IDecisionVariableContainer parent, boolean force) throws TranslatorException {
        if (null != attrAssignments) {
            for (int a = 0; a < attrAssignments.size(); ++a) {
                AttrAssignment nested = attrAssignments.get(a);
                Comment comment = CommentUtils.toComment(nested, (IModelElement)parent);
                parent.add(comment);
                this.processAttributeAssignment(nested, context, parent, true, force);
                context.registerSorter((IContainableElementsSorter)parent, nested, comment, (ContainableModelElement)parent.getAssignment(a));
            }
        }
    }

    private boolean processMapping(TypedefMapping tmapping, TypeContext context, boolean force) throws TranslatorException {
        IDatatype baseType;
        boolean resolvable = true;
        try {
            baseType = context.resolveType(tmapping.getType());
        }
        catch (TranslatorException e) {
            if (force) {
                throw e;
            }
            resolvable = false;
            baseType = null;
        }
        if (resolvable) {
            this.expressionTranslator.warnDiscouragedNames(tmapping.getNewType(), tmapping, (EStructuralFeature)IvmlPackage.Literals.TYPEDEF_MAPPING__NEW_TYPE);
            DerivedDatatype result = new DerivedDatatype(tmapping.getNewType(), baseType, (ModelElement)context.getProject());
            Comment comment = this.handleBasicComment(tmapping, context);
            if (null != tmapping.getConstraint()) {
                this.typedefMapping.put(tmapping, result);
            }
            if (!context.addToProject(tmapping, comment, (ContainableModelElement)result)) {
                throw new TranslatorException("duplicated type name '" + tmapping.getNewType() + "'", (EObject)tmapping, (EStructuralFeature)IvmlPackage.Literals.TYPEDEF_MAPPING__NEW_TYPE, 20210);
            }
        }
        return resolvable;
    }

    protected void processEval(Eval eval, TypeContext context, Compound compound) {
        EvalBlockResult result = this.processEval(eval, (IModelElement)context.getProject(), context);
        if (null != compound) {
            if (null != result.comment) {
                compound.add((Comment)result.comment);
            }
            compound.add((EvaluationBlock)result.block);
        } else {
            context.addToProject(eval, (Comment)result.comment, (ContainableModelElement)result.block);
        }
    }

    private EvalBlockResult processEval(Eval eval, IModelElement parent, TypeContext context) {
        EvalBlockResult result = new EvalBlockResult();
        result.block = new PartialEvaluationBlock("", parent);
        ArrayList<Comment> comments = new ArrayList<Comment>();
        if (null != eval.getNested()) {
            EList<Eval> evals = eval.getNested();
            PartialEvaluationBlock[] nested = new PartialEvaluationBlock[evals.size()];
            for (int n = 0; n < evals.size(); ++n) {
                EvalBlockResult nResult = this.processEval((Eval)evals.get(n), (IModelElement)result.block, context);
                result.block.addModelElement((ContainableModelElement)nResult.comment);
                result.block.addModelElement((ContainableModelElement)nResult.block);
                nested[n] = nResult.block;
            }
            result.block.setNested(nested);
        }
        ArrayList<Constraint> constraints = new ArrayList<Constraint>();
        for (ExpressionStatement stmt : eval.getStatements()) {
            comments.add(CommentUtils.toComment(stmt, null));
            try {
                Constraint constraint = new Constraint((IModelElement)result.block);
                constraint.setConsSyntax(this.expressionTranslator.processExpression(stmt.getExpr(), context, (IModelElement)constraint));
                constraints.add(constraint);
                result.block.addModelElement((ContainableModelElement)constraint);
            }
            catch (TranslatorException e) {
                this.error(e);
            }
            catch (IvmlException e) {
                this.error((IIdentifiable)e, eval, (EStructuralFeature)IvmlPackage.Literals.EVAL__STATEMENTS);
            }
        }
        result.comment = this.createStructuredComment(eval, context, comments);
        IPartialEvaluable[] constr = new IPartialEvaluable[constraints.size()];
        result.block.setEvaluables(constraints.toArray(constr));
        EList<ExpressionStatement> stmts = eval.getStatements();
        if (null != result.comment && constraints.size() == stmts.size() && stmts.size() == comments.size()) {
            this.assignComments(result.comment, constraints, comments, (IModelElement)result.block);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processFreeze(Freeze freeze, TypeContext context) {
        ArrayList<IFreezable> freezes = new ArrayList<IFreezable>();
        ArrayList<Comment> comments = new ArrayList<Comment>();
        for (FreezeStatement stmt : freeze.getNames()) {
            comments.add(CommentUtils.toComment(stmt, null));
            String name = Utils.getQualifiedNameString(stmt.getName(), stmt.getAccess());
            try {
                IModelElement elt = context.findVariableUse(name);
                if (null == elt) {
                    elt = ModelQuery.findProject((Project)context.getProject(), (String)name);
                }
                if (null == elt) {
                    this.error(name + "' is undefined", freeze, (EStructuralFeature)IvmlPackage.Literals.FREEZE__NAMES, 20207);
                    continue;
                }
                if (elt instanceof IFreezable) {
                    freezes.add((IFreezable)elt);
                    continue;
                }
                if (elt instanceof IDatatype) {
                    this.error("Cannot freeze type declaration '" + name + "'", freeze, (EStructuralFeature)IvmlPackage.Literals.FREEZE__NAMES, 20210);
                    continue;
                }
                this.error("'" + name + "' cannot be frozen", freeze, (EStructuralFeature)IvmlPackage.Literals.FREEZE__NAMES, 20207);
            }
            catch (IvmlException e) {
                this.error((IIdentifiable)e, freeze, (EStructuralFeature)IvmlPackage.Literals.FREEZE__NAMES);
            }
        }
        IFreezable[] aFreeze = new IFreezable[freezes.size()];
        freezes.toArray(aFreeze);
        DecisionVariableDeclaration var = null;
        ConstraintSyntaxTree selector = null;
        Project parent = context.getProject();
        if (null != freeze.getId()) {
            FreezeVariableType type = new FreezeVariableType(aFreeze, (IModelElement)parent);
            var = new DecisionVariableDeclaration(freeze.getId(), (IDatatype)type, (IModelElement)parent);
            TypeContext local = new TypeContext(context);
            local.pushLayer((IModelElement)parent);
            local.addToContext(var);
            try {
                selector = ((ExpressionTranslator)this.getExpressionTranslator()).processLogicalExpression(freeze.getEx(), local, (IModelElement)parent);
                if (!BooleanType.TYPE.isAssignableFrom(selector.inferDatatype())) {
                    this.error("selector expression must be of type Boolean", freeze, (EStructuralFeature)IvmlPackage.Literals.FREEZE__EX, 20203);
                }
            }
            catch (CSTSemanticException e) {
                this.error(e.getMessage(), freeze, (EStructuralFeature)IvmlPackage.Literals.FREEZE__EX, 20203);
            }
            catch (TranslatorException e) {
                this.error(e);
            }
            finally {
                local.popLayer();
            }
        }
        StructuredComment sComment = this.createStructuredComment(freeze, context, comments);
        FreezeBlock block = new FreezeBlock(aFreeze, var, selector, (IModelElement)parent);
        EList<FreezeStatement> stmts = freeze.getNames();
        if (null != sComment && freezes.size() == stmts.size() && stmts.size() == comments.size()) {
            this.assignComments(sComment, freezes, comments, (IModelElement)block);
        }
        context.addToProject(freeze, (Comment)sComment, (ContainableModelElement)block);
    }

    private StructuredComment createStructuredComment(EObject object, TypeContext context, List<Comment> comments) {
        StructuredComment comment = comments.isEmpty() ? null : CommentUtils.ensureStructuredComment(object, context);
        return comment;
    }

    private void assignComments(StructuredComment target, List<?> elements, List<Comment> comments, IModelElement parent) {
        assert (comments.size() == elements.size());
        for (int i = 0; i < comments.size(); ++i) {
            Comment comment = comments.get(i);
            if (null == comment) continue;
            comment.setParent(parent);
            target.assignComment(elements.get(i), comment);
        }
    }

    protected void processImport(ImportStmt importStmt, TypeContext context) {
        try {
            ProjectImport imp = ImportTranslator.processImport(importStmt, this.expressionTranslator, context);
            Project project = context.getProject();
            this.assignProjectComment(project, imp, CommentUtils.toComment(importStmt, (IModelElement)project));
            if (!context.getProject().addImport(imp)) {
                this.error("project '" + imp.getProjectName() + "' is already imported", importStmt, (EStructuralFeature)IvmlPackage.Literals.IMPORT_STMT__NAME, 20209);
            }
        }
        catch (TranslatorException e) {
            this.error(e);
        }
    }

    protected void processConflict(ConflictStmt conflictStmt, TypeContext context) {
        try {
            context.getProject().addImport(ImportTranslator.processConflict(conflictStmt, this.expressionTranslator, context));
        }
        catch (TranslatorException e) {
            this.error(e);
        }
    }

    void error(IIdentifiable exception, EObject cause, EStructuralFeature causeFeature) {
        this.expressionTranslator.error(exception, cause, causeFeature);
    }

    void warning(IvmlException exception, EObject cause, EStructuralFeature causeFeature) {
        this.expressionTranslator.warning(exception, cause, causeFeature);
    }

    private class EvalBlockResult {
        private PartialEvaluationBlock block;
        private StructuredComment comment;

        private EvalBlockResult() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Result
    implements IDeferredModelLoader<Project> {
        private List<ResultEntry> entries = new ArrayList<ResultEntry>();
        private ModelTranslator translator;

        private Result(ModelTranslator translator) {
            this.translator = translator;
        }

        private void add(ResultEntry entry) {
            this.entries.add(entry);
        }

        public void completeLoading() {
            for (int e = 0; e < this.entries.size(); ++e) {
                this.entries.get(e).completeLoading(this);
            }
        }

        public TranslationResult<Project> createTranslationResult() {
            ArrayList<Project> projects = new ArrayList<Project>();
            for (int e = 0; e < this.entries.size(); ++e) {
                projects.add(this.entries.get(e).getProject());
            }
            return new TranslationResult(projects, (MessageReceiver)this.translator);
        }

        ModelTranslator getTranslator() {
            return this.translator;
        }
    }
}

