/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.translation;

import de.uni_hildesheim.sse.ivml.ConflictStmt;
import de.uni_hildesheim.sse.ivml.Expression;
import de.uni_hildesheim.sse.ivml.ImportStmt;
import de.uni_hildesheim.sse.ivml.IvmlPackage;
import de.uni_hildesheim.sse.translation.ExpressionTranslator;
import de.uni_hildesheim.sse.translation.TypeContext;
import de.uni_hildesheim.sse.translation.Utils;
import net.ssehub.easy.basics.messages.IMessageHandler;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.dslCore.translation.MessageHandler;
import net.ssehub.easy.dslCore.translation.MessageReceiver;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.DecisionVariableDeclaration;
import net.ssehub.easy.varModel.model.ExpressionVersionRestriction;
import net.ssehub.easy.varModel.model.ExpressionVersionRestrictionValidator;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.ProjectImport;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class ImportTranslator {
    private static IVersionRestriction processRestrictionExpression(String name, Expression expr, ExpressionTranslator translator, TypeContext context, IMessageHandler handler) throws TranslatorException, RestrictionEvaluationException {
        ExpressionVersionRestriction result;
        if (null == expr || null == translator || null == context) {
            result = null;
        } else {
            context.pushLayer(null);
            DecisionVariableDeclaration[] vars = ExpressionVersionRestriction.createRestrictionVars((String)name);
            context.addToContext(vars[0]);
            context.addToContext(vars[1]);
            ConstraintSyntaxTree tmp = translator.processExpression(expr, context, (IModelElement)context.getProject());
            context.popLayer();
            ExpressionVersionRestrictionValidator validator = new ExpressionVersionRestrictionValidator(handler);
            tmp.accept((IConstraintTreeVisitor)validator);
            result = new ExpressionVersionRestriction(tmp, vars[0], vars[1]);
        }
        return result;
    }

    public static ProjectImport processConflict(ConflictStmt conflictStmt) throws TranslatorException {
        return ImportTranslator.processConflict(conflictStmt, null, null);
    }

    public static ProjectImport processConflict(ConflictStmt conflictStmt, ExpressionTranslator translator, TypeContext context) throws TranslatorException {
        String name = conflictStmt.getName();
        try {
            IVersionRestriction restriction = ImportTranslator.processRestrictionExpression(name, conflictStmt.getRestriction(), translator, context, (IMessageHandler)new MessageHandler((MessageReceiver)translator, (EObject)conflictStmt, (EStructuralFeature)IvmlPackage.Literals.CONFLICT_STMT__RESTRICTION));
            if (!VarModel.INSTANCE.availableModels().hasModelInfo(name) && Utils.isImportResolutionEnabled()) {
                throw new TranslatorException("project '" + name + "' cannot be resolved", (EObject)conflictStmt, (EStructuralFeature)IvmlPackage.Literals.CONFLICT_STMT__NAME, 20209);
            }
            return new ProjectImport(name, null, true, false, restriction);
        }
        catch (RestrictionEvaluationException e) {
            throw new TranslatorException(e.getMessage(), (EObject)conflictStmt, (EStructuralFeature)IvmlPackage.Literals.CONFLICT_STMT__RESTRICTION, e.getId());
        }
    }

    public static ProjectImport processImport(ImportStmt importStmt) throws TranslatorException {
        return ImportTranslator.processImport(importStmt, null, null);
    }

    public static ProjectImport processImport(ImportStmt importStmt, ExpressionTranslator translator, TypeContext context) throws TranslatorException {
        try {
            IVersionRestriction restriction = ImportTranslator.processRestrictionExpression(importStmt.getName(), importStmt.getRestriction(), translator, context, (IMessageHandler)new MessageHandler((MessageReceiver)translator, (EObject)importStmt, (EStructuralFeature)IvmlPackage.Literals.IMPORT_STMT__RESTRICTION));
            return new ProjectImport(importStmt.getName(), importStmt.getInterface(), false, false, restriction);
        }
        catch (RestrictionEvaluationException e) {
            throw new TranslatorException(e.getMessage(), (EObject)importStmt, (EStructuralFeature)IvmlPackage.Literals.IMPORT_STMT__RESTRICTION, e.getId());
        }
    }
}

