/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse.translation;

import net.ssehub.easy.varModel.cst.AttributeVariable;
import net.ssehub.easy.varModel.cst.BlockExpression;
import net.ssehub.easy.varModel.cst.CSTUtils;
import net.ssehub.easy.varModel.cst.Comment;
import net.ssehub.easy.varModel.cst.CompoundAccess;
import net.ssehub.easy.varModel.cst.CompoundInitializer;
import net.ssehub.easy.varModel.cst.ConstantValue;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.cst.ContainerInitializer;
import net.ssehub.easy.varModel.cst.ContainerOperationCall;
import net.ssehub.easy.varModel.cst.IConstraintTreeVisitor;
import net.ssehub.easy.varModel.cst.IfThen;
import net.ssehub.easy.varModel.cst.Let;
import net.ssehub.easy.varModel.cst.MultiAndExpression;
import net.ssehub.easy.varModel.cst.OCLFeatureCall;
import net.ssehub.easy.varModel.cst.Parenthesis;
import net.ssehub.easy.varModel.cst.Self;
import net.ssehub.easy.varModel.cst.UnresolvedExpression;
import net.ssehub.easy.varModel.cst.Variable;

public class AssignmentDetector
implements IConstraintTreeVisitor {
    public static final int LEVEL_UNLIMITED = -1;
    public static final int NO_DEEP_TRAVERSAL = 0;
    private boolean isAssignment;
    private int maxLevel;
    private int level;

    public void setMaxLevel(int level) {
        this.maxLevel = Math.max(-1, level);
    }

    public boolean isAssignment() {
        return this.isAssignment;
    }

    public void clear() {
        this.isAssignment = false;
        this.maxLevel = -1;
        this.level = 0;
    }

    public void visitConstantValue(ConstantValue value) {
    }

    public void visitVariable(Variable variable) {
    }

    public void visitAnnotationVariable(AttributeVariable variable) {
        this.visitVariable((Variable)variable);
    }

    private boolean continueTraversal() {
        return !this.isAssignment && (this.maxLevel < 0 || this.level <= this.maxLevel);
    }

    public void visitParenthesis(Parenthesis parenthesis) {
        if (this.continueTraversal()) {
            ++this.level;
            parenthesis.getExpr().accept((IConstraintTreeVisitor)this);
            --this.level;
        }
    }

    public void visitComment(Comment comment) {
    }

    public void visitOclFeatureCall(OCLFeatureCall call) {
        this.isAssignment = CSTUtils.isAssignment((ConstraintSyntaxTree)call);
        if (this.continueTraversal()) {
            ++this.level;
            if (null != call.getOperand()) {
                call.getOperand().accept((IConstraintTreeVisitor)this);
                for (int p = 0; !this.isAssignment && p < call.getParameterCount(); ++p) {
                    call.getParameter(p).accept((IConstraintTreeVisitor)this);
                }
            }
            --this.level;
        }
    }

    public void visitMultiAndExpression(MultiAndExpression expression) {
        ++this.level;
        for (int e = 0; e < expression.getExpressionCount(); ++e) {
            expression.getExpression(e).accept((IConstraintTreeVisitor)this);
        }
        --this.level;
    }

    public void visitLet(Let let) {
        if (this.continueTraversal()) {
            ++this.level;
            let.getInExpression().accept((IConstraintTreeVisitor)this);
            --this.level;
        }
    }

    public void visitIfThen(IfThen ifThen) {
        if (this.continueTraversal()) {
            ++this.level;
            ifThen.getIfExpr().accept((IConstraintTreeVisitor)this);
            if (!this.isAssignment) {
                ifThen.getThenExpr().accept((IConstraintTreeVisitor)this);
            }
            if (!this.isAssignment && null != ifThen.getElseExpr()) {
                ifThen.getElseExpr().accept((IConstraintTreeVisitor)this);
            }
            --this.level;
        }
    }

    public void visitContainerOperationCall(ContainerOperationCall call) {
        if (this.continueTraversal()) {
            ++this.level;
            call.getContainer().accept((IConstraintTreeVisitor)this);
            --this.level;
        }
    }

    public void visitCompoundAccess(CompoundAccess access) {
        if (this.continueTraversal()) {
            ++this.level;
            access.getCompoundExpression().accept((IConstraintTreeVisitor)this);
            --this.level;
        }
    }

    public void visitUnresolvedExpression(UnresolvedExpression expression) {
    }

    public void visitCompoundInitializer(CompoundInitializer initializer) {
        if (this.continueTraversal()) {
            ++this.level;
            for (int e = 0; !this.isAssignment && e < initializer.getExpressionCount(); ++e) {
                initializer.getExpression(e).accept((IConstraintTreeVisitor)this);
            }
            --this.level;
        }
    }

    public void visitContainerInitializer(ContainerInitializer initializer) {
        if (this.continueTraversal()) {
            ++this.level;
            for (int e = 0; !this.isAssignment && e < initializer.getExpressionCount(); ++e) {
                initializer.getExpression(e).accept((IConstraintTreeVisitor)this);
            }
            --this.level;
        }
    }

    public void visitSelf(Self self) {
    }

    public void visitBlockExpression(BlockExpression block) {
        int n = block.getExpressionCount();
        for (int e = 0; e < n; ++e) {
            block.getExpression(e).accept((IConstraintTreeVisitor)this);
        }
    }
}

