/*
 * Decompiled with CFR 0.152.
 */
package de.uni_hildesheim.sse;

import com.google.inject.Guice;
import com.google.inject.Module;
import de.uni_hildesheim.sse.ConstraintSyntaxException;
import de.uni_hildesheim.sse.IvmlRuntimeModule;
import de.uni_hildesheim.sse.IvmlStandaloneSetup;
import de.uni_hildesheim.sse.ivml.ConflictStmt;
import de.uni_hildesheim.sse.ivml.DerivedType;
import de.uni_hildesheim.sse.ivml.Expression;
import de.uni_hildesheim.sse.ivml.ExpressionStatement;
import de.uni_hildesheim.sse.ivml.Project;
import de.uni_hildesheim.sse.ivml.Type;
import de.uni_hildesheim.sse.ivml.VariabilityUnit;
import de.uni_hildesheim.sse.ivml.VersionStmt;
import de.uni_hildesheim.sse.translation.ExpressionTranslator;
import de.uni_hildesheim.sse.translation.ImportTranslator;
import de.uni_hildesheim.sse.translation.ModelTranslator;
import de.uni_hildesheim.sse.translation.TypeContext;
import de.uni_hildesheim.sse.translation.Utils;
import java.io.IOException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.basics.modelManagement.IDeferredModelLoader;
import net.ssehub.easy.basics.modelManagement.IModelLoader;
import net.ssehub.easy.basics.modelManagement.ImportResolver;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.dslCore.TranslationResult;
import net.ssehub.easy.dslCore.translation.Message;
import net.ssehub.easy.dslCore.translation.MessageReceiver;
import net.ssehub.easy.dslCore.translation.TranslatorException;
import net.ssehub.easy.varModel.cst.CSTSemanticException;
import net.ssehub.easy.varModel.cst.ConstraintSyntaxTree;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.AbstractVariable;
import net.ssehub.easy.varModel.model.Constraint;
import net.ssehub.easy.varModel.model.IModelElement;
import net.ssehub.easy.varModel.model.IModelVisitor;
import net.ssehub.easy.varModel.model.ProjectImport;
import net.ssehub.easy.varModel.model.datatypes.Compound;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.persistency.ConfigurableIVMLWriter;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parser.IParseResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelUtility
extends net.ssehub.easy.dslCore.ModelUtility<VariabilityUnit, net.ssehub.easy.varModel.model.Project>
implements IModelLoader<net.ssehub.easy.varModel.model.Project> {
    public static final ModelUtility INSTANCE = new ModelUtility();

    private ModelUtility() {
    }

    protected void initializeAfterResourceInitializer() {
        if (ModelUtility.getResourceInitializer().forEclipse()) {
            this.setInjector(Guice.createInjector((Module[])new Module[]{new IvmlRuntimeModule()}));
        } else {
            this.setInjector(new IvmlStandaloneSetup().createInjectorAndDoEMFRegistration());
        }
    }

    protected String getLanguageName() {
        return "de.uni_hildesheim.sse.Ivml";
    }

    protected ClassLoader getLanguageClassLoader() {
        return ModelUtility.class.getClassLoader();
    }

    public TranslationResult<net.ssehub.easy.varModel.model.Project> createVarModel(VariabilityUnit root, java.net.URI uri, boolean registerSuccessful) {
        ModelTranslator translator = new ModelTranslator();
        ImportResolver impResolver = VarModel.INSTANCE.getResolverFromPool();
        ModelTranslator.Result mRes = translator.createModel(root, uri, registerSuccessful, (ImportResolver<net.ssehub.easy.varModel.model.Project>)impResolver);
        impResolver.addDeferredLoader((IDeferredModelLoader)mRes);
        VarModel.INSTANCE.releaseResolver(impResolver);
        return mRes.createTranslationResult();
    }

    public void print(TranslationResult<net.ssehub.easy.varModel.model.Project> result, Writer out, boolean emitComments, boolean emitImports) {
        try {
            ConfigurableIVMLWriter writer = new ConfigurableIVMLWriter(out, emitComments, emitImports);
            for (int p = 0; p < result.getResultCount(); ++p) {
                ((net.ssehub.easy.varModel.model.Project)result.getResult(p)).accept((IModelVisitor)writer);
            }
            writer.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public TranslationResult<net.ssehub.easy.varModel.model.Project> parse(URI uri, ImportResolver<net.ssehub.easy.varModel.model.Project> resolver) throws IOException {
        ImportResolver impResolver = null == resolver ? VarModel.INSTANCE.getResolverFromPool() : resolver;
        ModelTranslator translator = new ModelTranslator();
        VariabilityUnit root = (VariabilityUnit)this.parse(uri, true, (MessageReceiver)translator, VariabilityUnit.class);
        ModelTranslator.Result mRes = null;
        if (null != root) {
            try {
                mRes = translator.createModel(root, ModelUtility.toNetUri((URI)uri), true, (ImportResolver<net.ssehub.easy.varModel.model.Project>)impResolver);
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        } else {
            mRes = translator.createEmptyResult();
        }
        impResolver.addDeferredLoader((IDeferredModelLoader)mRes);
        if (null == resolver) {
            VarModel.INSTANCE.releaseResolver(impResolver);
        }
        return mRes.createTranslationResult();
    }

    public List<ModelInfo<net.ssehub.easy.varModel.model.Project>> obtainInfo(URI uri) throws IOException {
        VariabilityUnit root = (VariabilityUnit)this.parse(uri, true, null, VariabilityUnit.class);
        ArrayList<ModelInfo<net.ssehub.easy.varModel.model.Project>> result = new ArrayList<ModelInfo<net.ssehub.easy.varModel.model.Project>>();
        if (null != root) {
            for (Project project : root.getProjects()) {
                Version version = null;
                VersionStmt versionStatement = project.getVersion();
                String vString = null == versionStatement ? null : versionStatement.getVersion();
                if (null == vString) {
                    version = null;
                } else {
                    try {
                        version = new Version(vString);
                    }
                    catch (VersionFormatException versionFormatException) {
                        // empty catch block
                    }
                }
                ArrayList<ProjectImport> imp = new ArrayList<ProjectImport>();
                for (Object importStmt : project.getImports()) {
                    try {
                        imp.add(ImportTranslator.processImport(importStmt));
                    }
                    catch (TranslatorException e) {
                        throw new IOException(e);
                    }
                }
                for (Object importStmt : project.getConflicts()) {
                    try {
                        imp.add(ImportTranslator.processConflict((ConflictStmt)importStmt));
                    }
                    catch (TranslatorException translatorException) {}
                }
                try {
                    result.add((ModelInfo<net.ssehub.easy.varModel.model.Project>)new ModelInfo(project.getName(), version, (IModelLoader)this, ModelUtility.toNetUri((URI)uri), imp));
                }
                catch (URISyntaxException e) {
                    throw new IOException(e);
                }
            }
        }
        return result;
    }

    public static final String stringValue(Type type) {
        return ModelUtility.stringValue(type, false);
    }

    public static final String stringValue(Type type, boolean forSearch) {
        String result;
        if (null != type) {
            if (null != type.getDerived()) {
                String op = type.getDerived().getOp();
                if (forSearch) {
                    if (op.equals("setOf")) {
                        op = "s";
                    } else if (op.equals("sequenceOf")) {
                        op = "q";
                    } else if (op.equals("refTo")) {
                        op = "r";
                    }
                }
                result = ModelUtility.stringValue(type.getDerived(), forSearch);
            } else {
                result = null != type.getType() ? type.getType().getType() : (null != type.getId() ? Utils.getQualifiedNameString(type.getId()) : "<unknown type>");
            }
        } else {
            result = "";
        }
        return result;
    }

    public static final String stringValue(DerivedType type, boolean forSearch) {
        String op = type.getOp();
        if (forSearch) {
            if (op.equals("setOf")) {
                op = "s";
            } else if (op.equals("sequenceOf")) {
                op = "q";
            } else if (op.equals("refTo")) {
                op = "r";
            }
        }
        return op + "(" + ModelUtility.stringValue(type.getType(), forSearch) + ")";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Constraint createConstraint(String text, net.ssehub.easy.varModel.model.Project project, boolean asStatement) throws CSTSemanticException, ConstraintSyntaxException {
        ExpressionStatement stm;
        ExpressionTranslator translator;
        Constraint constraint = null;
        String ruleName = asStatement ? "ExpressionStatement" : "Expression";
        IParseResult result = this.parseFragment(ruleName, text);
        if (null == result) throw new ConstraintSyntaxException("internal: IVML grammar not available");
        StringBuilder errors = new StringBuilder();
        for (INode error : result.getSyntaxErrors()) {
            ModelUtility.appendWithNewLine((StringBuilder)errors, (String)error.getText());
        }
        if (0 == errors.length() && null == result.getRootASTElement()) {
            ModelUtility.appendWithNewLine((StringBuilder)errors, (String)"empty constraint");
        }
        if (0 != errors.length()) throw new ConstraintSyntaxException(errors.toString());
        ExpressionTranslator messageReceiver = translator = new ExpressionTranslator();
        Expression expr = asStatement ? (null != (stm = (ExpressionStatement)result.getRootASTElement()) ? stm.getExpr() : null) : (Expression)result.getRootASTElement();
        TypeContext context = new TypeContext(project, (MessageReceiver)messageReceiver);
        constraint = new Constraint((IModelElement)project);
        try {
            constraint.setConsSyntax(translator.processExpression(expr, context, (IModelElement)constraint));
            if (translator.getErrorCount() > 0) {
                for (int i = 0; i < translator.getMessageCount(); ++i) {
                    Message msg = translator.getMessage(i);
                    if (Status.ERROR != msg.getStatus()) continue;
                    ModelUtility.appendWithNewLine((StringBuilder)errors, (String)msg.getDescription());
                }
                throw new CSTSemanticException(errors.toString(), 10103);
            }
            constraint.getConsSyntax().inferDatatype();
            return constraint;
        }
        catch (TranslatorException e) {
            throw new CSTSemanticException(e.getMessage(), 10103);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConstraintSyntaxTree createExpression(String text, IModelElement parent) throws CSTSemanticException, ConstraintSyntaxException {
        IModelElement iter;
        IDatatype type;
        ExpressionTranslator translator;
        ConstraintSyntaxTree expression = null;
        IParseResult result = this.parseFragment("Expression", text);
        if (null == result) throw new ConstraintSyntaxException("internal: IVML grammar not available");
        StringBuilder errors = new StringBuilder();
        for (INode error : result.getSyntaxErrors()) {
            ModelUtility.appendWithNewLine((StringBuilder)errors, (String)error.getText());
        }
        if (0 == errors.length() && null == result.getRootASTElement()) {
            ModelUtility.appendWithNewLine((StringBuilder)errors, (String)"empty constraint");
        }
        if (0 != errors.length()) throw new ConstraintSyntaxException(errors.toString());
        ExpressionTranslator messageReceiver = translator = new ExpressionTranslator();
        Expression expr = (Expression)result.getRootASTElement();
        IModelElement expressionParent = null;
        if (parent instanceof AbstractVariable && (type = ((AbstractVariable)parent).getType()) instanceof IModelElement) {
            parent = (IModelElement)type;
        }
        for (iter = parent; null != iter && !(iter instanceof net.ssehub.easy.varModel.model.Project); iter = iter.getParent()) {
            if (!(iter instanceof Compound)) continue;
            expressionParent = iter;
        }
        net.ssehub.easy.varModel.model.Project project = null;
        if (iter instanceof net.ssehub.easy.varModel.model.Project) {
            project = (net.ssehub.easy.varModel.model.Project)iter;
        }
        if (null == expressionParent) {
            expressionParent = null == project ? parent : project;
        }
        TypeContext context = new TypeContext(project, (MessageReceiver)messageReceiver);
        if (expressionParent instanceof Compound) {
            context.pushLayer(expressionParent);
            context.addToContext((Compound)expressionParent);
        }
        try {
            expression = translator.processExpression(expr, context, expressionParent);
            if (translator.getErrorCount() > 0) {
                for (int i = 0; i < translator.getMessageCount(); ++i) {
                    Message msg = translator.getMessage(i);
                    if (Status.ERROR != msg.getStatus()) continue;
                    ModelUtility.appendWithNewLine((StringBuilder)errors, (String)msg.getDescription());
                }
                throw new CSTSemanticException(errors.toString(), 10103);
            }
            expression.inferDatatype();
            return expression;
        }
        catch (TranslatorException e) {
            throw new CSTSemanticException(e.getMessage(), 10103);
        }
    }

    public String getExtension() {
        return "ivml";
    }
}

