/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.velocity;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.IRegistration;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.instantiation.velocity.VelocityCompoundAccess;
import net.ssehub.easy.instantiation.velocity.VelocityContextInitializer;
import net.ssehub.easy.instantiation.velocity.VelocityContextItem;
import net.ssehub.easy.varModel.confModel.IDecisionVariable;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.apache.velocity.exception.ParseErrorException;
import org.osgi.service.component.ComponentContext;

@Instantiator(value="velocity")
public class VelocityInstantiator
implements IVilType,
IRegistration {
    private static boolean registered = false;

    public static final void register() {
        if (!registered) {
            registered = true;
            TypeRegistry.DEFAULT.register(VelocityInstantiator.class);
        }
    }

    protected void activate(ComponentContext context) {
        VelocityInstantiator.register();
    }

    protected void deactivate(ComponentContext context) {
    }

    public static Set<FileArtifact> velocity(Collection<FileArtifact> templates, Configuration config) throws VilException {
        return VelocityInstantiator.velocity(templates, config, null);
    }

    public static Set<FileArtifact> velocity(Collection<FileArtifact> templates, Configuration config, Map<?, ?> nameMapping) throws VilException {
        VelocityEngine engine = VelocityInstantiator.createEngine();
        VelocityContext context = VelocityInstantiator.createContext(config, nameMapping);
        ArrayList<FileArtifact> tmp = new ArrayList<FileArtifact>();
        Iterator iter = templates.iterator();
        while (iter.hasNext()) {
            tmp.add(VelocityInstantiator.instantiate((FileArtifact)iter.next(), engine, context));
        }
        Object[] result = new FileArtifact[tmp.size()];
        tmp.toArray(result);
        return new ArraySet(result, FileArtifact.class);
    }

    private static VelocityEngine createEngine() {
        Properties properties = new Properties();
        properties.put("runtime.log.logsystem.class", "org.apache.velocity.runtime.log.NullLogSystem");
        VelocityEngine engine = new VelocityEngine();
        properties.put("resource.loader", "file");
        properties.put("file.resource.loader.class", "org.apache.velocity.runtime.resource.loader.FileResourceLoader");
        properties.put("file.resource.loader.path", "");
        try {
            engine.init(properties);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return engine;
    }

    public static Set<FileArtifact> velocity(Path template, Configuration config) throws VilException {
        return VelocityInstantiator.velocity(template, config, null);
    }

    public static Set<FileArtifact> velocity(Path template, Configuration config, Map<?, ?> nameMapping) throws VilException {
        ArraySet result;
        if (template.isPattern()) {
            result = VelocityInstantiator.velocity((Collection<FileArtifact>)template.selectAll(), config, nameMapping);
        } else {
            VelocityEngine engine = VelocityInstantiator.createEngine();
            VelocityContext context = VelocityInstantiator.createContext(config, nameMapping);
            Object[] tmp = new FileArtifact[1];
            FileArtifact templateArtifact = (FileArtifact)ArtifactFactory.createArtifact(FileArtifact.class, (Object)template.getAbsolutePath(), (ArtifactModel)template.getArtifactModel());
            tmp[0] = VelocityInstantiator.instantiate(templateArtifact, engine, context);
            result = new ArraySet(tmp, FileArtifact.class);
        }
        return result;
    }

    private static final VelocityContext createContext(Configuration config, Map<?, ?> nameMapping) {
        VelocityContext context = new VelocityContext();
        for (DecisionVariable var : config.variables()) {
            IDecisionVariable dVar = var.getDecisionVariable();
            VelocityContextInitializer initializer = new VelocityContextInitializer(dVar);
            List<VelocityContextItem> items = initializer.getItems();
            for (int i = 0; i < items.size(); ++i) {
                Object tmp;
                String name = items.get(i).getName();
                if (null != nameMapping && null != (tmp = nameMapping.get((Object)name))) {
                    name = StringValueHelper.getStringValue((Object)tmp, null);
                }
                Object value = items.get(i).getValue();
                if (items.get(i) instanceof VelocityCompoundAccess) {
                    value = items.get(i);
                }
                if (null == value) continue;
                context.put(name, value);
            }
        }
        return context;
    }

    private static final FileArtifact instantiate(FileArtifact template, VelocityEngine engine, VelocityContext context) throws VilException {
        File file = template.getPath().getAbsolutePath();
        String path = file.getAbsolutePath();
        StringWriter writer = null;
        try {
            Template t = engine.getTemplate(path);
            writer = new StringWriter();
            t.merge((Context)context, (Writer)writer);
        }
        catch (ParseErrorException e) {
            StringBuffer errorMsg = new StringBuffer("Parse error in\n");
            errorMsg.append(e.getTemplateName());
            errorMsg.append("[line ");
            errorMsg.append(e.getLineNumber());
            errorMsg.append(", column ");
            errorMsg.append(e.getColumnNumber());
            errorMsg.append("]\n");
            String detailedMsg = e.getLocalizedMessage();
            int start = detailedMsg.indexOf("\n");
            errorMsg.append(detailedMsg.substring(start + 1));
            throw new VilException(errorMsg.toString(), 50001);
        }
        catch (Exception e) {
            EASyLoggerFactory.INSTANCE.getLogger(VelocityInstantiator.class, "net.ssehub.easy.instantiation.velocity").exception(e);
            throw new VilException(e.getLocalizedMessage(), 50001);
        }
        FileWriter fileWriter = null;
        try {
            fileWriter = new FileWriter(file);
            fileWriter.write(writer.toString());
        }
        catch (IOException e) {
            EASyLoggerFactory.INSTANCE.getLogger(VelocityInstantiator.class, "velocity").exception((Exception)e);
            throw new VilException(e.getLocalizedMessage(), 50001);
        }
        finally {
            if (fileWriter != null) {
                try {
                    ((Writer)fileWriter).close();
                }
                catch (IOException iOException) {}
            }
        }
        return template;
    }
}

