/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.java.artifacts;

import net.ssehub.easy.instantiation.core.model.artifactModel.FragmentArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifactVisitor;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Binary;
import net.ssehub.easy.instantiation.core.model.artifactModel.representation.Text;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.java.artifacts.IJavaParent;
import net.ssehub.easy.instantiation.java.artifacts.JavaMethod;
import net.ssehub.easy.instantiation.java.artifacts.JavaParentFragmentArtifact;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.ITypeBinding;

abstract class AbstractJavaStatement
extends JavaParentFragmentArtifact {
    private String attributeName;
    private ExpressionStatement expression;
    private String binding;
    private String qualifiedName;

    AbstractJavaStatement(IJavaParent parent, ExpressionStatement expression, String attributeName, ITypeBinding typeBinding) {
        super(parent);
        this.expression = expression;
        this.attributeName = attributeName;
        this.binding = typeBinding.getName();
        this.qualifiedName = typeBinding.getQualifiedName();
    }

    @Override
    public void delete() throws VilException {
        try {
            this.expression.delete();
            super.delete();
        }
        catch (IllegalArgumentException e) {
            throw new VilException("Cannot delete \"" + this.attributeName + "\" from " + ((JavaMethod)this.getParent()).getNameSafe() + ".", 30010);
        }
    }

    public String getName() throws VilException {
        return this.attributeName;
    }

    public void rename(String name) throws VilException {
    }

    public String getQualifiedName() {
        return this.qualifiedName;
    }

    public String getType() {
        return this.binding;
    }

    public Text getText() throws VilException {
        return Text.CONSTANT_EMPTY;
    }

    public Binary getBinary() throws VilException {
        return Binary.CONSTANT_EMPTY;
    }

    public void accept(IArtifactVisitor visitor) {
        visitor.visitFragmentArtifact((FragmentArtifact)this);
    }

    @Invisible
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return "call '" + this.getNameSafe() + "'";
    }
}

