/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.ant.instantiators;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import net.ssehub.easy.instantiation.ant.instantiators.CustomAntLogger;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileUtils;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.PathUtils;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.defaultInstantiators.AbstractFileInstantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;

@Instantiator(value="make")
public class Make
extends AbstractFileInstantiator {
    private static final CustomAntLogger CONSOLE_LOGGER = new CustomAntLogger();
    private static final String XML_TYPE = ".xml";
    private static final int ERR_PRIO = 0;
    private static final int MSG_PRIO = 2;

    @OperationMeta(returnGenerics={FileArtifact.class})
    public static Set<FileArtifact> make(Path root, String buildFilePath, String buildtarget, Map<String, Object> arguments) throws VilException {
        File buildFile = new File(root.getAbsolutePath(), buildFilePath);
        String fullBuildFilePath = buildFile.getAbsolutePath();
        long timestamp = PathUtils.normalizedTime();
        File targetPath = Make.determineTargetPath((Path)root);
        if (!buildFile.exists() || !buildFile.isDirectory()) {
            throw new VilException("invalid build path", 30008);
        }
        buildFile = Make.createTempBuildFile(fullBuildFilePath, Make.argumentsToString(arguments));
        Project p = new Project();
        Make.antDebugging(p);
        p.setUserProperty("ant.file", buildFile.getAbsolutePath());
        try {
            p.fireBuildStarted();
            p.init();
            ProjectHelper helper = ProjectHelper.getProjectHelper();
            p.addReference("ant.projectHelper", (Object)helper);
            helper.parse(p, (Object)buildFile);
            p.executeTarget(buildtarget);
            p.fireBuildFinished(null);
        }
        catch (Exception e) {
            p.fireBuildFinished((Throwable)e);
            throw new VilException(e.getMessage(), 30012);
        }
        if (CONSOLE_LOGGER.getMessages().containsKey(0)) {
            throw new VilException("MAKE: " + CONSOLE_LOGGER.getMessages().get(2) + " " + CONSOLE_LOGGER.getMessages().get(0), 30008);
        }
        ArrayList result = new ArrayList();
        FileUtils.ScanResult scanResult = new FileUtils.ScanResult(result);
        FileUtils.scan((File)targetPath.getAbsoluteFile(), (ArtifactModel)root.getArtifactModel(), (long)timestamp, (FileUtils.ScanResult)scanResult, FileArtifact.class);
        scanResult.checkForException();
        return new ListSet(result, FileArtifact.class);
    }

    private static File createTempBuildFile(String path, String arguments) {
        File temp = null;
        String content = "<?xml version=\"1.0\" ?> <project name=\"TestANTMAKE\" default=\"make\"> \n <target name=\"make\">\n <exec executable=\"make\">\n <arg line=\"" + arguments + " -C " + path + "\"/>\n</exec>\n</target>\n</project>";
        try {
            temp = File.createTempFile(String.valueOf(new Random().nextInt()), XML_TYPE);
            FileWriter fw = new FileWriter(temp.getPath(), true);
            fw.write(content);
            fw.flush();
            fw.close();
            temp.deleteOnExit();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return temp;
    }

    private static String argumentsToString(Map<String, Object> arguments) {
        String argument = "";
        for (Map.Entry<String, Object> param : arguments.entrySet()) {
            argument = argument + Make.toString((Object)(param.getValue() + " "));
        }
        return argument;
    }

    private static void antDebugging(Project project) {
        CONSOLE_LOGGER.setErrorPrintStream(System.err);
        CONSOLE_LOGGER.setOutputPrintStream(System.out);
        CONSOLE_LOGGER.setMessageOutputLevel(2);
        project.addBuildListener((BuildListener)CONSOLE_LOGGER);
    }
}

