/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.standard;

import java.io.File;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagement;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.basics.modelManagement.VersionFormatException;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.producer.core.persistence.Configuration;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.PersistenceUtils;
import net.ssehub.easy.producer.core.persistence.datatypes.PersistentProject;
import net.ssehub.easy.producer.core.varMod.container.ModelContainer;
import net.ssehub.easy.producer.core.varMod.container.ModelContainerFactory;
import net.ssehub.easy.producer.core.varMod.container.ProjectContainer;
import net.ssehub.easy.producer.core.varMod.container.ScriptContainer;
import net.ssehub.easy.producer.core.varMod.container.SemanticErrorDescription;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;

class ModelLoader<Model extends IModel> {
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(ModelLoader.class, "net.ssehub.easy.producer.core");
    private PersistentProject project;
    private Configuration location;

    public ModelLoader(PersistentProject project, Configuration location) {
        this.project = project;
        this.location = location;
    }

    public void loadModel(String projectName, String projectVersion, Configuration.PathKind modelType) throws PersistenceException {
        switch (modelType) {
            case IVML: {
                ProjectContainer projectContainer = (ProjectContainer)this.loadModel(projectName, projectVersion, (ModelManagement<Model>)VarModel.INSTANCE, modelType);
                this.project.setVarModel(projectContainer);
                break;
            }
            case VIL: {
                ScriptContainer scriptContainer = (ScriptContainer)this.loadModel(projectName, projectVersion, (ModelManagement<Model>)BuildModel.INSTANCE, modelType);
                this.project.setScript(scriptContainer);
                break;
            }
        }
    }

    private ModelContainer<?> loadModel(String projectName, String projectVersion, ModelManagement<Model> modelManagement, Configuration.PathKind modelType) throws PersistenceException {
        File folder = this.location.getPathFile(modelType, 0);
        String fileName = PersistenceUtils.modelFileLocation(projectName, projectVersion, folder.getAbsolutePath(), modelType);
        File file = new File(fileName);
        Object model = null;
        ModelInfo info = null;
        ModelContainer<?> modelContainer = null;
        try {
            List alternatives;
            info = modelManagement.availableModels().getModelInfo(projectName, projectVersion, file.toURI());
            if (null == info && null != (alternatives = modelManagement.availableModels().getVisibleModelInfo(projectName, file.toURI())) && 1 == alternatives.size()) {
                info = (ModelInfo)alternatives.get(0);
                LOGGER.warn("No " + modelType.name() + "-model found with name =\"" + projectName + "\" and version =\"" + projectVersion + "\" at " + file.getAbsolutePath() + ", load single available alternative.");
            }
        }
        catch (VersionFormatException e) {
            throw new PersistenceException(e);
        }
        if (null != info) {
            LOGGER.debug("Found: " + info.toString());
            try {
                model = modelManagement.load(info);
                modelContainer = ModelContainerFactory.createContainer(model, this.location);
                LOGGER.debug("Model loaded: " + info.toString());
            }
            catch (ModelManagementException e) {
                if (e.getId() == 10599) {
                    throw new PersistenceException(e);
                }
                try {
                    model = modelManagement.load(info);
                    modelContainer = ModelContainerFactory.createContainer(model, this.location);
                    LOGGER.debug("Model loaded: " + info.toString());
                }
                catch (ModelManagementException e1) {
                    LOGGER.warn(info.getName() + " " + Version.toString((Version)info.getVersion()) + " cannot be loaded: " + e.getLocalizedMessage());
                    model = this.createEmptyModel(projectName, projectVersion, modelType);
                    SemanticErrorDescription description = new SemanticErrorDescription(file.getAbsolutePath(), e.getLocalizedMessage());
                    modelContainer = ModelContainerFactory.createContainer(model, description, this.location);
                }
            }
        } else {
            model = this.createEmptyModel(projectName, projectVersion, modelType);
            modelManagement.updateModel(model, file.toURI());
            SemanticErrorDescription description = null;
            if (file.exists()) {
                LOGGER.warn("File cannot be parsed: " + file.getName());
                description = new SemanticErrorDescription(file.getAbsolutePath(), "File contains syntax errors");
            }
            modelContainer = ModelContainerFactory.createContainer(model, description, this.location);
        }
        return modelContainer;
    }

    private Model createEmptyModel(String projectName, String projectVersion, Configuration.PathKind modelType) {
        Project result = null;
        switch (modelType) {
            case IVML: {
                result = new Project(projectName);
                break;
            }
            case VIL: {
                result = new Script(projectName);
                break;
            }
        }
        if (null != result && null != projectVersion) {
            try {
                Version version = new Version(projectVersion);
                result.setVersion(version);
            }
            catch (VersionFormatException e) {
                LOGGER.exception((Exception)((Object)e));
            }
        }
        return (Model)result;
    }
}

