/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.datatypes;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.ssehub.easy.producer.core.persistence.internal.util.FileUtils;

public class PathEnvironment {
    public static final String NAME_SEPARATOR = ":";
    private File baseFolder;
    private List<Entry> mapping = new ArrayList<Entry>();

    public PathEnvironment(File baseFolder) {
        this.baseFolder = baseFolder;
    }

    public void addMapping(String name, String ... paths) {
        if (null != name && name.length() > 0 && null != paths) {
            if (!name.endsWith(NAME_SEPARATOR)) {
                name = name + NAME_SEPARATOR;
            }
            Entry entry = null;
            for (int m = 0; null == entry && m < this.mapping.size(); ++m) {
                Entry tmp = this.mapping.get(m);
                if (!tmp.getName().equals(name)) continue;
                entry = tmp;
            }
            if (null == entry) {
                this.mapping.add(new Entry(name, paths));
            } else {
                entry.add(paths);
            }
        }
    }

    public void removeMapping(String name) {
        if (null != name) {
            for (int m = this.mapping.size() - 1; m >= 0; --m) {
                if (!this.mapping.get(m).getName().equals(name)) continue;
                this.mapping.remove(m);
            }
        }
    }

    public void clear() {
        this.mapping.clear();
    }

    public File getBaseFolder() {
        return this.baseFolder;
    }

    public String makeRelative(File location) {
        String result = null;
        int size = this.mapping.size();
        if (size > 0) {
            for (int m = 0; null == result && m < size; ++m) {
                result = this.mapping.get(m).makeRelative(location);
            }
        }
        if (null == result) {
            result = FileUtils.makeRelative(this.baseFolder, location);
        }
        return result;
    }

    public File makeAbsolute(String location) {
        File result = null;
        int size = this.mapping.size();
        if (size > 0) {
            for (int m = 0; null == result && m < size; ++m) {
                result = this.mapping.get(m).makeAbsolute(location);
            }
        }
        if (null == result) {
            result = FileUtils.makeAbsoluteFile(this.baseFolder, location);
        }
        return result;
    }

    private class Entry {
        private String name;
        private String[] paths;

        Entry(String name, String[] paths) {
            this.name = name;
            this.paths = new String[paths.length];
            System.arraycopy(paths, 0, this.paths, 0, paths.length);
            this.convertPaths(this.paths);
        }

        private void convertPaths(String[] paths) {
            for (int p = 0; p < paths.length; ++p) {
                paths[p] = FileUtils.toIndependent(paths[p]);
            }
        }

        String makeRelative(File location) {
            String result = null;
            String tmp = FileUtils.toIndependent(location.getAbsolutePath());
            for (int p = 0; null == result && p < this.paths.length; ++p) {
                if (null == this.paths[p] || !this.paths[p].equals(tmp)) continue;
                result = this.name + location.getName();
            }
            return result;
        }

        File makeAbsolute(String location) {
            File result = null;
            if (location.startsWith(this.name)) {
                location = location.substring(this.name.length());
                String searchString = '/' + location;
                int len = location.length();
                for (int p = 0; null == result && p < this.paths.length; ++p) {
                    if (!this.paths[p].endsWith(searchString) || this.paths[p].length() <= len) continue;
                    result = new File(this.paths[p].substring(0, this.paths[p].length() - len) + location);
                }
            }
            return result;
        }

        String getName() {
            return this.name;
        }

        void add(String[] paths) {
            if (null != paths) {
                String[] tmp = new String[this.paths.length + paths.length];
                System.arraycopy(this.paths, 0, tmp, 0, this.paths.length);
                System.arraycopy(paths, 0, tmp, this.paths.length, paths.length);
                this.convertPaths(tmp);
                this.paths = tmp;
            }
        }

        public String toString() {
            return this.name + Arrays.toString(this.paths);
        }
    }
}

