/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence;

import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.producer.core.persistence.ConfigurationContentHandler;
import net.ssehub.easy.producer.core.persistence.internal.IndentationPrintWriter;
import net.ssehub.easy.producer.core.persistence.internal.util.FileUtils;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public class Configuration {
    public static final Configuration DEFAULT = new Configuration();
    static final String TOP_LEVEL_CONFIG_NAME = ".EASyProducer";
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(Configuration.class, "net.ssehub.easy.producer.core");
    private Map<PathKind, List<String>> paths;
    private File projectFolder;
    private File file;
    private long timestamp;

    private Configuration() {
        this.createStructures();
        this.setToEASyDefaults();
    }

    Configuration(Configuration src) {
        if (null == src) {
            src = DEFAULT;
        }
        this.projectFolder = src.projectFolder;
        this.file = src.file;
        this.timestamp = src.timestamp;
        this.createStructures();
        for (PathKind kind : PathKind.values()) {
            this.paths.put(kind, new ArrayList(src.paths.get((Object)kind)));
        }
    }

    Configuration(File projectFolder) {
        this.createStructures();
        this.projectFolder = projectFolder;
        this.file = new File(this.projectFolder, TOP_LEVEL_CONFIG_NAME);
        if (this.file.exists()) {
            this.load();
        } else {
            this.initDefaults();
        }
    }

    void checkForModification() {
        if (!this.isRecent()) {
            this.load();
        }
    }

    public void setToEASyDefaults() {
        this.setPathDirect(PathKind.IVML, "EASy");
        this.setPathDirect(PathKind.VIL, "EASy");
        this.setPathDirect(PathKind.VTL, "EASy");
    }

    public boolean isRecent() {
        boolean recent = this.file.exists() && this.timestamp > 0L ? this.file.lastModified() > this.timestamp : true;
        return recent;
    }

    public boolean isMaterialized() {
        return null != this.file && this.file.exists();
    }

    private void readOldFormat(String firstLine, LineNumberReader lnr) throws IOException {
        if (null != firstLine) {
            this.setPathDirect(PathKind.IVML, firstLine);
            String line = lnr.readLine();
            if (null != line) {
                this.setPathDirect(PathKind.VIL, line);
                this.setPathDirect(PathKind.VTL, line);
            } else {
                this.setPathDirect(PathKind.VIL, firstLine);
                this.setPathDirect(PathKind.VTL, firstLine);
            }
        }
    }

    private void readXmlFormat(Reader reader) throws IOException {
        try {
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            InputSource inputSource = new InputSource(reader);
            xmlReader.setContentHandler(new ConfigurationContentHandler(this));
            xmlReader.parse(inputSource);
            if (null == this.getPath(PathKind.VTL, 0)) {
                this.setPathDirect(PathKind.VTL, this.combinePath(PathKind.VIL));
            }
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
    }

    private void load() {
        if (null != this.file) {
            block12: {
                this.clear();
                FileReader reader = null;
                try {
                    LineNumberReader lnr;
                    String line;
                    reader = new FileReader(this.file);
                    if (reader.markSupported()) {
                        reader.mark(0);
                    }
                    if (null != (line = (lnr = new LineNumberReader(reader)).readLine()) && line.trim().startsWith("<?xml")) {
                        if (reader.markSupported()) {
                            reader.reset();
                        } else {
                            try {
                                reader.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                            reader = new FileReader(this.file);
                        }
                        this.readXmlFormat(reader);
                    } else {
                        this.readOldFormat(line, lnr);
                    }
                    reader.close();
                    this.timestamp = this.file.lastModified();
                }
                catch (IOException e) {
                    LOGGER.warn("configuration I/O problem: " + e.getMessage());
                    if (null == reader) break block12;
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            this.initDefaults();
        }
    }

    private void createStructures() {
        this.paths = new HashMap<PathKind, List<String>>();
        for (PathKind kind : PathKind.values()) {
            this.paths.put(kind, new ArrayList());
        }
    }

    private void initDefaults() {
        for (PathKind kind : PathKind.values()) {
            this.setPathDefault(kind);
        }
    }

    private void clear() {
        for (PathKind kind : PathKind.values()) {
            this.paths.get((Object)kind).clear();
        }
    }

    private void setPathDefault(PathKind kind) {
        if (this.paths.get((Object)kind).isEmpty()) {
            this.paths.get((Object)kind).addAll((Collection<String>)Configuration.DEFAULT.paths.get((Object)kind));
        }
    }

    public static String checkPath(String path) {
        if (!path.endsWith(FileUtils.SEPARATOR_STRING)) {
            path = path + FileUtils.SEPARATOR_STRING;
        }
        return path;
    }

    public void setPathDirect(PathKind kind, String path) {
        if (!path.endsWith(FileUtils.SEPARATOR_STRING)) {
            path = path + FileUtils.SEPARATOR_STRING;
        }
        List<String> pth = this.paths.get((Object)kind);
        pth.clear();
        for (String s : path.replace(":", ";").split(";")) {
            pth.add(s);
        }
    }

    public void setPath(PathKind kind, String path) throws IOException {
        this.setPath(kind, new File(path));
    }

    public void setPath(PathKind kind, File path) throws IOException {
        String sPath = path.getCanonicalPath();
        if (null != this.projectFolder) {
            String pPath = this.projectFolder.getPath();
            if (!pPath.endsWith(File.separator)) {
                pPath = pPath + File.separator;
            }
            if (sPath.startsWith(pPath)) {
                sPath = sPath.substring(pPath.length());
            }
        }
        this.setPathDirect(kind, FileUtils.toIndependent(path.getPath()));
    }

    public int getPathCount(PathKind kind) {
        return this.paths.get((Object)kind).size();
    }

    public String getPath(PathKind kind, int index) {
        return this.paths.get((Object)kind).isEmpty() ? null : this.paths.get((Object)kind).get(index);
    }

    public boolean isPathEasyDefault(PathKind kind) {
        return "EASy".equals(this.getPath(kind, 0));
    }

    public File getPathFile(PathKind kind, int index) {
        return new File(this.projectFolder, this.getPath(kind, index));
    }

    public void store() {
        if (null != this.file) {
            IndentationPrintWriter writer = null;
            try {
                writer = new IndentationPrintWriter(new FileWriter(this.file));
                writer.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
                writer.println("<configuration>");
                writer.increaseIndentation();
                for (PathKind kind : PathKind.values()) {
                    this.storePath(writer, kind);
                }
                writer.decreaseIndentation();
                writer.println("</configuration>");
                writer.close();
            }
            catch (IOException e) {
                LOGGER.warn("configuration I/O problem: " + e.getMessage());
            }
            this.timestamp = this.file.lastModified();
        }
    }

    public String combinePath(PathKind kind) {
        String result;
        List<String> pth = this.paths.get((Object)kind);
        if (pth.isEmpty()) {
            result = null;
        } else {
            result = "";
            for (int p = 0; p < pth.size(); ++p) {
                if (p > 0) {
                    result = result + File.pathSeparator;
                }
                result = result + pth.get(p);
            }
        }
        return result;
    }

    private void storePath(IndentationPrintWriter writer, PathKind kind) {
        String path = this.combinePath(kind);
        if (null != path && path.length() > 0) {
            writer.printIndentation();
            writer.print("<path kind=\"");
            writer.print(kind.name());
            writer.print("\" value=\"");
            writer.print(path);
            writer.println("\" />");
        }
    }

    public static enum PathKind {
        IVML,
        VIL,
        VTL;

    }
}

