/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.mgmt;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.execution.Executor;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;

public abstract class VilArgumentProvider {
    private static List<VilArgumentProvider> instances = new ArrayList<VilArgumentProvider>();
    private boolean active = true;

    public static void add(VilArgumentProvider provider) {
        if (null != provider) {
            instances.add(provider);
        }
    }

    public static void remove(VilArgumentProvider provider) {
        if (null != provider) {
            instances.remove(provider);
        }
    }

    public static void provideArguments(PLPInfo plp, Executor executor) {
        for (VilArgumentProvider provider : instances) {
            provider.provideArgumentsImpl(plp, executor);
        }
    }

    public static int getProviderCount() {
        return instances.size();
    }

    public static VilArgumentProvider getProvider(int index) {
        return instances.get(index);
    }

    public static Iterator<VilArgumentProvider> instances() {
        return instances.iterator();
    }

    protected abstract void provideArgumentsImpl(PLPInfo var1, Executor var2);

    public abstract String getParameterName();

    public abstract String getParameterType();

    public abstract String getName();

    public abstract boolean acceptsFreeArguments();

    public abstract String getFreeArguments();

    public abstract void setFreeArguments(String var1);

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

