/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.mgmt;

import java.util.HashMap;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.IInstantiatorProjectManager;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;

public class SPLsManager
implements IInstantiatorProjectManager {
    public static final SPLsManager INSTANCE = new SPLsManager();
    private static final EASyLoggerFactory.EASyLogger LOGGER = EASyLoggerFactory.INSTANCE.getLogger(SPLsManager.class, "net.ssehub.easy.producer.core");
    private HashMap<String, PLPInfo> plProjects;

    private SPLsManager() {
        this.resetHashMaps();
    }

    private void resetHashMaps() {
        this.plProjects = new HashMap();
    }

    public void addPLP(PLPInfo plp) {
        PLPInfo info = this.plProjects.get(plp.getProjectID());
        boolean put = false;
        if (null != info && info.isPreliminary() && !plp.isPreliminary()) {
            for (PLPInfo p : this.plProjects.values()) {
                if (p == info) continue;
                p.getMemberController().replacePLPInfo(plp);
            }
            put = true;
        } else {
            boolean bl = put = this.plProjects.get(plp.getProjectID()) == null;
        }
        if (put) {
            this.plProjects.put(plp.getProjectID(), plp);
            plp.refresh();
            LOGGER.info("PLP added. Current projects: " + this.plProjects.toString());
        }
    }

    public void removePLP(String projectID) {
        PLPInfo plp = this.getPLP(projectID);
        if (plp != null) {
            this.plProjects.remove(projectID);
            LOGGER.info("PLP removed. Current projects: " + this.plProjects.toString());
        }
    }

    public HashMap<String, PLPInfo> getProductLineProjects() {
        return (HashMap)this.plProjects.clone();
    }

    public String getProjectPath(String projectID) {
        return this.plProjects.get(projectID).getProjectLocation().toString();
    }

    public String getPLPName(String projectID) {
        return this.getPLP(projectID).getProjectName();
    }

    public PLPInfo getPLP(String projectID) {
        return this.plProjects.get(projectID);
    }
}

