/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.mgmt;

import java.io.File;
import java.util.Collection;
import net.ssehub.easy.basics.progress.ProgressObserver;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.vilTypes.IProjectDescriptor;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;

class ProjectDescriptor
implements IProjectDescriptor {
    private PLPInfo info;
    private PLPInfo[] predecessors;

    ProjectDescriptor(PLPInfo info) {
        this.info = info;
        Collection<PLPInfo> pred = info.getMemberController().getPredecessors();
        this.predecessors = new PLPInfo[pred.size()];
        pred.toArray(this.predecessors);
    }

    public File getBase() {
        return this.info.getProjectLocation();
    }

    public int getPredecessorCount() {
        return this.predecessors.length;
    }

    public IProjectDescriptor getPredecessor(int index) {
        return new ProjectDescriptor(this.predecessors[index]);
    }

    public Script getMainVilScript() {
        return this.info.getBuildScript();
    }

    public ProgressObserver createObserver() {
        return ProgressObserver.NO_OBSERVER;
    }

    public String getModelFolder(IProjectDescriptor.ModelKind kind) {
        String result;
        switch (kind) {
            case IVML: {
                result = this.info.getConfigLocation().toString();
                break;
            }
            case VIL: {
                result = this.info.getScriptLocation().toString();
                break;
            }
            case VTL: {
                result = this.info.getTemplateLocation().toString();
                break;
            }
            default: {
                result = null;
            }
        }
        return result;
    }
}

