/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.mgmt;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.ssehub.easy.producer.core.mgmt.Controller;
import net.ssehub.easy.producer.core.mgmt.MemberIterator;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.mgmt.SPLsManager;

public class MemberController
extends Controller {
    private String memberID = null;
    private LinkedHashMap<String, PLPInfo> predecessors = new LinkedHashMap();
    private LinkedHashMap<String, PLPInfo> successors = new LinkedHashMap();

    public MemberController(String memberID) {
        this.memberID = memberID;
    }

    public void replacePLPInfo(PLPInfo newPLP) {
        MemberController.replacePLPInfo(this.predecessors, newPLP);
        MemberController.replacePLPInfo(this.successors, newPLP);
    }

    private static void replacePLPInfo(LinkedHashMap<String, PLPInfo> map, PLPInfo newPLP) {
        PLPInfo info = map.get(newPLP.getProjectID());
        if (null != info) {
            map.put(newPLP.getProjectID(), newPLP);
        }
    }

    public boolean hasPredecessors() {
        return this.predecessors.size() != 0;
    }

    public boolean hasSuccessors() {
        return this.successors.size() != 0;
    }

    public boolean containsPredecessor(UUID inputID) {
        return this.predecessors.containsKey(inputID.toString());
    }

    public boolean containsPredecessor(String projectName) {
        boolean found = false;
        ArrayList<PLPInfo> predList = new ArrayList<PLPInfo>(this.predecessors.values());
        for (int i = 0; i < predList.size(); ++i) {
            if (!((PLPInfo)predList.get(i)).getProjectName().equals(projectName)) continue;
            found = true;
            i = predList.size();
        }
        return found;
    }

    public boolean containsSuccessor(String inputID) {
        return this.successors.containsKey(inputID);
    }

    public Collection<PLPInfo> getPredecessors() {
        return this.predecessors.values();
    }

    public Set<String> getPredecessorIDs() {
        return this.predecessors.keySet();
    }

    public Iterable<String> getSuccessorIDs() {
        return this.successors.keySet();
    }

    public Iterable<PLPInfo> getSuccessors() {
        return this.successors.values();
    }

    public void setPredecessors(List<PLPInfo> predecessors) {
        this.predecessors.clear();
        for (PLPInfo info : predecessors) {
            this.addPredecessor(info);
        }
    }

    public void setSuccessors(List<PLPInfo> successors) {
        this.successors.clear();
        for (PLPInfo info : successors) {
            this.addSuccessor(info);
        }
    }

    public void addPredecessor(String predecessorID) {
        PLPInfo predecessorPLP = SPLsManager.INSTANCE.getPLP(predecessorID);
        if (predecessorPLP != null) {
            this.addPredecessor(predecessorPLP);
            if (!predecessorPLP.getMemberController().containsSuccessor(this.memberID)) {
                predecessorPLP.getMemberController().addSuccessor(this.memberID);
            }
        }
    }

    public void addPredecessor(PLPInfo info) {
        this.predecessors.put(info.getProjectID(), info);
        this.changed();
    }

    public void addSuccessor(String successorID) {
        PLPInfo successorPLP = SPLsManager.INSTANCE.getPLP(successorID);
        if (successorPLP != null) {
            this.addSuccessor(successorPLP);
            if (!successorPLP.getMemberController().containsPredecessor(this.memberID)) {
                successorPLP.getMemberController().addPredecessor(this.memberID);
            }
        }
    }

    public void addSuccessor(PLPInfo info) {
        this.successors.put(info.getProjectID(), info);
        this.changed();
    }

    public void removePredecessor(String predecessorID) {
        this.predecessors.remove(predecessorID);
        PLPInfo predecessorPLP = SPLsManager.INSTANCE.getPLP(predecessorID);
        if (predecessorPLP.getMemberController().containsSuccessor(this.memberID)) {
            predecessorPLP.getMemberController().removeSuccessor(this.memberID);
        }
        this.changed();
    }

    public void removeSuccessor(String successorID) {
        this.successors.remove(successorID);
        PLPInfo successorPLP = SPLsManager.INSTANCE.getPLP(successorID);
        if (successorPLP.getMemberController().containsPredecessor(this.memberID)) {
            successorPLP.getMemberController().removePredecessor(this.memberID);
        }
        this.changed();
    }

    public void clear() {
        this.predecessors.clear();
        this.successors.clear();
    }

    public List<String> getPossiblePredecessors() {
        HashMap<String, PLPInfo> allNodes = SPLsManager.INSTANCE.getProductLineProjects();
        ArrayList<String> result = new ArrayList<String>();
        result.addAll(allNodes.keySet());
        ArrayList<String> badElements = new ArrayList<String>();
        badElements.addAll(this.getAllSuccessors());
        for (String directSuccessor : this.getSuccessorIDs()) {
            PLPInfo plpSuccessor = SPLsManager.INSTANCE.getPLP(directSuccessor);
            if (null == plpSuccessor) continue;
            badElements.addAll(plpSuccessor.getMemberController().getAllSuccessors());
        }
        result.removeAll(badElements);
        result.remove(this.memberID);
        return result;
    }

    private List<String> getAllSuccessors() {
        ArrayList<String> result = new ArrayList<String>();
        for (String successor : this.successors.keySet()) {
            PLPInfo plp;
            if (!result.contains(successor)) {
                result.add(successor);
            }
            if ((plp = SPLsManager.INSTANCE.getPLP(successor)) == null) continue;
            result.addAll(plp.getMemberController().getAllSuccessors());
        }
        return result;
    }

    public MemberIterator predecessors() {
        Set<String> preCollection = this.predecessors.keySet();
        return new MemberIterator(preCollection);
    }

    public MemberIterator successors() {
        Set<String> preCollection = this.successors.keySet();
        return new MemberIterator(preCollection);
    }

    public int getPredecessorsCount() {
        int size = this.predecessors.size();
        return size;
    }

    public int getSuccessorsCount() {
        int size = this.successors.size();
        return size;
    }
}

