/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.producer.core.persistence.standard;

import java.util.List;
import net.ssehub.easy.producer.core.mgmt.PLPInfo;
import net.ssehub.easy.producer.core.persistence.PersistenceException;
import net.ssehub.easy.producer.core.persistence.datatypes.Entity;
import net.ssehub.easy.producer.core.persistence.datatypes.IPersistencer;
import net.ssehub.easy.producer.core.persistence.datatypes.Model;
import net.ssehub.easy.producer.core.persistence.datatypes.ModelType;
import net.ssehub.easy.producer.core.persistence.datatypes.PersistentProject;
import net.ssehub.easy.producer.core.persistence.standard.PersistenceConstants;
import net.ssehub.easy.reasoning.core.reasoner.AttributeValues;
import net.ssehub.easy.reasoning.core.reasoner.ReasonerConfiguration;
import net.ssehub.easy.varModel.confModel.ConfigurationException;
import net.ssehub.easy.varModel.model.Attribute;
import net.ssehub.easy.varModel.model.values.Value;

public class PLP2ProjectConverter
implements PersistenceConstants {
    private PLPInfo plp;
    private IPersistencer persistencer;

    public PLP2ProjectConverter(PLPInfo plp, IPersistencer persistencer) {
        this.plp = plp;
        this.persistencer = persistencer;
    }

    public PersistentProject plp2PersistentProject() throws PersistenceException {
        Entity entity;
        PersistentProject project = new PersistentProject(this.plp.getProjectLocation());
        Model model = project.getModel(ModelType.PREDECESSORS);
        for (PLPInfo member : this.plp.getMemberController().getPredecessors()) {
            entity = this.relative2Entity(member);
            model.addEntity(entity);
        }
        model = project.getModel(ModelType.SUCCESSORS);
        for (PLPInfo member : this.plp.getMemberController().getSuccessors()) {
            entity = this.relative2Entity(member);
            model.addEntity(entity);
        }
        model = project.getModel(ModelType.REASONERS);
        this.reasoner2Model(model, this.plp.getReasonerConfig());
        model = project.getModel(ModelType.SETTINGS);
        Entity entitySettings = new Entity();
        entitySettings.createAttribute("debug", Boolean.toString(this.plp.getSaveDebugInformation()));
        model.addEntity(entitySettings);
        ConfigurationException configException = null;
        try {
            this.plp.getConfiguration().toProject(false);
        }
        catch (ConfigurationException e) {
            configException = e;
        }
        project.setVarModel(this.plp.getProjectContainer());
        project.setID(this.plp.getProjectID());
        project.setName(this.plp.getProjectName());
        project.setScript(this.plp.getScriptContainer());
        if (null != configException) {
            throw new PersistenceException(configException.getLocalizedMessage());
        }
        return project;
    }

    private void reasoner2Model(Model reasonerModel, ReasonerConfiguration reasonerConfig) {
        Entity timeoutEntity = new Entity();
        timeoutEntity.createAttribute("timeout", String.valueOf(reasonerConfig.getTimeout()));
        reasonerModel.addEntity(timeoutEntity);
        AttributeValues attributes = reasonerConfig.getAttributeValues();
        if (null != attributes) {
            List attributeList = attributes.getAttributesAsList();
            for (int i = 0; i < attributeList.size(); ++i) {
                Entity attributeEntity = new Entity();
                Attribute currentAttribute = (Attribute)attributeList.get(i);
                attributeEntity.createAttribute("attribute", currentAttribute.getName());
                StringBuffer values = new StringBuffer();
                for (int j = 0; j < attributes.getAttributeValuesCount(currentAttribute); ++j) {
                    if (j > 0) {
                        values.append(";");
                    }
                    values.append(AttributeValues.toString((Value)attributes.getAttributeValue(currentAttribute, j)));
                }
                attributeEntity.createAttribute("values", values.toString());
                reasonerModel.addEntity(attributeEntity);
            }
        }
    }

    private Entity relative2Entity(PLPInfo info) {
        String tmp;
        Entity entity = new Entity();
        entity.createAttribute("id", info.getProjectID());
        entity.createAttribute("name", info.getProjectName());
        if (null != info.getVersion()) {
            entity.createAttribute("version", info.getVersion().toString());
        }
        if (null != (tmp = this.persistencer.getPathEnvironment().makeRelative(info.getProjectLocation()))) {
            entity.createAttributeFileString("location", tmp);
        }
        return entity;
    }
}

