/*
 * Decompiled with CFR 0.152.
 */
package net.sparkworks.cargo.client.impl;

import java.util.Collection;
import java.util.UUID;
import net.sparkworks.cargo.client.APIBaseClient;
import net.sparkworks.cargo.client.UnitConversionClient;
import net.sparkworks.cargo.client.config.CargoClientConfig;
import net.sparkworks.cargo.client.config.CargoInternalCommunicationConfiguration;
import net.sparkworks.cargo.common.dto.UnitConversionCreateDTO;
import net.sparkworks.cargo.common.dto.UnitConversionDTO;
import net.sparkworks.cargo.common.dto.UnitConversionQueryDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="CaRGOUnitConversionClientImplV2")
public class UnitConversionClientImpl
extends APIBaseClient
implements UnitConversionClient {
    private String accessToken;

    @Autowired
    public UnitConversionClientImpl(@Qualifier(value="cargoRestTemplate") RestOperations restTemplate, CargoClientConfig sparkworksCargoClientConfig, CargoInternalCommunicationConfiguration cargoInternalCommunicationConfiguration) {
        this.restTemplate = restTemplate;
        this.apiBaseUrl = sparkworksCargoClientConfig.getAddress() + (cargoInternalCommunicationConfiguration.isEnabled() ? "/internal" : "") + "/v2";
    }

    public UnitConversionClientImpl(String apiBaseUrl, String clientId, String clientSecret, String username, String password, String oauth2TokenUrl, String oauth2GrantType, String oauth2Scope) {
        super(apiBaseUrl, clientId, clientSecret, username, password, oauth2TokenUrl, oauth2GrantType, oauth2Scope);
    }

    public UnitConversionClientImpl(String apibaseUrl, String accessToken) {
        super(apibaseUrl);
        this.accessToken = accessToken;
    }

    @Override
    public Collection<UnitConversionDTO> listAll() {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/conversion")).toUriString(), HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Collection<UnitConversionDTO>>(){}, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (Collection)response.getBody();
    }

    @Override
    public UnitConversionDTO getByUUID(UUID uuid) {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/conversion/{uuid}")).buildAndExpand(new Object[]{uuid}).toUriString(), HttpMethod.GET, httpEntity, UnitConversionDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (UnitConversionDTO)response.getBody();
    }

    @Override
    public UnitConversionDTO create(UUID sourceUuid, UUID targetUuid, String method) {
        UnitConversionCreateDTO unitConversionCreateDTO = UnitConversionCreateDTO.builder().sourceUuid(sourceUuid).targetUuid(targetUuid).method(method).build();
        HttpEntity httpEntity = new HttpEntity((Object)unitConversionCreateDTO, this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/conversion")).toUriString(), HttpMethod.POST, httpEntity, UnitConversionDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (UnitConversionDTO)response.getBody();
    }

    @Override
    public Collection<UnitConversionDTO> query(UUID sourceUuid, UUID targetUuid, UUID uuid) {
        UnitConversionQueryDTO queryDTO = UnitConversionQueryDTO.builder().sourceUuid(sourceUuid).targetUuid(targetUuid).uuid(uuid).build();
        HttpEntity httpEntity = new HttpEntity((Object)queryDTO, this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/conversion/query")).toUriString(), HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Collection<UnitConversionDTO>>(){}, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (Collection)response.getBody();
    }

    @Override
    public void delete(UUID uuid) {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/conversion/{uuid}")).buildAndExpand(new Object[]{uuid}).toUriString(), HttpMethod.DELETE, httpEntity, Void.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
    }
}

