/*
 * Decompiled with CFR 0.152.
 */
package net.sparkworks.cargo.client.impl;

import java.util.Collection;
import java.util.UUID;
import net.sparkworks.cargo.client.APIBaseClient;
import net.sparkworks.cargo.client.ResourceClient;
import net.sparkworks.cargo.client.config.CargoClientConfig;
import net.sparkworks.cargo.client.config.CargoInternalCommunicationConfiguration;
import net.sparkworks.cargo.common.dto.ResourceCreateDTO;
import net.sparkworks.cargo.common.dto.ResourceDTO;
import net.sparkworks.cargo.common.dto.ResourceQueryDTO;
import net.sparkworks.cargo.common.dto.ResourceUpdateDTO;
import net.sparkworks.cargo.common.enumerator.ResourceType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="CaRGOResourceClientV2")
public class ResourceClientImpl
extends APIBaseClient
implements ResourceClient {
    private String accessToken;

    @Autowired
    public ResourceClientImpl(@Qualifier(value="cargoRestTemplate") RestOperations restTemplate, CargoClientConfig sparkworksCargoClientConfig, CargoInternalCommunicationConfiguration cargoInternalCommunicationConfiguration) {
        this.restTemplate = restTemplate;
        this.apiBaseUrl = sparkworksCargoClientConfig.getAddress() + (cargoInternalCommunicationConfiguration.isEnabled() ? "/internal" : "") + "/v2";
    }

    public ResourceClientImpl(String apiBaseUrl, String clientId, String clientSecret, String username, String password, String oauth2TokenUrl, String oauth2GrantType, String oauth2Scope) {
        super(apiBaseUrl, clientId, clientSecret, username, password, oauth2TokenUrl, oauth2GrantType, oauth2Scope);
    }

    public ResourceClientImpl(String apibaseUrl, String accessToken) {
        super(apibaseUrl);
        this.accessToken = accessToken;
    }

    @Override
    public Collection<ResourceDTO> listAll() {
        HttpHeaders headers = new HttpHeaders();
        if (this.accessToken != null) {
            headers.add((Object)"Authorization", (Object)("Bearer " + this.accessToken));
        }
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/resource")).toUriString(), HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Collection<ResourceDTO>>(){}, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (Collection)response.getBody();
    }

    @Override
    public ResourceDTO create(String systemName, String userFriendlyName, ResourceType type, String phenomenon, String unit, String controls, UUID groupUUID) {
        ResourceCreateDTO resourceCreateDTO = ResourceCreateDTO.builder().systemName(systemName).userFriendlyName(userFriendlyName).type(type).phenomenon(phenomenon).unit(unit).controls(controls).groupUUID(groupUUID).build();
        HttpEntity httpEntity = new HttpEntity((Object)resourceCreateDTO, this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/resource")).toUriString(), HttpMethod.POST, httpEntity, ResourceDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (ResourceDTO)response.getBody();
    }

    @Override
    public ResourceDTO getByUUID(UUID uuid) {
        HttpHeaders headers = new HttpHeaders();
        if (this.accessToken != null) {
            headers.add((Object)"Authorization", (Object)("Bearer " + this.accessToken));
        }
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/resource/{uuid}")).buildAndExpand(new Object[]{uuid}).toUriString(), HttpMethod.GET, httpEntity, ResourceDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (ResourceDTO)response.getBody();
    }

    @Override
    public ResourceDTO getBySystemName(String systemName) {
        ResourceQueryDTO resourceQueryDTO = ResourceQueryDTO.builder().systemName(systemName).build();
        HttpEntity httpEntity = new HttpEntity((Object)resourceQueryDTO, this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/resource/query")).toUriString(), HttpMethod.POST, httpEntity, ResourceDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (ResourceDTO)response.getBody();
    }

    @Override
    public Long count() {
        HttpHeaders headers = new HttpHeaders();
        if (this.accessToken != null) {
            headers.add((Object)"Authorization", (Object)("Bearer " + this.accessToken));
        }
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/resource/count")).toUriString(), HttpMethod.GET, httpEntity, Long.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (Long)response.getBody();
    }

    @Override
    public void delete(UUID uuid) {
        HttpHeaders headers = new HttpHeaders();
        if (this.accessToken != null) {
            headers.add((Object)"Authorization", (Object)("Bearer " + this.accessToken));
        }
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/resource/{uuid}")).buildAndExpand(new Object[]{uuid}).toUriString(), HttpMethod.DELETE, httpEntity, String.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
    }

    @Override
    public ResourceDTO move(UUID resourceUuid, UUID targetGroupUuid) {
        HttpHeaders headers = new HttpHeaders();
        if (this.accessToken != null) {
            headers.add((Object)"Authorization", (Object)("Bearer " + this.accessToken));
        }
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/resource/{uuid}/move/{targetUUID}")).buildAndExpand(new Object[]{resourceUuid, targetGroupUuid}).toUriString(), HttpMethod.POST, httpEntity, ResourceDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (ResourceDTO)response.getBody();
    }

    @Override
    public ResourceDTO update(UUID uuid, String userFriendlyName, ResourceType type, String controls, UUID phenomenonUuid, UUID unitUuid) {
        ResourceUpdateDTO updateDTO = ResourceUpdateDTO.builder().userFriendlyName(userFriendlyName).type(type).controls(controls).phenomenonUuid(phenomenonUuid).unitUuid(unitUuid).build();
        HttpEntity httpEntity = new HttpEntity((Object)updateDTO, this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/resource/{uuid}")).buildAndExpand(new Object[]{uuid}).toUriString(), HttpMethod.POST, httpEntity, ResourceDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (ResourceDTO)response.getBody();
    }
}

