/*
 * Decompiled with CFR 0.152.
 */
package net.sparkworks.cargo.client.impl;

import java.util.Collection;
import java.util.UUID;
import net.sparkworks.cargo.client.APIBaseClient;
import net.sparkworks.cargo.client.PhenomenonClient;
import net.sparkworks.cargo.client.config.CargoClientConfig;
import net.sparkworks.cargo.client.config.CargoInternalCommunicationConfiguration;
import net.sparkworks.cargo.common.dto.PhenomenonCreateDTO;
import net.sparkworks.cargo.common.dto.PhenomenonDTO;
import net.sparkworks.cargo.common.dto.PhenomenonQueryDTO;
import net.sparkworks.cargo.common.dto.PhenomenonUpdateDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="CaRGOPhenomenonClientImplV2")
public class PhenomenonClientImpl
extends APIBaseClient
implements PhenomenonClient {
    private String accessToken;

    @Autowired
    public PhenomenonClientImpl(@Qualifier(value="cargoRestTemplate") RestOperations restTemplate, CargoClientConfig sparkworksCargoClientConfig, CargoInternalCommunicationConfiguration cargoInternalCommunicationConfiguration) {
        this.restTemplate = restTemplate;
        this.apiBaseUrl = sparkworksCargoClientConfig.getAddress() + (cargoInternalCommunicationConfiguration.isEnabled() ? "/internal" : "") + "/v2";
    }

    public PhenomenonClientImpl(String apiBaseUrl, String clientId, String clientSecret, String username, String password, String oauth2TokenUrl, String oauth2GrantType, String oauth2Scope) {
        super(apiBaseUrl, clientId, clientSecret, username, password, oauth2TokenUrl, oauth2GrantType, oauth2Scope);
    }

    public PhenomenonClientImpl(String apibaseUrl, String accessToken) {
        super(apibaseUrl);
        this.accessToken = accessToken;
    }

    @Override
    public Collection<PhenomenonDTO> listAll() {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/phenomenon")).toUriString(), HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Collection<PhenomenonDTO>>(){}, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (Collection)response.getBody();
    }

    @Override
    public PhenomenonDTO getByUUID(UUID uuid) {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/phenomenon/{uuid}")).buildAndExpand(new Object[]{uuid}).toUriString(), HttpMethod.GET, httpEntity, PhenomenonDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (PhenomenonDTO)response.getBody();
    }

    @Override
    public PhenomenonDTO create(String name) {
        PhenomenonCreateDTO phenomenonCreateDTO = PhenomenonCreateDTO.builder().name(name).build();
        HttpEntity httpEntity = new HttpEntity((Object)phenomenonCreateDTO, this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/phenomenon")).toUriString(), HttpMethod.POST, httpEntity, PhenomenonDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (PhenomenonDTO)response.getBody();
    }

    @Override
    public PhenomenonDTO query(String name, UUID uuid) {
        PhenomenonQueryDTO queryDTO = PhenomenonQueryDTO.builder().name(name).uuid(uuid).build();
        HttpEntity httpEntity = new HttpEntity((Object)queryDTO, this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/phenomenon/query")).toUriString(), HttpMethod.POST, httpEntity, PhenomenonDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (PhenomenonDTO)response.getBody();
    }

    @Override
    public void delete(UUID uuid) {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/phenomenon/{uuid}")).buildAndExpand(new Object[]{uuid}).toUriString(), HttpMethod.DELETE, httpEntity, Void.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
    }

    @Override
    public PhenomenonDTO update(UUID uuid, String name) {
        PhenomenonUpdateDTO updateDTO = PhenomenonUpdateDTO.builder().name(name).build();
        HttpEntity httpEntity = new HttpEntity((Object)updateDTO, this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/phenomenon/{uuid}")).buildAndExpand(new Object[]{uuid}).toUriString(), HttpMethod.POST, httpEntity, PhenomenonDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (PhenomenonDTO)response.getBody();
    }
}

