/*
 * Decompiled with CFR 0.152.
 */
package net.sparkworks.cargo.client.impl;

import java.util.Collection;
import java.util.UUID;
import net.sparkworks.cargo.client.APIBaseClient;
import net.sparkworks.cargo.client.GroupClient;
import net.sparkworks.cargo.client.config.CargoClientConfig;
import net.sparkworks.cargo.client.config.CargoInternalCommunicationConfiguration;
import net.sparkworks.cargo.common.dto.GatewayDTO;
import net.sparkworks.cargo.common.dto.GroupCreateDTO;
import net.sparkworks.cargo.common.dto.GroupDTO;
import net.sparkworks.cargo.common.dto.GroupNodeDTO;
import net.sparkworks.cargo.common.dto.GroupUpdateDTO;
import net.sparkworks.cargo.common.dto.ResourceDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="CaRGOGroupClientImplV2")
public class GroupClientImpl
extends APIBaseClient
implements GroupClient {
    private String accessToken;

    @Autowired
    public GroupClientImpl(@Qualifier(value="cargoRestTemplate") RestOperations restTemplate, CargoClientConfig sparkworksCargoClientConfig, CargoInternalCommunicationConfiguration cargoInternalCommunicationConfiguration) {
        this.restTemplate = restTemplate;
        this.apiBaseUrl = sparkworksCargoClientConfig.getAddress() + (cargoInternalCommunicationConfiguration.isEnabled() ? "/internal" : "") + "/v2";
    }

    public GroupClientImpl(String apiBaseUrl, String clientId, String clientSecret, String username, String password, String oauth2TokenUrl, String oauth2GrantType, String oauth2Scope) {
        super(apiBaseUrl, clientId, clientSecret, username, password, oauth2TokenUrl, oauth2GrantType, oauth2Scope);
    }

    public GroupClientImpl(String apibaseUrl, String accessToken) {
        super(apibaseUrl);
        this.accessToken = accessToken;
    }

    @Override
    public Collection<GroupDTO> listAll() {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/group")).toUriString(), HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Collection<GroupDTO>>(){}, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (Collection)response.getBody();
    }

    @Override
    public GroupDTO create(String name, String path) {
        GroupCreateDTO groupCreateDTO = GroupCreateDTO.builder().name(name).parentPath(path).build();
        HttpEntity httpEntity = new HttpEntity((Object)groupCreateDTO, this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/group")).toUriString(), HttpMethod.POST, httpEntity, GroupDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (GroupDTO)response.getBody();
    }

    @Override
    public GroupDTO getByUUID(UUID uuid) {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/group/{uuid}")).buildAndExpand(new Object[]{uuid}).toUriString(), HttpMethod.GET, httpEntity, GroupDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (GroupDTO)response.getBody();
    }

    @Override
    public Long count() {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/group/count")).toUriString(), HttpMethod.GET, httpEntity, Long.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (Long)response.getBody();
    }

    @Override
    public void delete(UUID uuid) {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/group/{uuid}")).buildAndExpand(new Object[]{uuid}).toUriString(), HttpMethod.DELETE, httpEntity, Void.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
    }

    @Override
    public void move(UUID sourceUUID, UUID targetUUID) {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/group/move/{sourceUUID}/{targetUUID}")).buildAndExpand(new Object[]{sourceUUID, targetUUID}).toUriString(), HttpMethod.POST, httpEntity, Void.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
    }

    @Override
    public Collection<ResourceDTO> getGroupResources(UUID uuid) {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/group/{uuid}/resource")).buildAndExpand(new Object[]{uuid}).toUriString(), HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Collection<ResourceDTO>>(){}, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (Collection)response.getBody();
    }

    @Override
    public Collection<GroupDTO> getSubGroups(UUID uuid, int depth) {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/group/{uuid}/subgroup/{depth}")).buildAndExpand(new Object[]{uuid, depth}).toUriString(), HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Collection<GroupDTO>>(){}, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (Collection)response.getBody();
    }

    @Override
    public Collection<GatewayDTO> getGroupGateways(UUID uuid) {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/group/{uuid}/gateway")).buildAndExpand(new Object[]{uuid}).toUriString(), HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Collection<GatewayDTO>>(){}, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (Collection)response.getBody();
    }

    @Override
    public Collection<GroupDTO> getRootGroups() {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/group/main")).toUriString(), HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Collection<GroupDTO>>(){}, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (Collection)response.getBody();
    }

    @Override
    public GroupDTO update(UUID uuid, String name) {
        GroupUpdateDTO groupUpdateDTO = GroupUpdateDTO.builder().name(name).build();
        HttpEntity httpEntity = new HttpEntity((Object)groupUpdateDTO, this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/group/{uuid}")).buildAndExpand(new Object[]{uuid}).toUriString(), HttpMethod.POST, httpEntity, GroupDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (GroupDTO)response.getBody();
    }

    @Override
    public GroupNodeDTO getGroupsTree() {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromHttpUrl((String)(this.apiBaseUrl + "/group/tree")).toUriString(), HttpMethod.GET, httpEntity, GroupNodeDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (GroupNodeDTO)response.getBody();
    }
}

