/*
 * Decompiled with CFR 0.152.
 */
package net.sparkworks.cargo.client.impl;

import java.util.Collection;
import java.util.UUID;
import net.sparkworks.cargo.client.APIBaseClient;
import net.sparkworks.cargo.client.GatewayClient;
import net.sparkworks.cargo.client.config.CargoClientConfig;
import net.sparkworks.cargo.client.config.CargoInternalCommunicationConfiguration;
import net.sparkworks.cargo.common.dto.GatewayCreateDTO;
import net.sparkworks.cargo.common.dto.GatewayDTO;
import net.sparkworks.cargo.common.dto.GatewayQueryDTO;
import net.sparkworks.cargo.common.dto.ResourceDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="CaRGOGatewayClientV2")
public class GatewayClientImpl
extends APIBaseClient
implements GatewayClient {
    private String accessToken;

    @Autowired
    public GatewayClientImpl(@Qualifier(value="cargoRestTemplate") RestOperations restTemplate, CargoClientConfig sparkworksCargoClientConfig, CargoInternalCommunicationConfiguration cargoInternalCommunicationConfiguration) {
        this.restTemplate = restTemplate;
        this.apiBaseUrl = sparkworksCargoClientConfig.getAddress() + (cargoInternalCommunicationConfiguration.isEnabled() ? "/internal" : "") + "/v2";
    }

    public GatewayClientImpl(String apiBaseUrl, String clientId, String clientSecret, String username, String password, String oauth2TokenUrl, String oauth2GrantType, String oauth2Scope) {
        super(apiBaseUrl, clientId, clientSecret, username, password, oauth2TokenUrl, oauth2GrantType, oauth2Scope);
    }

    public GatewayClientImpl(String apibaseUrl, String accessToken) {
        super(apibaseUrl);
        this.accessToken = accessToken;
    }

    @Override
    public Collection<GatewayDTO> listAll() {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/gateway")).toUriString(), HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Collection<GatewayDTO>>(){}, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (Collection)response.getBody();
    }

    @Override
    public GatewayDTO getByUUID(UUID uuid) {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/gateway/{uuid}")).buildAndExpand(new Object[]{uuid}).toUriString(), HttpMethod.GET, httpEntity, GatewayDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (GatewayDTO)response.getBody();
    }

    @Override
    public GatewayDTO getBySystemName(String systemName) {
        GatewayQueryDTO gatewayQueryDTO = GatewayQueryDTO.builder().systemName(systemName).build();
        HttpEntity httpEntity = new HttpEntity((Object)gatewayQueryDTO, this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/gateway/query")).toUriString(), HttpMethod.POST, httpEntity, GatewayDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (GatewayDTO)response.getBody();
    }

    @Override
    public GatewayDTO create(String systemName, UUID groupUUID) {
        GatewayCreateDTO gatewayCreateDTO = GatewayCreateDTO.builder().systemName(systemName).groupUUID(groupUUID).build();
        HttpEntity httpEntity = new HttpEntity((Object)gatewayCreateDTO, this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/gateway")).toUriString(), HttpMethod.POST, httpEntity, GatewayDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (GatewayDTO)response.getBody();
    }

    @Override
    public Long count() {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/gateway/count")).toUriString(), HttpMethod.GET, httpEntity, Long.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (Long)response.getBody();
    }

    @Override
    public void delete(UUID uuid) {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/gateway/{uuid}")).buildAndExpand(new Object[]{uuid}).toUriString(), HttpMethod.DELETE, httpEntity, GatewayDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
    }

    @Override
    public Collection<ResourceDTO> getResources(UUID gatewayUuid) {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/gateway/{uuid}/resource")).buildAndExpand(new Object[]{gatewayUuid}).toUriString(), HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Collection<ResourceDTO>>(){}, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (Collection)response.getBody();
    }
}

