/*
 * Decompiled with CFR 0.152.
 */
package net.sparkworks.cargo.client.impl;

import java.util.UUID;
import net.sparkworks.cargo.client.APIBaseClient;
import net.sparkworks.cargo.client.DataClient;
import net.sparkworks.cargo.client.config.CargoClientConfig;
import net.sparkworks.cargo.client.config.CargoInternalCommunicationConfiguration;
import net.sparkworks.cargo.common.dto.data.LatestDTO;
import net.sparkworks.cargo.common.dto.data.PublishDataListDTO;
import net.sparkworks.cargo.common.dto.data.QueryLatestResourceDataDTO;
import net.sparkworks.cargo.common.dto.data.QueryLatestResourceDataResultDTO;
import net.sparkworks.cargo.common.dto.data.QueryTimeRangeResourceDataDTO;
import net.sparkworks.cargo.common.dto.data.QueryTimeRangeResourceDataResultDTO;
import net.sparkworks.cargo.common.dto.data.SummaryDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="CaRGODataClientV2")
public class DataClientImpl
extends APIBaseClient
implements DataClient {
    private String accessToken;

    @Autowired
    public DataClientImpl(@Qualifier(value="cargoRestTemplate") RestOperations restTemplate, CargoClientConfig sparkworksClientConfig, CargoInternalCommunicationConfiguration internalCommunicationConfiguration) {
        this.restTemplate = restTemplate;
        this.apiBaseUrl = sparkworksClientConfig.getAddress() + (internalCommunicationConfiguration.isEnabled() ? "/internal" : "") + "/v2";
    }

    public DataClientImpl(String apiBaseUrl, String clientId, String clientSecret, String username, String password, String oauth2TokenUrl, String oauth2GrantType, String oauth2Scope) {
        super(apiBaseUrl, clientId, clientSecret, username, password, oauth2TokenUrl, oauth2GrantType, oauth2Scope);
    }

    public DataClientImpl(String apibaseUrl, String accessToken) {
        super(apibaseUrl);
        this.accessToken = accessToken;
    }

    @Override
    public SummaryDTO getLatestSummary(UUID resourceUuid) {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/resource/{resourceId}/summary")).buildAndExpand(new Object[]{resourceUuid}).toUriString(), HttpMethod.GET, httpEntity, SummaryDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (SummaryDTO)response.getBody();
    }

    @Override
    public LatestDTO getLatestValues(UUID resourceUuid) {
        HttpEntity httpEntity = new HttpEntity(this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/resource/{resourceId}/latest")).buildAndExpand(new Object[]{resourceUuid}).toUriString(), HttpMethod.GET, httpEntity, LatestDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (LatestDTO)response.getBody();
    }

    @Override
    public QueryLatestResourceDataResultDTO queryLatestResourcesData(QueryLatestResourceDataDTO queryLatestResourceDataDTO) {
        HttpEntity httpEntity = new HttpEntity((Object)queryLatestResourceDataDTO, this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/resource/query/latest")).toUriString(), HttpMethod.POST, httpEntity, QueryLatestResourceDataResultDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (QueryLatestResourceDataResultDTO)response.getBody();
    }

    @Override
    public QueryTimeRangeResourceDataResultDTO queryTimeRangeResourcesData(QueryTimeRangeResourceDataDTO queryTimeRangeResourceDataDTO) {
        HttpEntity httpEntity = new HttpEntity((Object)queryTimeRangeResourceDataDTO, this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/resource/query/timerange")).toUriString(), HttpMethod.POST, httpEntity, QueryTimeRangeResourceDataResultDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (QueryTimeRangeResourceDataResultDTO)response.getBody();
    }

    @Override
    public PublishDataListDTO publishData(PublishDataListDTO publishDataListDTO) {
        HttpEntity httpEntity = new HttpEntity((Object)publishDataListDTO, this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(this.apiBaseUrl + "/resource/data/publish", HttpMethod.POST, httpEntity, PublishDataListDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (PublishDataListDTO)response.getBody();
    }
}

