/*
 * Decompiled with CFR 0.152.
 */
package net.sparkworks.cargo.client.impl;

import java.util.UUID;
import net.sparkworks.cargo.client.APIBaseClient;
import net.sparkworks.cargo.client.CommandClient;
import net.sparkworks.cargo.client.config.CargoClientConfig;
import net.sparkworks.cargo.client.config.CargoInternalCommunicationConfiguration;
import net.sparkworks.cargo.common.dto.CommandDTO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestOperations;
import org.springframework.web.util.UriComponentsBuilder;

@Component(value="CaRGOCommandClientImplV2")
public class CommandClientImpl
extends APIBaseClient
implements CommandClient {
    private String accessToken;

    @Autowired
    public CommandClientImpl(@Qualifier(value="cargoRestTemplate") RestOperations restTemplate, CargoClientConfig sparkworksCargoClientConfig, CargoInternalCommunicationConfiguration cargoInternalCommunicationConfiguration) {
        this.restTemplate = restTemplate;
        this.apiBaseUrl = sparkworksCargoClientConfig.getAddress() + (cargoInternalCommunicationConfiguration.isEnabled() ? "/internal" : "") + "/v2";
    }

    public CommandClientImpl(String apiBaseUrl, String clientId, String clientSecret, String username, String password, String oauth2TokenUrl, String oauth2GrantType, String oauth2Scope) {
        super(apiBaseUrl, clientId, clientSecret, username, password, oauth2TokenUrl, oauth2GrantType, oauth2Scope);
    }

    public CommandClientImpl(String apibaseUrl, String accessToken) {
        super(apibaseUrl);
        this.accessToken = accessToken;
    }

    @Override
    public CommandDTO sendCommand(UUID resourceUuid, String command) {
        CommandDTO commandDTO = CommandDTO.builder().command(command).build();
        HttpEntity httpEntity = new HttpEntity((Object)commandDTO, this.prepareHeaders(this.accessToken));
        ResponseEntity response = this.restTemplate.exchange(UriComponentsBuilder.fromUriString((String)(this.apiBaseUrl + "/command/{uuid}")).buildAndExpand(new Object[]{resourceUuid}).toUriString(), HttpMethod.POST, httpEntity, CommandDTO.class, new Object[0]);
        if (!response.getStatusCode().is2xxSuccessful()) {
            throw new RestClientException(response.toString());
        }
        return (CommandDTO)response.getBody();
    }
}

