/*
 * Decompiled with CFR 0.152.
 */
package net.sparkworks.cargo.client.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.ResponseErrorHandler;

public class SparkworksResponseErrorHandler
implements ResponseErrorHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(SparkworksResponseErrorHandler.class);

    public boolean hasError(ClientHttpResponse clientHttpResponse) throws IOException {
        return clientHttpResponse.getStatusCode() != HttpStatus.OK;
    }

    public void handleError(ClientHttpResponse clientHttpResponse) throws IOException {
        if (clientHttpResponse.getStatusCode() != HttpStatus.OK) {
            LOGGER.debug("Status code: " + clientHttpResponse.getStatusCode());
            LOGGER.debug("Response" + clientHttpResponse.getStatusText());
            StringWriter writer = new StringWriter();
            try {
                IOUtils.copy((InputStream)clientHttpResponse.getBody(), (Writer)writer, (Charset)Charset.defaultCharset());
                LOGGER.debug(writer.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

