/*
 * Decompiled with CFR 0.152.
 */
package net.sparkworks.cargo.client.config;

import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import net.sparkworks.cargo.client.config.CargoClientAuthConfig;
import net.sparkworks.cargo.client.config.CargoInternalCommunicationConfiguration;
import net.sparkworks.cargo.client.config.CargoSslConfiguration;
import net.sparkworks.common.client.InternalCommunicationRestTemplateFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.MediaType;
import org.springframework.http.converter.FormHttpMessageConverter;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.ResourceHttpMessageConverter;
import org.springframework.http.converter.StringHttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.security.oauth2.client.DefaultOAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2ClientContext;
import org.springframework.security.oauth2.client.OAuth2RestTemplate;
import org.springframework.security.oauth2.client.resource.OAuth2ProtectedResourceDetails;
import org.springframework.security.oauth2.client.token.AccessTokenRequest;
import org.springframework.security.oauth2.client.token.DefaultAccessTokenRequest;
import org.springframework.security.oauth2.client.token.grant.password.ResourceOwnerPasswordResourceDetails;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableOAuth2Client;
import org.springframework.web.client.RestOperations;
import org.springframework.web.client.RestTemplate;

@Configuration
@EnableOAuth2Client
public class CargoRestTemplateConfig {
    private static final Logger log = LoggerFactory.getLogger(CargoRestTemplateConfig.class);
    public static final String SW_CARGO_REST_TEMPLATE_NAME = "cargoRestTemplate";
    private final CargoClientAuthConfig sparkworksCargoClientAuthConfig;
    private final CargoSslConfiguration cargoSslConfiguration;
    private final CargoInternalCommunicationConfiguration cargoInternalCommunicationConfiguration;

    public CargoRestTemplateConfig(@Autowired(required=false) CargoClientAuthConfig sparkworksCargoClientAuthConfig, @Autowired(required=false) CargoSslConfiguration cargoSslConfiguration, CargoInternalCommunicationConfiguration cargoInternalCommunicationConfiguration) {
        this.sparkworksCargoClientAuthConfig = sparkworksCargoClientAuthConfig;
        this.cargoSslConfiguration = cargoSslConfiguration;
        this.cargoInternalCommunicationConfiguration = cargoInternalCommunicationConfiguration;
    }

    public OAuth2ProtectedResourceDetails oAuth2ProtectedResourceDetails() {
        ResourceOwnerPasswordResourceDetails resource = new ResourceOwnerPasswordResourceDetails();
        resource.setAccessTokenUri(this.sparkworksCargoClientAuthConfig.getAccessTokenUrl());
        resource.setClientId(this.sparkworksCargoClientAuthConfig.getClientId());
        resource.setClientSecret(this.sparkworksCargoClientAuthConfig.getClientSecret());
        resource.setGrantType(this.sparkworksCargoClientAuthConfig.getGrantType());
        resource.setScope(this.sparkworksCargoClientAuthConfig.getScope());
        resource.setUsername(this.sparkworksCargoClientAuthConfig.getUsername());
        resource.setPassword(this.sparkworksCargoClientAuthConfig.getPassword());
        return resource;
    }

    @Bean(name={"cargoRestTemplate"})
    public RestOperations restTemplate() {
        if (!this.cargoInternalCommunicationConfiguration.isEnabled()) {
            this.configureSslOnDisabledInternalCommunication();
        }
        DefaultAccessTokenRequest atr = new DefaultAccessTokenRequest();
        MappingJackson2HttpMessageConverter jackson = new MappingJackson2HttpMessageConverter();
        jackson.setSupportedMediaTypes(Arrays.asList(MediaType.ALL));
        ResourceHttpMessageConverter resource = new ResourceHttpMessageConverter();
        FormHttpMessageConverter formHttpMessageConverter = new FormHttpMessageConverter();
        formHttpMessageConverter.addPartConverter((HttpMessageConverter)jackson);
        formHttpMessageConverter.addPartConverter((HttpMessageConverter)resource);
        RestTemplate restTemplate = this.cargoInternalCommunicationConfiguration.isEnabled() ? InternalCommunicationRestTemplateFactory.internalCommunicationRestTemplate() : new OAuth2RestTemplate(this.oAuth2ProtectedResourceDetails(), (OAuth2ClientContext)new DefaultOAuth2ClientContext((AccessTokenRequest)atr));
        restTemplate.setMessageConverters(Arrays.asList(new StringHttpMessageConverter(), new MappingJackson2HttpMessageConverter(), jackson, resource, formHttpMessageConverter));
        return restTemplate;
    }

    private void configureSslOnDisabledInternalCommunication() {
        if (this.cargoSslConfiguration.isDisableCnCheck()) {
            HttpsURLConnection.setDefaultHostnameVerifier((hostname, session) -> true);
        }
        if (this.cargoSslConfiguration.isDisableCertValidation()) {
            this.disableSSLCertificateChecking();
        }
    }

    private void disableSSLCertificateChecking() {
        TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] arg0, String arg1) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] arg0, String arg1) {
            }
        }};
        try {
            SSLContext sc = SSLContext.getInstance("TLS");
            sc.init(null, trustAllCerts, new SecureRandom());
            HttpsURLConnection.setDefaultSSLSocketFactory(sc.getSocketFactory());
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

